/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.validator;

import io.gravitee.rest.api.service.PasswordValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class RegexPasswordValidator
implements PasswordValidator,
InitializingBean {
    private Pattern pattern;
    private Matcher matcher;
    @Value(value="${user.password.policy.pattern:^(?=\\s*\\S).*$}")
    private String passwordPattern;

    public RegexPasswordValidator() {
    }

    public RegexPasswordValidator(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean validate(String password) {
        this.matcher = this.pattern.matcher(password);
        return this.matcher.matches();
    }

    public void afterPropertiesSet() {
        this.pattern = Pattern.compile(this.passwordPattern);
    }
}

