/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiNotManagedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiStateService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiStateServiceImpl
implements ApiStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiStateServiceImpl.class);
    private final ApiSearchService apiSearchService;
    private final ApiRepository apiRepository;
    private final ApiMapper apiMapper;
    private final ApiNotificationService apiNotificationService;
    private final PrimaryOwnerService primaryOwnerService;
    private final AuditService auditService;
    private final EventService eventService;
    private final ObjectMapper objectMapper;

    public ApiStateServiceImpl(ApiSearchService apiSearchService, @Lazy ApiRepository apiRepository, ApiMapper apiMapper, ApiNotificationService apiNotificationService, PrimaryOwnerService primaryOwnerService, AuditService auditService, EventService eventService, ObjectMapper objectMapper) {
        this.apiSearchService = apiSearchService;
        this.apiRepository = apiRepository;
        this.apiMapper = apiMapper;
        this.apiNotificationService = apiNotificationService;
        this.primaryOwnerService = primaryOwnerService;
        this.auditService = auditService;
        this.eventService = eventService;
        this.objectMapper = objectMapper;
    }

    @Override
    public ApiEntity deploy(ExecutionContext executionContext, String apiId, String authenticatedUser, ApiDeploymentEntity apiDeploymentEntity) {
        log.debug("Deploy API: {}", (Object)apiId);
        try {
            Api api = this.apiSearchService.findRepositoryApiById(executionContext, apiId);
            if (DefinitionContext.isKubernetes((String)api.getOrigin())) {
                throw new ApiNotManagedException("The api is managed externally (" + api.getOrigin() + "). Unable to deploy it.");
            }
            api.setUpdatedAt(new Date());
            api.setDeployedAt(api.getUpdatedAt());
            api = (Api)this.apiRepository.update((Object)api);
            api.setPicture(null);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.API_ID.getValue(), api.getId());
            properties.put(Event.EventProperties.USER.getValue(), authenticatedUser);
            this.addDeploymentLabelToProperties(executionContext, apiId, properties, apiDeploymentEntity);
            this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), EventType.PUBLISH_API, api, properties);
            PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, api.getId());
            ApiEntity deployed = this.apiMapper.toEntity(api, primaryOwner);
            this.apiNotificationService.triggerDeployNotification(executionContext, (GenericApiEntity)deployed);
            return deployed;
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to deploy API: {}", (Object)apiId, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to deploy API: " + apiId, e);
        }
    }

    private void addDeploymentLabelToProperties(ExecutionContext executionContext, String apiId, Map<String, String> properties, ApiDeploymentEntity apiDeploymentEntity) {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(EventType.PUBLISH_API));
        Optional<EventEntity> optEvent = this.eventService.search(executionContext, query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        String lastDeployNumber = optEvent.isPresent() ? optEvent.get().getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0") : "0";
        String newDeployNumber = Long.toString(Long.parseLong(lastDeployNumber) + 1L);
        properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), newDeployNumber);
        if (apiDeploymentEntity != null && StringUtils.isNotEmpty((CharSequence)apiDeploymentEntity.getDeploymentLabel())) {
            properties.put(Event.EventProperties.DEPLOYMENT_LABEL.getValue(), apiDeploymentEntity.getDeploymentLabel());
        }
    }

    @Override
    public ApiEntity start(ExecutionContext executionContext, String apiId, String userId) {
        try {
            log.debug("Start API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(executionContext, apiId, LifecycleState.STARTED, userId);
            this.apiNotificationService.triggerStartNotification(executionContext, (GenericApiEntity)apiEntity);
            return apiEntity;
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to start API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to start API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity stop(ExecutionContext executionContext, String apiId, String userId) {
        try {
            log.debug("Stop API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(executionContext, apiId, LifecycleState.STOPPED, userId);
            this.apiNotificationService.triggerStopNotification(executionContext, (GenericApiEntity)apiEntity);
            return apiEntity;
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to stop API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to stop API " + apiId, ex);
        }
    }

    private ApiEntity updateLifecycle(ExecutionContext executionContext, String apiId, LifecycleState lifecycleState, String username) throws TechnicalException {
        Optional optApi = this.apiRepository.findById((Object)apiId);
        if (optApi.isPresent()) {
            ApiEntity deployedApi;
            Api api = (Api)optApi.get();
            Api previousApi = new Api(api);
            api.setUpdatedAt(new Date());
            api.setLifecycleState(lifecycleState);
            Api updateApi = (Api)this.apiRepository.update((Object)api);
            ApiEntity apiEntity = this.apiMapper.toEntity(updateApi, this.primaryOwnerService.getPrimaryOwner(executionContext, api.getId()));
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
            EventType eventType = null;
            switch (lifecycleState) {
                case STARTED: {
                    eventType = EventType.START_API;
                    break;
                }
                case STOPPED: {
                    eventType = EventType.STOP_API;
                    break;
                }
            }
            if (!DefinitionContext.isKubernetes((String)updateApi.getOrigin()) && (deployedApi = this.deployLastPublishedAPI(executionContext, apiId, username, eventType)) != null) {
                return deployedApi;
            }
            return apiEntity;
        }
        throw new ApiNotFoundException(apiId);
    }

    private ApiEntity deployLastPublishedAPI(ExecutionContext executionContext, String apiId, String userId, EventType eventType) throws TechnicalException {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(EventType.PUBLISH_API));
        Optional<EventEntity> optEvent = this.eventService.search(executionContext, query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        try {
            if (optEvent.isPresent()) {
                EventEntity event = optEvent.get();
                JsonNode node = this.objectMapper.readTree(event.getPayload());
                Api lastPublishedAPI = (Api)this.objectMapper.convertValue((Object)node, Api.class);
                lastPublishedAPI.setLifecycleState(this.convert(eventType));
                lastPublishedAPI.setUpdatedAt(new Date());
                lastPublishedAPI.setDeployedAt(new Date());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.API_ID.getValue(), lastPublishedAPI.getId());
                properties.put(Event.EventProperties.USER.getValue(), userId);
                lastPublishedAPI.setPicture(null);
                this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), eventType, lastPublishedAPI, properties);
                return null;
            }
            return this.deploy(executionContext, apiId, userId, new ApiDeploymentEntity());
        }
        catch (Exception e) {
            log.error("An error occurs while trying to deploy last published API {}", (Object)apiId, (Object)e);
            throw new TechnicalException("An error occurs while trying to deploy last published API " + apiId, (Throwable)e);
        }
    }

    private LifecycleState convert(EventType eventType) {
        LifecycleState lifecycleState;
        switch (eventType) {
            case START_API: {
                lifecycleState = LifecycleState.STARTED;
                break;
            }
            case STOP_API: {
                lifecycleState = LifecycleState.STOPPED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EventType " + eventType + " to convert EventType into Lifecycle");
            }
        }
        return lifecycleState;
    }
}

