/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ParameterRepository;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.repository.management.model.ParameterReferenceType;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class DefaultParameterUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultParameterUpgrader.class);
    @Lazy
    @Autowired
    private ParameterRepository parameterRepository;
    @Autowired
    private ConfigurableEnvironment environment;

    @Override
    public boolean upgrade() {
        try {
            String envPortalURL = this.environment.getProperty("portalURL", Key.MANAGEMENT_URL.defaultValue());
            if (envPortalURL != null) {
                Optional optionalParameter = this.parameterRepository.findById(Key.MANAGEMENT_URL.key(), GraviteeContext.getDefaultOrganization(), ParameterReferenceType.ORGANIZATION);
                if (!optionalParameter.isPresent()) {
                    Parameter managementURLParam = new Parameter();
                    managementURLParam.setKey(Key.MANAGEMENT_URL.key());
                    managementURLParam.setValue(envPortalURL);
                    managementURLParam.setReferenceType(ParameterReferenceType.ORGANIZATION);
                    managementURLParam.setReferenceId(GraviteeContext.getDefaultOrganization());
                    this.parameterRepository.create(managementURLParam);
                } else if (StringUtils.isEmpty((CharSequence)((Parameter)optionalParameter.get()).getValue())) {
                    Parameter managementURLParam = (Parameter)optionalParameter.get();
                    managementURLParam.setValue(envPortalURL);
                    this.parameterRepository.update(managementURLParam);
                }
            }
        }
        catch (TechnicalException e) {
            this.logger.error("Error while updating 'management.url' parameter : {}", (Throwable)e);
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 200;
    }
}

