/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AlertTriggerRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.model.AlertTrigger;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Application;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.converter.AlertTriggerConverter;
import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.impl.upgrade.OneShotUpgrader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AlertsEnvironmentUpgrader
extends OneShotUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertsEnvironmentUpgrader.class);
    private final AlertTriggerRepository alertTriggerRepository;
    private final AlertTriggerConverter alertTriggerConverter;
    private final ApiRepository apiRepository;
    private final ApplicationRepository applicationRepository;

    @Autowired
    public AlertsEnvironmentUpgrader(@Lazy AlertTriggerRepository alertTriggerRepository, AlertTriggerConverter alertTriggerConverter, @Lazy ApiRepository apiRepository, @Lazy ApplicationRepository applicationRepository) {
        super("ALERTS_ENVIRONMENT_UPGRADER");
        this.alertTriggerRepository = alertTriggerRepository;
        this.alertTriggerConverter = alertTriggerConverter;
        this.apiRepository = apiRepository;
        this.applicationRepository = applicationRepository;
    }

    @Override
    public int getOrder() {
        return 500;
    }

    @Override
    protected void processOneShotUpgrade() throws TechnicalException {
        this.alertTriggerRepository.findAll().forEach(alertTrigger -> {
            try {
                switch (alertTrigger.getReferenceType()) {
                    case "PLATFORM": {
                        this.handlePlatformAlert((AlertTrigger)alertTrigger);
                        break;
                    }
                    case "API": {
                        this.handleApiAlert((AlertTrigger)alertTrigger);
                        break;
                    }
                    case "APPLICATION": {
                        this.handleApplicationAlert((AlertTrigger)alertTrigger);
                    }
                }
            }
            catch (TechnicalException | AbstractNotFoundException e) {
                LOGGER.error("Failed to update alert {}", (Object)alertTrigger.getId(), (Object)e);
            }
        });
    }

    private void handlePlatformAlert(AlertTrigger alertTrigger) {
        try {
            this.updateEnvironmentAlertReferences(GraviteeContext.getDefaultEnvironment(), alertTrigger);
        }
        catch (TechnicalException e) {
            LOGGER.error("Failed to handle alert {}", (Object)alertTrigger.getId(), (Object)e);
        }
    }

    private void handleApiAlert(AlertTrigger alertTrigger) throws TechnicalException {
        Api api = (Api)this.apiRepository.findById((Object)alertTrigger.getReferenceId()).orElseThrow(() -> new ApiNotFoundException(alertTrigger.getReferenceId()));
        this.updateAlertEnvironment(api.getEnvironmentId(), alertTrigger);
    }

    private void handleApplicationAlert(AlertTrigger alertTrigger) throws TechnicalException {
        Application application = (Application)this.applicationRepository.findById((Object)alertTrigger.getReferenceId()).orElseThrow(() -> new ApplicationNotFoundException(alertTrigger.getReferenceId()));
        this.updateAlertEnvironment(application.getEnvironmentId(), alertTrigger);
    }

    private void updateAlertEnvironment(String environmentId, AlertTrigger alertTrigger) throws TechnicalException {
        AlertTriggerEntity alertTriggerEntity = this.alertTriggerConverter.toAlertTriggerEntity(alertTrigger);
        alertTriggerEntity.setEnvironmentId(environmentId);
        this.alertTriggerRepository.update((Object)this.alertTriggerConverter.toAlertTrigger(alertTriggerEntity));
    }

    private void updateEnvironmentAlertReferences(String environmentId, AlertTrigger alertTrigger) throws TechnicalException {
        alertTrigger.setReferenceType(AlertReferenceType.ENVIRONMENT.name());
        AlertTriggerEntity alertTriggerEntity = this.alertTriggerConverter.toAlertTriggerEntity(alertTrigger);
        alertTriggerEntity.setReferenceType(AlertReferenceType.ENVIRONMENT);
        alertTriggerEntity.setReferenceId(environmentId);
        alertTriggerEntity.setEnvironmentId(environmentId);
        this.alertTriggerRepository.update((Object)this.alertTriggerConverter.toAlertTrigger(alertTriggerEntity));
    }
}

