/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;

public abstract class EnvironmentUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentUpgrader.class);
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;

    protected abstract void upgradeEnvironment(ExecutionContext var1);

    @Override
    public final boolean upgrade() {
        try {
            this.environmentRepository.findAll().forEach(environment -> {
                ExecutionContext executionContext = new ExecutionContext((Environment)environment);
                LOGGER.info("Starting {} for {}", (Object)this.getClass().getSimpleName(), (Object)executionContext);
                this.upgradeEnvironment(executionContext);
            });
        }
        catch (TechnicalException e) {
            LOGGER.error("{} execution failed", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }
}

