/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class StillPrimaryOwnerException
extends AbstractManagementException {
    private final long apiCount;
    private final long applicationCount;
    private final ApiPrimaryOwnerMode primaryOwnerMode;

    public StillPrimaryOwnerException(long apiCount, long applicationCount) {
        this.apiCount = apiCount;
        this.applicationCount = applicationCount;
        this.primaryOwnerMode = ApiPrimaryOwnerMode.USER;
    }

    public StillPrimaryOwnerException(long apiCount, ApiPrimaryOwnerMode primaryOwnerMode) {
        this.apiCount = apiCount;
        this.applicationCount = 0L;
        this.primaryOwnerMode = primaryOwnerMode;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        String message = "The " + this.primaryOwnerMode.name().toLowerCase() + " is still primary owner of '" + this.apiCount + "' APIs";
        if (ApiPrimaryOwnerMode.USER == this.primaryOwnerMode) {
            message = message + " and '" + this.applicationCount + "' Applications.";
        }
        return message;
    }

    @Override
    public String getTechnicalCode() {
        return this.primaryOwnerMode.name().toLowerCase() + ".notDeletable";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("apiCount", String.valueOf(this.apiCount));
        parameters.put("applicationCount", String.valueOf(this.applicationCount));
        parameters.put("primaryOwnerMode", this.primaryOwnerMode.name());
        return parameters;
    }
}

