/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.transformer;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.util.BytesRef;
import org.springframework.stereotype.Component;

@Component
public class ApiDocumentTransformer
implements DocumentTransformer<GenericApiEntity> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_TYPE_VALUE = "api";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NAME_LOWERCASE = "name_lowercase";
    public static final String FIELD_NAME_SORTED = "name_sorted";
    public static final String FIELD_NAME_SPLIT = "name_split";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_DESCRIPTION_LOWERCASE = "description_lowercase";
    public static final String FIELD_DESCRIPTION_SPLIT = "description_split";
    public static final String FIELD_OWNER = "ownerName";
    public static final String FIELD_OWNER_LOWERCASE = "ownerName_lowercase";
    public static final String FIELD_OWNER_MAIL = "ownerMail";
    public static final String FIELD_LABELS = "labels";
    public static final String FIELD_LABELS_LOWERCASE = "labels_lowercase";
    public static final String FIELD_LABELS_SPLIT = "labels_split";
    public static final String FIELD_CATEGORIES = "categories";
    public static final String FIELD_CATEGORIES_SPLIT = "categories_split";
    public static final String FIELD_CREATED_AT = "createdAt";
    public static final String FIELD_UPDATED_AT = "updatedAt";
    public static final String FIELD_PATHS = "paths";
    public static final String FIELD_HOSTS = "hosts";
    public static final String FIELD_PATHS_SORTED = "paths_sorted";
    public static final String FIELD_PATHS_SPLIT = "paths_split";
    public static final String FIELD_HOSTS_SPLIT = "hosts_split";
    public static final String FIELD_TAGS = "tags";
    public static final String FIELD_TAGS_SPLIT = "tags_split";
    public static final String FIELD_METADATA = "metadata";
    public static final String FIELD_METADATA_SPLIT = "metadata_split";
    private static final Pattern SPECIAL_CHARS = Pattern.compile("[|\\-+!(){}^\"~*?:&\\/]");
    public static final String FIELD_ORIGIN = "origin";

    @Override
    public Document transform(GenericApiEntity api) {
        int[] pathIndex;
        ApiEntity apiEntity;
        Document doc = new Document();
        doc.add((IndexableField)new StringField(FIELD_ID, api.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_TYPE, FIELD_TYPE_VALUE, Field.Store.YES));
        if (api.getReferenceId() != null) {
            doc.add((IndexableField)new StringField("reference_type", api.getReferenceType(), Field.Store.NO));
            doc.add((IndexableField)new StringField("reference_id", api.getReferenceId(), Field.Store.NO));
        }
        if (api.getName() != null) {
            doc.add((IndexableField)new StringField(FIELD_NAME, api.getName(), Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField(FIELD_NAME_SORTED, this.toSortedValue(api.getName())));
            doc.add((IndexableField)new StringField(FIELD_NAME_LOWERCASE, api.getName().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField(FIELD_NAME_SPLIT, api.getName(), Field.Store.NO));
        }
        if (api.getDescription() != null) {
            doc.add((IndexableField)new StringField(FIELD_DESCRIPTION, api.getDescription(), Field.Store.NO));
            doc.add((IndexableField)new StringField(FIELD_DESCRIPTION_LOWERCASE, api.getDescription().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField(FIELD_DESCRIPTION_SPLIT, api.getDescription(), Field.Store.NO));
        }
        if (api.getPrimaryOwner() != null) {
            doc.add((IndexableField)new StringField(FIELD_OWNER, api.getPrimaryOwner().getDisplayName(), Field.Store.NO));
            doc.add((IndexableField)new StringField(FIELD_OWNER_LOWERCASE, api.getPrimaryOwner().getDisplayName().toLowerCase(), Field.Store.NO));
            if (api.getPrimaryOwner().getEmail() != null) {
                doc.add((IndexableField)new TextField(FIELD_OWNER_MAIL, api.getPrimaryOwner().getEmail(), Field.Store.NO));
            }
        }
        if (api.getDefinitionVersion() != DefinitionVersion.V4) {
            apiEntity = (ApiEntity)api;
            if (apiEntity.getProxy() != null) {
                pathIndex = new int[]{0};
                apiEntity.getProxy().getVirtualHosts().forEach(virtualHost -> this.appendPath(doc, pathIndex, virtualHost.getHost(), virtualHost.getPath()));
            }
        } else {
            apiEntity = (io.gravitee.rest.api.model.v4.api.ApiEntity)api;
            if (apiEntity.getListeners() != null) {
                pathIndex = new int[]{0};
                apiEntity.getListeners().stream().filter(listener -> listener.getType() == ListenerType.HTTP).flatMap(listener -> {
                    HttpListener httpListener = (HttpListener)listener;
                    return httpListener.getPaths().stream();
                }).forEach(path -> this.appendPath(doc, pathIndex, path.getHost(), path.getPath()));
            }
        }
        if (api.getLabels() != null) {
            for (String label : api.getLabels()) {
                doc.add((IndexableField)new StringField(FIELD_LABELS, label, Field.Store.YES));
                doc.add((IndexableField)new StringField(FIELD_LABELS_LOWERCASE, label.toLowerCase(), Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_LABELS_SPLIT, label, Field.Store.NO));
            }
        }
        if (api.getCategories() != null) {
            for (String category : api.getCategories()) {
                doc.add((IndexableField)new StringField(FIELD_CATEGORIES, category, Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_CATEGORIES_SPLIT, category, Field.Store.NO));
            }
        }
        if (api.getTags() != null) {
            for (String tag : api.getTags()) {
                doc.add((IndexableField)new StringField(FIELD_TAGS, tag, Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_TAGS_SPLIT, tag, Field.Store.NO));
            }
        }
        if (api.getCreatedAt() != null) {
            doc.add((IndexableField)new LongPoint(FIELD_CREATED_AT, new long[]{api.getCreatedAt().getTime()}));
        }
        if (api.getUpdatedAt() != null) {
            doc.add((IndexableField)new LongPoint(FIELD_UPDATED_AT, new long[]{api.getUpdatedAt().getTime()}));
        }
        if (api.getMetadata() != null) {
            api.getMetadata().values().forEach(metadataValue -> {
                doc.add((IndexableField)new StringField(FIELD_METADATA, metadataValue.toString(), Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_METADATA_SPLIT, metadataValue.toString(), Field.Store.NO));
            });
        }
        if (api.getDefinitionContext() != null && api.getDefinitionContext().getOrigin() != null) {
            doc.add((IndexableField)new StringField(FIELD_ORIGIN, api.getDefinitionContext().getOrigin(), Field.Store.NO));
        }
        return doc;
    }

    private void appendPath(Document doc, int[] pathIndex, String host, String path) {
        doc.add((IndexableField)new StringField(FIELD_PATHS, path, Field.Store.NO));
        doc.add((IndexableField)new TextField(FIELD_PATHS_SPLIT, path, Field.Store.NO));
        if (host != null && !host.isEmpty()) {
            doc.add((IndexableField)new StringField(FIELD_HOSTS, host, Field.Store.NO));
            doc.add((IndexableField)new TextField(FIELD_HOSTS_SPLIT, host, Field.Store.NO));
        }
        int n = pathIndex[0];
        pathIndex[0] = n + 1;
        if (n == 0) {
            doc.add((IndexableField)new SortedDocValuesField(FIELD_PATHS_SORTED, new BytesRef((CharSequence)QueryParser.escape((String)path))));
        }
    }

    private BytesRef toSortedValue(String value) {
        return new BytesRef((CharSequence)SPECIAL_CHARS.matcher(value).replaceAll("").toLowerCase());
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return GenericApiEntity.class.isAssignableFrom(source);
    }
}

