/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanSecurityEntity;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlansConfigurationEntity;
import io.gravitee.rest.api.model.UpdatePlanEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.plan.PlanQuery;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.ApiDeprecatedException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.KeylessPlanAlreadyPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyDeprecatedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanGeneralConditionStatusException;
import io.gravitee.rest.api.service.exceptions.PlanInvalidException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotYetPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanWithSubscriptionsException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedPlanSecurityTypeException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.processor.PlanSynchronizationProcessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanServiceImpl
extends TransactionalService
implements PlanService {
    private final Logger logger = LoggerFactory.getLogger(PlanServiceImpl.class);
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private PageService pageService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private PlanSynchronizationProcessor planSynchronizationProcessor;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private PlanConverter planConverter;
    @Autowired
    private FlowService flowService;
    private static final List<PlanSecurityEntity> DEFAULT_SECURITY_LIST = Collections.unmodifiableList(Arrays.asList(new PlanSecurityEntity("oauth2", "OAuth2", "oauth2"), new PlanSecurityEntity("jwt", "JWT", "'jwt'"), new PlanSecurityEntity("api_key", "API Key", "api-key"), new PlanSecurityEntity("key_less", "Keyless (public)", "")));

    @Override
    public PlanEntity findById(ExecutionContext executionContext, String plan) {
        try {
            this.logger.debug("Find plan by id : {}", (Object)plan);
            return this.planRepository.findById((Object)plan).map(this::convert).orElseThrow(() -> new PlanNotFoundException(plan));
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a plan by id: {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by id: %s", plan), ex);
        }
    }

    @Override
    public Set<PlanEntity> findByIdIn(ExecutionContext executionContext, Set<String> ids) {
        try {
            return this.planRepository.findByIdIn(ids).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred retrieving plans by ids", e);
        }
    }

    @Override
    public Set<PlanEntity> findByApi(ExecutionContext executionContext, String api) {
        try {
            this.logger.debug("Find plan by api : {}", (Object)api);
            return this.planRepository.findByApi(api).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a plan by api: {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by api: %s", api), ex);
        }
    }

    @Override
    public List<PlanEntity> search(ExecutionContext executionContext, PlanQuery query) {
        Set<Object> planEntities = query.getApi() != null ? this.findByApi(executionContext, query.getApi()) : Collections.emptySet();
        return planEntities.stream().filter(p -> {
            boolean filtered = true;
            if (query.getName() != null) {
                filtered = p.getName().equals(query.getName());
            }
            if (filtered && query.getSecurity() != null) {
                filtered = p.getSecurity().equals((Object)query.getSecurity());
            }
            return filtered;
        }).collect(Collectors.toList());
    }

    @Override
    public PlanEntity create(ExecutionContext executionContext, NewPlanEntity newPlan) {
        try {
            this.logger.debug("Create a new plan {} for API {}", (Object)newPlan.getName(), (Object)newPlan.getApi());
            this.assertPlanSecurityIsAllowed(executionContext, newPlan.getSecurity());
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)newPlan.getApi()).orElseThrow(() -> new ApiNotFoundException(newPlan.getApi()));
            if (api.getApiLifecycleState() == ApiLifecycleState.DEPRECATED) {
                throw new ApiDeprecatedException(api.getName());
            }
            String id = newPlan.getId() != null && UUID.fromString(newPlan.getId()) != null ? newPlan.getId() : UuidString.generateRandom();
            newPlan.setId(id);
            Plan plan = this.planConverter.toPlan(newPlan, this.getApiDefinitionVersion(api));
            plan = (Plan)this.planRepository.create((Object)plan);
            this.flowService.save(FlowReferenceType.PLAN, plan.getId(), newPlan.getFlows());
            this.auditService.createApiAuditLog(executionContext, newPlan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_CREATED, plan.getCreatedAt(), null, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to create a plan {} for API {}", new Object[]{newPlan.getName(), newPlan.getApi(), ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a plan %s for API %s", newPlan.getName(), newPlan.getApi()), ex);
        }
        catch (JsonProcessingException jse) {
            this.logger.error("Unexpected error while generating plan definition", (Throwable)jse);
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a plan %s for API %s", newPlan.getName(), newPlan.getApi()), jse);
        }
    }

    @Override
    public PlanEntity createOrUpdatePlan(ExecutionContext executionContext, PlanEntity planEntity) {
        PlanEntity resultPlanEntity;
        try {
            this.findById(executionContext, planEntity.getId());
            resultPlanEntity = this.update(executionContext, this.planConverter.toUpdatePlanEntity(planEntity));
        }
        catch (PlanNotFoundException npe) {
            resultPlanEntity = this.create(executionContext, this.planConverter.toNewPlanEntity(planEntity));
        }
        return resultPlanEntity;
    }

    @Override
    public PlanEntity update(ExecutionContext executionContext, UpdatePlanEntity updatePlan) {
        return this.update(executionContext, updatePlan, false);
    }

    @Override
    public PlanEntity update(ExecutionContext executionContext, UpdatePlanEntity updatePlan, boolean fromImport) {
        try {
            this.logger.debug("Update plan {}", (Object)updatePlan.getName());
            Plan oldPlan = (Plan)this.planRepository.findById((Object)updatePlan.getId()).orElseThrow(() -> new PlanNotFoundException(updatePlan.getId()));
            this.assertPlanSecurityIsAllowed(executionContext, PlanSecurityType.valueOf((String)oldPlan.getSecurity().name()));
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)oldPlan.getApi()).orElseThrow(() -> new ApiNotFoundException(oldPlan.getApi()));
            if (this.getApiDefinitionVersion(api) == DefinitionVersion.V2 && updatePlan.getFlows() == null) {
                throw new PlanInvalidException(updatePlan.getId());
            }
            Plan newPlan = new Plan();
            newPlan.setId(oldPlan.getId());
            newPlan.setSecurity(oldPlan.getSecurity());
            newPlan.setType(oldPlan.getType());
            newPlan.setStatus(oldPlan.getStatus());
            newPlan.setOrder(oldPlan.getOrder());
            newPlan.setApi(oldPlan.getApi());
            newPlan.setCreatedAt(oldPlan.getCreatedAt());
            newPlan.setPublishedAt(oldPlan.getPublishedAt());
            newPlan.setClosedAt(oldPlan.getClosedAt());
            if (oldPlan.getNeedRedeployAt() == null) {
                newPlan.setNeedRedeployAt(oldPlan.getUpdatedAt());
            } else {
                newPlan.setNeedRedeployAt(oldPlan.getNeedRedeployAt());
            }
            newPlan.setName(updatePlan.getName());
            newPlan.setCrossId(updatePlan.getCrossId() != null ? updatePlan.getCrossId() : oldPlan.getCrossId());
            newPlan.setDescription(updatePlan.getDescription());
            newPlan.setUpdatedAt(new Date());
            newPlan.setSecurityDefinition(updatePlan.getSecurityDefinition());
            newPlan.setCommentRequired(updatePlan.isCommentRequired());
            newPlan.setCommentMessage(updatePlan.getCommentMessage());
            newPlan.setTags(updatePlan.getTags());
            newPlan.setSelectionRule(updatePlan.getSelectionRule());
            newPlan.setGeneralConditions(updatePlan.getGeneralConditions());
            if (Plan.Status.PUBLISHED.equals((Object)newPlan.getStatus()) || Plan.Status.DEPRECATED.equals((Object)newPlan.getStatus())) {
                this.checkStatusOfGeneralConditions(newPlan);
            }
            String planPolicies = this.objectMapper.writeValueAsString((Object)updatePlan.getPaths());
            newPlan.setDefinition(planPolicies);
            newPlan.setExcludedGroups(updatePlan.getExcludedGroups());
            if (newPlan.getSecurity() == Plan.PlanSecurityType.KEY_LESS) {
                newPlan.setValidation(Plan.PlanValidationType.AUTO);
            } else {
                newPlan.setValidation(Plan.PlanValidationType.valueOf((String)updatePlan.getValidation().name()));
            }
            newPlan.setCharacteristics(updatePlan.getCharacteristics());
            if (newPlan.getOrder() != updatePlan.getOrder()) {
                newPlan.setOrder(updatePlan.getOrder());
                this.reorderAndSavePlans(newPlan);
                return null;
            }
            PlanEntity oldPlanEntity = this.convert(oldPlan);
            this.flowService.save(FlowReferenceType.PLAN, updatePlan.getId(), updatePlan.getFlows());
            PlanEntity newPlanEntity = this.convert(newPlan);
            if (!this.planSynchronizationProcessor.processCheckSynchronization(oldPlanEntity, newPlanEntity)) {
                newPlan.setNeedRedeployAt(newPlan.getUpdatedAt());
            }
            newPlan = (Plan)this.planRepository.update((Object)newPlan);
            this.auditService.createApiAuditLog(executionContext, newPlan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, newPlan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_UPDATED, newPlan.getUpdatedAt(), oldPlan, newPlan);
            return this.convert(newPlan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)updatePlan.getName(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update plan %s", updatePlan.getName()), ex);
        }
        catch (JsonProcessingException jse) {
            this.logger.error("Unexpected error while generating plan definition", (Throwable)jse);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update a plan %s", updatePlan.getName()), jse);
        }
    }

    private void checkStatusOfGeneralConditions(Plan plan) {
        PageEntity generalConditions;
        if (plan.getGeneralConditions() != null && !plan.getGeneralConditions().isEmpty() && !(generalConditions = this.pageService.findById(plan.getGeneralConditions())).isPublished()) {
            throw new PlanGeneralConditionStatusException(plan.getName());
        }
    }

    @Override
    public PlanEntity close(ExecutionContext executionContext, String planId, String userId) {
        try {
            this.logger.debug("Close plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            plan.setStatus(Plan.Status.CLOSED);
            plan.setClosedAt(new Date());
            plan.setUpdatedAt(plan.getClosedAt());
            plan.setNeedRedeployAt(plan.getClosedAt());
            if (plan.getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                this.subscriptionService.findByPlan(executionContext, planId).stream().forEach(subscription -> {
                    try {
                        this.subscriptionService.close(executionContext, subscription.getId());
                    }
                    catch (SubscriptionNotClosableException subscriptionNotClosableException) {
                        // empty catch block
                    }
                });
            }
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(executionContext, plan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_CLOSED, plan.getUpdatedAt(), previousPlan, plan);
            this.reorderedAndSavePlansAfterRemove(plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to close plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to close plan: %s", planId), ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String planId) {
        try {
            this.logger.debug("Delete plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            if (plan.getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                int subscriptions = this.subscriptionService.findByPlan(executionContext, planId).size();
                if ((plan.getStatus() == Plan.Status.PUBLISHED || plan.getStatus() == Plan.Status.DEPRECATED) && subscriptions > 0) {
                    throw new PlanWithSubscriptionsException(planId);
                }
            }
            this.flowService.save(FlowReferenceType.PLAN, planId, null);
            this.planRepository.delete((Object)planId);
            this.auditService.createApiAuditLog(executionContext, plan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_DELETED, new Date(), plan, null);
            this.reorderedAndSavePlansAfterRemove(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete plan: %s", planId), ex);
        }
    }

    @Override
    public PlanEntity publish(ExecutionContext executionContext, String planId) {
        try {
            long count;
            this.logger.debug("Publish plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (plan.getStatus() == Plan.Status.PUBLISHED) {
                throw new PlanAlreadyPublishedException(planId);
            }
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            this.checkStatusOfGeneralConditions(plan);
            Set plans = this.planRepository.findByApi(plan.getApi());
            if (plan.getSecurity() == Plan.PlanSecurityType.KEY_LESS && (count = plans.stream().filter(plan1 -> plan1.getStatus() == Plan.Status.PUBLISHED || plan1.getStatus() == Plan.Status.DEPRECATED).filter(plan1 -> plan1.getSecurity() == Plan.PlanSecurityType.KEY_LESS).count()) > 0L) {
                throw new KeylessPlanAlreadyPublishedException(planId);
            }
            plan.setStatus(Plan.Status.PUBLISHED);
            List orderedPublishedPlans = plans.stream().filter(plan1 -> Plan.Status.PUBLISHED.equals((Object)plan1.getStatus())).sorted(Comparator.comparingInt(Plan::getOrder)).collect(Collectors.toList());
            plan.setOrder(orderedPublishedPlans.isEmpty() ? 1 : ((Plan)orderedPublishedPlans.get(orderedPublishedPlans.size() - 1)).getOrder() + 1);
            plan.setPublishedAt(new Date());
            plan.setUpdatedAt(plan.getPublishedAt());
            plan.setNeedRedeployAt(plan.getPublishedAt());
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(executionContext, plan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_PUBLISHED, plan.getUpdatedAt(), previousPlan, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to publish plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to publish plan: %s", planId), ex);
        }
    }

    @Override
    public PlanEntity deprecate(ExecutionContext executionContext, String planId) {
        return this.deprecate(executionContext, planId, false);
    }

    @Override
    public PlanEntity deprecate(ExecutionContext executionContext, String planId, boolean allowStaging) {
        try {
            this.logger.debug("Deprecate plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (!allowStaging && plan.getStatus() == Plan.Status.STAGING) {
                throw new PlanNotYetPublishedException(planId);
            }
            plan.setStatus(Plan.Status.DEPRECATED);
            plan.setUpdatedAt(new Date());
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(executionContext, plan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_DEPRECATED, plan.getUpdatedAt(), previousPlan, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to deprecate plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to deprecate plan: %s", planId), ex);
        }
    }

    @Override
    public PlansConfigurationEntity getConfiguration() {
        PlansConfigurationEntity config = new PlansConfigurationEntity();
        config.setSecurity(DEFAULT_SECURITY_LIST);
        return config;
    }

    private void reorderAndSavePlans(Plan planToReorder) throws TechnicalException {
        Set plans = this.planRepository.findByApi(planToReorder.getApi());
        Plan[] plansToReorder = (Plan[])plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus()) && !Objects.equals(p.getId(), planToReorder.getId())).sorted(Comparator.comparingInt(Plan::getOrder)).toArray(Plan[]::new);
        if (planToReorder.getOrder() < 1) {
            planToReorder.setOrder(1);
        } else if (planToReorder.getOrder() > plansToReorder.length + 1) {
            planToReorder.setOrder(plansToReorder.length + 1);
        }
        try {
            for (int i = 0; i < plansToReorder.length; ++i) {
                int newOrder;
                int n = newOrder = i + 1 < planToReorder.getOrder() ? i + 1 : i + 2;
                if (plansToReorder[i].getOrder() == newOrder) continue;
                plansToReorder[i].setOrder(newOrder);
                this.planRepository.update((Object)plansToReorder[i]);
            }
            this.planRepository.update((Object)planToReorder);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)planToReorder.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update plan " + planToReorder.getId(), ex);
        }
    }

    private void reorderedAndSavePlansAfterRemove(Plan planRemoved) throws TechnicalException {
        Set plans = this.planRepository.findByApi(planRemoved.getApi());
        plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus())).sorted(Comparator.comparingInt(Plan::getOrder)).forEachOrdered(plan -> {
            try {
                if (plan.getOrder() > planRemoved.getOrder()) {
                    plan.setOrder(plan.getOrder() - 1);
                    this.planRepository.update(plan);
                }
            }
            catch (TechnicalException ex) {
                this.logger.error("An error occurs while trying to reorder plan {}", (Object)plan.getId(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update plan " + plan.getId(), ex);
            }
        });
    }

    private PlanEntity convert(Plan plan) {
        List<Flow> flows = this.flowService.findByReference(FlowReferenceType.PLAN, plan.getId());
        return this.planConverter.toPlanEntity(plan, flows);
    }

    private void assertPlanSecurityIsAllowed(ExecutionContext executionContext, PlanSecurityType securityType) {
        Key securityKey;
        switch (securityType) {
            case API_KEY: {
                securityKey = Key.PLAN_SECURITY_APIKEY_ENABLED;
                break;
            }
            case OAUTH2: {
                securityKey = Key.PLAN_SECURITY_OAUTH2_ENABLED;
                break;
            }
            case JWT: {
                securityKey = Key.PLAN_SECURITY_JWT_ENABLED;
                break;
            }
            case KEY_LESS: {
                securityKey = Key.PLAN_SECURITY_KEYLESS_ENABLED;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.parameterService.findAsBoolean(executionContext, securityKey, ParameterReferenceType.ENVIRONMENT)) {
            throw new UnauthorizedPlanSecurityTypeException(securityType);
        }
    }

    @Override
    public boolean anyPlanMismatchWithApi(List<String> planIds, String apiId) {
        try {
            return this.planRepository.findByIdIn(planIds).stream().map(Plan::getApi).filter(Objects::nonNull).anyMatch(id -> !id.equals(apiId));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred checking plans ownership", e);
        }
    }

    @Override
    public Map<String, Object> findByIdAsMap(String id) throws TechnicalException {
        Plan plan = (Plan)this.planRepository.findById((Object)id).orElseThrow(() -> new PlanNotFoundException(id));
        return (Map)this.objectMapper.convertValue((Object)plan, Map.class);
    }

    private DefinitionVersion getApiDefinitionVersion(io.gravitee.repository.management.model.Api api) {
        try {
            return ((Api)this.objectMapper.readValue(api.getDefinition(), Api.class)).getDefinitionVersion();
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            this.logger.error("Unexpected error while reading API definition", e);
            return DefinitionVersion.V2;
        }
    }
}

