/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.InternetDomainName;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.VirtualHostService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiContextPathAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.InvalidVirtualHostException;
import io.gravitee.rest.api.service.exceptions.InvalidVirtualHostNullHostException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualHostServiceImpl
extends TransactionalService
implements VirtualHostService {
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private static final char URI_PATH_SEPARATOR_CHAR = '/';
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualHostServiceImpl.class);
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EnvironmentService environmentService;

    @Override
    public Collection<VirtualHost> sanitizeAndValidate(ExecutionContext executionContext, Collection<VirtualHost> virtualHosts, String apiId) {
        List<VirtualHost> nullHostVirtualHosts;
        boolean virtualHostModeEnabled;
        Collection sanitizedVirtualHosts = virtualHosts.stream().map(this::sanitize).collect(Collectors.toList());
        EnvironmentEntity currentEnv = this.environmentService.findById(executionContext.getEnvironmentId());
        this.validateDomainRestrictions(sanitizedVirtualHosts, currentEnv.getDomainRestrictions());
        boolean bl = virtualHostModeEnabled = sanitizedVirtualHosts.size() > 1 || ((VirtualHost)sanitizedVirtualHosts.iterator().next()).getHost() != null || currentEnv.getDomainRestrictions() != null && !currentEnv.getDomainRestrictions().isEmpty();
        if (virtualHostModeEnabled && !(nullHostVirtualHosts = sanitizedVirtualHosts.stream().filter(virtualHost -> virtualHost.getHost() == null).collect(Collectors.toList())).isEmpty()) {
            throw new InvalidVirtualHostNullHostException("In Virtual Host mode, all listening host have to be configured", nullHostVirtualHosts);
        }
        Set apis = this.apiRepository.search(null).stream().filter(api -> !api.getId().equals(apiId) && api.getEnvironmentId().equals(executionContext.getEnvironmentId())).map(this::convert).collect(Collectors.toSet());
        Map registeredVirtualHosts = apis.stream().flatMap(api -> api.getProxy().getVirtualHosts().stream().filter(virtualHost -> virtualHost.getHost() != null && !virtualHost.getHost().isEmpty())).collect(Collectors.groupingBy(VirtualHost::getHost, Collectors.mapping(VirtualHost::getPath, Collectors.toList())));
        List registeredContextPaths = apis.stream().flatMap(api -> api.getProxy().getVirtualHosts().stream().filter(virtualHost -> virtualHost.getHost() == null).map(VirtualHost::getPath)).collect(Collectors.toList());
        if (!registeredVirtualHosts.isEmpty()) {
            sanitizedVirtualHosts.stream().filter(virtualHost -> virtualHost.getHost() != null && !virtualHost.getHost().isEmpty()).forEach(virtualHost -> this.checkPathNotYetRegistered(virtualHost.getPath(), (List)registeredVirtualHosts.get(virtualHost.getHost())));
        }
        if (!registeredContextPaths.isEmpty()) {
            sanitizedVirtualHosts.stream().filter(virtualHost -> virtualHost.getHost() == null).forEach(virtualHost -> this.checkPathNotYetRegistered(virtualHost.getPath(), registeredContextPaths));
        }
        return sanitizedVirtualHosts;
    }

    private void validateDomainRestrictions(Collection<VirtualHost> virtualHosts, List<String> domainRestrictions) {
        if (domainRestrictions != null && !domainRestrictions.isEmpty()) {
            for (VirtualHost vHost : virtualHosts) {
                String host = vHost.getHost();
                if (!StringUtils.isEmpty((CharSequence)host)) {
                    String hostWithoutPort = host.split(":")[0];
                    if (this.isValidDomainOrSubDomain(hostWithoutPort, domainRestrictions)) continue;
                    throw new InvalidVirtualHostException(hostWithoutPort, domainRestrictions);
                }
                vHost.setHost(domainRestrictions.get(0));
            }
        }
    }

    private boolean isValidDomainOrSubDomain(String domain, List<String> domainRestrictions) {
        boolean isSubDomain = false;
        if (domainRestrictions.isEmpty()) {
            return true;
        }
        for (String domainRestriction : domainRestrictions) {
            InternetDomainName parentIDN;
            InternetDomainName domainIDN = InternetDomainName.from((String)domain);
            if (domainIDN.equals((Object)(parentIDN = InternetDomainName.from((String)domainRestriction)))) {
                return true;
            }
            while (!isSubDomain && domainIDN.hasParent()) {
                isSubDomain = parentIDN.equals((Object)domainIDN);
                domainIDN = domainIDN.parent();
            }
            if (!isSubDomain) continue;
            break;
        }
        return isSubDomain;
    }

    @Override
    public VirtualHost sanitize(VirtualHost virtualHost) {
        Object path = virtualHost.getPath();
        if (path == null || ((String)path).isEmpty()) {
            path = URI_PATH_SEPARATOR;
        }
        if (!((String)path).startsWith(URI_PATH_SEPARATOR)) {
            path = URI_PATH_SEPARATOR + (String)path;
        }
        if (((String)path).lastIndexOf(47) != ((String)path).length() - 1) {
            path = (String)path + URI_PATH_SEPARATOR;
        }
        path = DUPLICATE_SLASH_REMOVER.matcher((CharSequence)path).replaceAll(URI_PATH_SEPARATOR);
        return new VirtualHost(virtualHost.getHost(), (String)path, virtualHost.isOverrideEntrypoint());
    }

    private void checkPathNotYetRegistered(String path, List<String> registeredPaths) {
        boolean match;
        boolean bl = match = registeredPaths != null && registeredPaths.stream().anyMatch(registeredPath -> path.startsWith((String)registeredPath) || registeredPath.startsWith(path));
        if (match) {
            throw new ApiContextPathAlreadyExistsException(path);
        }
    }

    private ApiEntity convert(Api api) {
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        if (api.getDefinition() != null) {
            try {
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.getProxy().setVirtualHosts(apiEntity.getProxy().getVirtualHosts().stream().map(this::sanitize).collect(Collectors.toList()));
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while getting API definition", (Throwable)ioe);
            }
        }
        return apiEntity;
    }
}

