/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.model.ExecutionMode;
import java.util.Map;

public interface JupiterModeService {
    public boolean isEnabled();

    public DefaultMode defaultMode();

    public ExecutionMode getExecutionModeFor(JsonNode var1);

    public static enum DefaultMode {
        ALWAYS("always"),
        CREATION_ONLY("creation_only"),
        NEVER("never");

        private static final Map<String, DefaultMode> BY_LABEL;
        private final String label;

        private DefaultMode(String label) {
            this.label = label;
        }

        public static DefaultMode fromLabel(String label) {
            return BY_LABEL.getOrDefault(label, ALWAYS);
        }

        public String getLabel() {
            return this.label;
        }

        static {
            BY_LABEL = Map.of(DefaultMode.ALWAYS.label, ALWAYS, DefaultMode.CREATION_ONLY.label, CREATION_ONLY, DefaultMode.NEVER.label, NEVER);
        }
    }
}

