/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class RatingAnswerNotFoundException
extends AbstractNotFoundException {
    private final String answer;
    private final String rating;
    private final String api;

    public RatingAnswerNotFoundException(String answer) {
        this(answer, null, null);
    }

    public RatingAnswerNotFoundException(String answer, String rating, String api) {
        this.answer = answer;
        this.rating = rating;
        this.api = api;
    }

    @Override
    public String getMessage() {
        return "Answer [" + this.answer + "] can not be found" + (String)(this.rating == null ? "" : " on rating [" + this.rating + "]") + (this.rating != null && this.api != null ? " and" : "") + (String)(this.api == null ? "" : " on api [" + this.api + "]");
    }

    @Override
    public String getTechnicalCode() {
        return "ratingAnswer.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("answer", this.answer);
        parameters.put("rating", this.rating);
        parameters.put("api", this.api);
        return parameters;
    }
}

