/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.AbstractReferenceMetadataService;
import io.gravitee.rest.api.service.search.SearchEngineService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiMetadataServiceImpl
extends AbstractReferenceMetadataService
implements ApiMetadataService {
    @Autowired
    private ApiService apiService;
    @Autowired
    private SearchEngineService searchEngineService;

    @Override
    public List<ApiMetadataEntity> findAllByApi(String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, true);
        return allMetadata.stream().map(m -> this.convert((ReferenceMetadataEntity)m, apiId)).collect(Collectors.toList());
    }

    @Override
    public ApiMetadataEntity findByIdAndApi(String metadataId, String apiId) {
        return this.convert(this.findByIdAndReference(metadataId, MetadataReferenceType.API, apiId, true), apiId);
    }

    @Override
    public void delete(ExecutionContext executionContext, String metadataId, String apiId) {
        this.delete(executionContext, metadataId, MetadataReferenceType.API, apiId);
    }

    @Override
    public void deleteAllByApi(ExecutionContext executionContext, String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, false);
        allMetadata.stream().forEach(referenceMetadataEntity -> this.delete(executionContext, referenceMetadataEntity.getKey(), MetadataReferenceType.API, apiId));
    }

    @Override
    public List<ApiMetadataEntity> create(ExecutionContext executionContext, List<ApiMetadataEntity> apiMetadata, String apiId) {
        if (apiMetadata == null || apiMetadata.isEmpty()) {
            return Collections.emptyList();
        }
        return apiMetadata.stream().map(data -> {
            NewApiMetadataEntity newMD = new NewApiMetadataEntity();
            newMD.setFormat(data.getFormat());
            newMD.setName(data.getName());
            newMD.setValue(data.getValue());
            newMD.setApiId(apiId);
            return newMD;
        }).map(newApiMetadataEntity -> this.create(executionContext, (NewApiMetadataEntity)newApiMetadataEntity)).collect(Collectors.toList());
    }

    @Override
    public ApiMetadataEntity create(ExecutionContext executionContext, NewApiMetadataEntity metadataEntity) {
        return this.convert(this.create(executionContext, (NewReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true), metadataEntity.getApiId());
    }

    @Override
    public ApiMetadataEntity update(ExecutionContext executionContext, UpdateApiMetadataEntity metadataEntity) {
        ApiMetadataEntity apiMetadataEntity = this.convert(this.update(executionContext, (UpdateReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true), metadataEntity.getApiId());
        ApiEntity apiEntity = this.apiService.fetchMetadataForApi(executionContext, this.apiService.findById(executionContext, apiMetadataEntity.getApiId()));
        this.searchEngineService.index(executionContext, (Indexable)apiEntity, false);
        return apiMetadataEntity;
    }

    @Override
    protected void checkReferenceMetadataFormat(ExecutionContext executionContext, MetadataFormat format, String value, MetadataReferenceType referenceType, String referenceId) {
        ApiEntity apiEntity = this.apiService.findById(executionContext, referenceId);
        this.metadataService.checkMetadataFormat(executionContext, format, value, referenceType, apiEntity);
    }

    private ApiMetadataEntity convert(ReferenceMetadataEntity m, String apiId) {
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setKey(m.getKey());
        apiMetadataEntity.setName(m.getName());
        apiMetadataEntity.setFormat(m.getFormat());
        apiMetadataEntity.setValue(m.getValue());
        apiMetadataEntity.setDefaultValue(m.getDefaultValue());
        apiMetadataEntity.setApiId(apiId);
        return apiMetadataEntity;
    }
}

