/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.GroupMemberEntity;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.api.NewApiEntity;
import io.gravitee.rest.api.model.api.RollbackApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ApiService {
    public ApiEntity findById(ExecutionContext var1, String var2);

    public Optional<ApiEntity> findByEnvironmentIdAndCrossId(String var1, String var2);

    public Set<ApiEntity> findByEnvironmentAndIdIn(ExecutionContext var1, Set<String> var2);

    public Page<ApiEntity> findByUser(ExecutionContext var1, String var2, ApiQuery var3, Sortable var4, Pageable var5, boolean var6);

    public Set<ApiEntity> findByUser(ExecutionContext var1, String var2, ApiQuery var3, boolean var4);

    public Page<ApiEntity> findPublishedByUser(ExecutionContext var1, String var2, ApiQuery var3, Sortable var4, Pageable var5);

    public Set<ApiEntity> findPublishedByUser(ExecutionContext var1, String var2);

    default public Set<String> findIdsByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean manageOnly) {
        return this.findIdsByUser(executionContext, userId, apiQuery, null, manageOnly);
    }

    public Set<String> findIdsByUser(ExecutionContext var1, String var2, ApiQuery var3, Sortable var4, boolean var5);

    public Set<ApiEntity> findPublishedByUser(ExecutionContext var1, String var2, ApiQuery var3);

    public Set<String> findPublishedIdsByUser(ExecutionContext var1, String var2, ApiQuery var3);

    default public Set<String> findPublishedIdsByUser(ExecutionContext executionContext, String userId) {
        return this.findPublishedIdsByUser(executionContext, userId, null);
    }

    public ApiEntity create(ExecutionContext var1, NewApiEntity var2, String var3);

    public ApiEntity createFromSwagger(ExecutionContext var1, SwaggerApiEntity var2, String var3, ImportSwaggerDescriptorEntity var4);

    public ApiEntity createWithApiDefinition(ExecutionContext var1, UpdateApiEntity var2, String var3, JsonNode var4);

    public ApiEntity update(ExecutionContext var1, String var2, UpdateApiEntity var3);

    public ApiEntity update(ExecutionContext var1, String var2, UpdateApiEntity var3, boolean var4);

    public ApiEntity update(ExecutionContext var1, String var2, UpdateApiEntity var3, boolean var4, boolean var5);

    public ApiEntity updateFromSwagger(ExecutionContext var1, String var2, SwaggerApiEntity var3, ImportSwaggerDescriptorEntity var4);

    public void delete(ExecutionContext var1, String var2);

    public ApiEntity start(ExecutionContext var1, String var2, String var3);

    public ApiEntity stop(ExecutionContext var1, String var2, String var3);

    public boolean isSynchronized(ExecutionContext var1, String var2);

    public ApiEntity deploy(ExecutionContext var1, String var2, String var3, EventType var4, ApiDeploymentEntity var5);

    public ApiEntity rollback(ExecutionContext var1, String var2, RollbackApiEntity var3);

    public String exportAsJson(ExecutionContext var1, String var2, String var3, String ... var4);

    public InlinePictureEntity getPicture(ExecutionContext var1, String var2);

    public void deleteCategoryFromAPIs(ExecutionContext var1, String var2);

    public void deleteTagFromAPIs(ExecutionContext var1, String var2);

    public ApiModelEntity findByIdForTemplates(ExecutionContext var1, String var2, boolean var3);

    default public ApiModelEntity findByIdForTemplates(ExecutionContext executionContext, String apiId) {
        return this.findByIdForTemplates(executionContext, apiId, false);
    }

    public boolean exists(String var1);

    public ApiEntity importPathMappingsFromPage(ExecutionContext var1, ApiEntity var2, String var3, DefinitionVersion var4);

    public Set<CategoryEntity> listCategories(Collection<String> var1, String var2);

    public Page<ApiEntity> search(ExecutionContext var1, ApiQuery var2, Sortable var3, Pageable var4);

    public Collection<ApiEntity> search(ExecutionContext var1, ApiQuery var2);

    public Page<String> searchIds(ExecutionContext var1, ApiQuery var2, Pageable var3, Sortable var4);

    public Collection<String> searchIds(ExecutionContext var1, String var2, Map<String, Object> var3, Sortable var4) throws TechnicalException;

    public Page<ApiEntity> search(ExecutionContext var1, String var2, Map<String, Object> var3, Sortable var4, Pageable var5);

    public Collection<ApiEntity> search(ExecutionContext var1, String var2, Map<String, Object> var3) throws TechnicalException;

    public List<ApiHeaderEntity> getPortalHeaders(ExecutionContext var1, String var2);

    public ApiEntity askForReview(ExecutionContext var1, String var2, String var3, ReviewEntity var4);

    public ApiEntity acceptReview(ExecutionContext var1, String var2, String var3, ReviewEntity var4);

    public ApiEntity rejectReview(ExecutionContext var1, String var2, String var3, ReviewEntity var4);

    public InlinePictureEntity getBackground(ExecutionContext var1, String var2);

    public ApiEntity migrate(ExecutionContext var1, String var2);

    public boolean hasHealthCheckEnabled(ApiEntity var1, boolean var2);

    public ApiEntity fetchMetadataForApi(ExecutionContext var1, ApiEntity var2);

    public PrimaryOwnerEntity getPrimaryOwner(ExecutionContext var1, String var2) throws TechnicalManagementException;

    public void addGroup(ExecutionContext var1, String var2, String var3);

    public void removeGroup(ExecutionContext var1, String var2, String var3);

    public Map<String, List<GroupMemberEntity>> getGroupsWithMembers(ExecutionContext var1, String var2) throws TechnicalManagementException;

    public boolean canManageApi(RoleEntity var1);

    public void checkPolicyConfigurations(Map<String, List<Rule>> var1, List<Flow> var2, Set<PlanEntity> var3);

    public Map<String, Long> countPublishedByUserGroupedByCategories(String var1);

    public long countByCategoryForUser(ExecutionContext var1, String var2, String var3);

    public void calculateEntrypoints(ExecutionContext var1, ApiEntity var2);

    public Map<String, Object> findByIdAsMap(String var1) throws TechnicalException;
}

