/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.designer.DeployModelCommand;
import io.gravitee.cockpit.api.command.designer.DeployModelPayload;
import io.gravitee.cockpit.api.command.designer.DeployModelReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntityResult;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.ApiServiceCockpit;
import io.gravitee.rest.api.service.cockpit.services.CockpitApiPermissionChecker;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.reactivex.Single;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployModelCommandHandler
implements CommandHandler<DeployModelCommand, DeployModelReply> {
    private final Logger logger = LoggerFactory.getLogger(DeployModelCommandHandler.class);
    private final ApiService apiService;
    private final ApiServiceCockpit cockpitApiService;
    private final CockpitApiPermissionChecker permissionChecker;
    private final UserService userService;
    private final EnvironmentService environmentService;

    public DeployModelCommandHandler(ApiService apiService, ApiServiceCockpit cockpitApiService, CockpitApiPermissionChecker permissionChecker, UserService userService, EnvironmentService environmentService) {
        this.apiService = apiService;
        this.cockpitApiService = cockpitApiService;
        this.permissionChecker = permissionChecker;
        this.userService = userService;
        this.environmentService = environmentService;
    }

    public Command.Type handleType() {
        return Command.Type.DEPLOY_MODEL_COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Single<DeployModelReply> handle(DeployModelCommand command) {
        DeployModelPayload payload = (DeployModelPayload)command.getPayload();
        String apiCrossId = payload.getModelId();
        String userId = payload.getUserId();
        String swaggerDefinition = payload.getSwaggerDefinition();
        String environmentId = payload.getEnvironmentId();
        DeploymentMode mode = DeploymentMode.fromDeployModelPayload(payload);
        List labels = payload.getLabels();
        try {
            Single message;
            ApiEntityResult result;
            EnvironmentEntity environment = this.environmentService.findByCockpitId(environmentId);
            GraviteeContext.setCurrentEnvironment(environment.getId());
            GraviteeContext.setCurrentOrganization(environment.getOrganizationId());
            UserEntity user = this.userService.findBySource(GraviteeContext.getExecutionContext(), "cockpit", userId, true);
            SecurityContextHelper.authenticateAs(user);
            Optional<ApiEntity> optApi = this.apiService.findByEnvironmentIdAndCrossId(environment.getId(), apiCrossId);
            if (optApi.isPresent()) {
                ApiEntity api = optApi.get();
                Optional<String> message2 = this.permissionChecker.checkUpdatePermission(GraviteeContext.getExecutionContext(), user.getId(), environment.getId(), api.getId(), mode);
                if (message2.isPresent()) {
                    DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
                    reply.setMessage(message2.get());
                    Single single = Single.just((Object)reply);
                    return single;
                }
                result = this.cockpitApiService.updateApi(GraviteeContext.getExecutionContext(), api.getId(), user.getId(), swaggerDefinition, environment.getId(), mode, labels);
            } else {
                message = this.permissionChecker.checkCreatePermission(GraviteeContext.getExecutionContext(), user.getId(), environment.getId(), mode);
                if (message.isPresent()) {
                    DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
                    reply.setMessage(message.get());
                    Single single = Single.just((Object)reply);
                    return single;
                }
                result = this.cockpitApiService.createApi(GraviteeContext.getExecutionContext(), apiCrossId, user.getId(), swaggerDefinition, environment.getId(), mode, labels);
            }
            if (result.isSuccess()) {
                this.logger.info("Api imported [{}].", (Object)result.getApi().getId());
                message = Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.SUCCEEDED));
                return message;
            }
            this.logger.error("Failed to import API [{}].", (Object)result.getErrorMessage());
            DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
            reply.setMessage(result.getErrorMessage());
            Single single = Single.just((Object)reply);
            return single;
        }
        catch (Exception e) {
            this.logger.error("Error occurred when importing api [{}].", (Object)payload.getModelId(), (Object)e);
            Single single = Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.ERROR));
            return single;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }
}

