/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.search.ApplicationCriteria;
import io.gravitee.repository.management.model.ApiKeyMode;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.application.ApplicationExcludeFilter;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.application.ApplicationQuery;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.application.OAuthClientSettings;
import io.gravitee.rest.api.model.application.SimpleApplicationSettings;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.configuration.application.ApplicationGrantTypeEntity;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypeEntity;
import io.gravitee.rest.api.model.configuration.application.registration.ClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationAlertService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.configuration.application.ApplicationTypeService;
import io.gravitee.rest.api.service.configuration.application.ClientRegistrationService;
import io.gravitee.rest.api.service.converter.ApplicationConverter;
import io.gravitee.rest.api.service.exceptions.ApplicationActiveException;
import io.gravitee.rest.api.service.exceptions.ApplicationArchivedException;
import io.gravitee.rest.api.service.exceptions.ApplicationGrantTypesNotAllowedException;
import io.gravitee.rest.api.service.exceptions.ApplicationGrantTypesNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationRedirectUrisNotFound;
import io.gravitee.rest.api.service.exceptions.ApplicationRenewClientSecretException;
import io.gravitee.rest.api.service.exceptions.ClientIdAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.InvalidApplicationApiKeyModeException;
import io.gravitee.rest.api.service.exceptions.InvalidApplicationTypeException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotPausedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.register.ClientRegistrationResponse;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.HookScope;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationServiceImpl
extends AbstractService
implements ApplicationService {
    private final Logger LOGGER = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private PortalNotificationConfigService portalNotificationConfigService;
    @Autowired
    private ClientRegistrationService clientRegistrationService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApplicationAlertService applicationAlertService;
    @Autowired
    private ApplicationConverter applicationConverter;
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ApplicationEntity findById(ExecutionContext executionContext, String applicationId) {
        try {
            this.LOGGER.debug("Find application by ID: {}", (Object)applicationId);
            Optional<Application> applicationOptional = this.applicationRepository.findById((Object)applicationId);
            if (executionContext.hasEnvironmentId()) {
                applicationOptional = applicationOptional.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            if (applicationOptional.isPresent()) {
                return this.convertAndFillPrimaryOwner(executionContext, applicationOptional.get());
            }
            throw new ApplicationNotFoundException(applicationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an application using its ID {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an application using its ID " + applicationId, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByIds(ExecutionContext executionContext, Collection<String> applicationIds) {
        try {
            Page applications;
            this.LOGGER.debug("Find application by IDs: {}", applicationIds);
            if (applicationIds.isEmpty()) {
                return Collections.emptySet();
            }
            ApplicationCriteria.Builder criteriaBuilder = new ApplicationCriteria.Builder().ids(new HashSet<String>(applicationIds)).status(ApplicationStatus.ACTIVE);
            if (executionContext.hasEnvironmentId()) {
                criteriaBuilder.environmentIds(new String[]{executionContext.getEnvironmentId()});
            }
            if ((applications = this.applicationRepository.search(criteriaBuilder.build(), null)).getContent().isEmpty()) {
                return Collections.emptySet();
            }
            return this.convertToList(executionContext, applications.getContent());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications by ids {}", applicationIds, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications by ids {}" + applicationIds, ex);
        }
    }

    @Override
    public Set<String> findIdsByUser(ExecutionContext executionContext, String username, Sortable sortable) {
        this.LOGGER.debug("Find applications for user {}", (Object)username);
        ApplicationQuery applicationQuery = new ApplicationQuery();
        applicationQuery.setUser(username);
        applicationQuery.setStatus(ApplicationStatus.ACTIVE.name());
        applicationQuery.setExcludeFilters(Arrays.asList(ApplicationExcludeFilter.OWNER));
        return this.searchIds(executionContext, applicationQuery, sortable);
    }

    @Override
    public Set<String> findIdsByUserAndPermission(ExecutionContext executionContext, String username, Sortable sortable, RolePermission rolePermission, RolePermissionAction ... acl) {
        this.LOGGER.debug("Find applicationIds for user and permission {}, {}, {}", new Object[]{username, rolePermission, acl});
        ApplicationQuery applicationQuery = this.buildApplicationQueryForUserAndPermission(executionContext, rolePermission, acl, username);
        applicationQuery.setExcludeFilters(Arrays.asList(ApplicationExcludeFilter.OWNER));
        return this.searchIds(executionContext, applicationQuery, sortable);
    }

    @Override
    public List<ApplicationListItem> findByUserAndPermission(ExecutionContext executionContext, String username, Sortable sortable, RolePermission rolePermission, RolePermissionAction ... acl) {
        this.LOGGER.debug("Find applications for user and permission {}, {}, {}", new Object[]{username, rolePermission, acl});
        ApplicationQuery applicationQuery = this.buildApplicationQueryForUserAndPermission(executionContext, rolePermission, acl, username);
        return this.search(executionContext, applicationQuery, sortable, null).getContent();
    }

    @NotNull
    private ApplicationQuery buildApplicationQueryForUserAndPermission(ExecutionContext executionContext, RolePermission rolePermission, RolePermissionAction[] acl, String username) {
        List<String> roleIdsWithPermission = this.roleService.findAllByOrganization(executionContext.getOrganizationId()).stream().filter(roleEntity -> this.roleService.hasPermission(roleEntity.getPermissions(), rolePermission.getPermission(), acl)).map(RoleEntity::getId).collect(Collectors.toList());
        Set<String> appIds = this.membershipService.getReferenceIdsByMemberAndReferenceAndRoleIn(MembershipMemberType.USER, username, MembershipReferenceType.APPLICATION, roleIdsWithPermission);
        ApplicationQuery applicationQuery = new ApplicationQuery();
        applicationQuery.setIds(appIds);
        applicationQuery.setUser(username);
        applicationQuery.setStatus(ApplicationStatus.ACTIVE.name());
        return applicationQuery;
    }

    @Override
    public Set<ApplicationListItem> findByUser(ExecutionContext executionContext, String username, Sortable sortable, Pageable pageable) {
        this.LOGGER.debug("Find applications for user {}", (Object)username);
        ApplicationQuery applicationQuery = new ApplicationQuery();
        applicationQuery.setUser(username);
        applicationQuery.setStatus(ApplicationStatus.ACTIVE.name());
        Page<ApplicationListItem> applications = this.search(executionContext, applicationQuery, sortable, pageable);
        return new LinkedHashSet<ApplicationListItem>(applications.getContent());
    }

    @Override
    public Set<String> findIdsByOrganization(String organizationId) {
        this.LOGGER.debug("Find applications by organization {} ", (Object)organizationId);
        if (organizationId == null || organizationId.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return this.searchIds(new ExecutionContext(organizationId, null), new ApplicationQuery(), null);
    }

    @Override
    public Set<ApplicationListItem> findByGroups(ExecutionContext executionContext, List<String> groupIds) {
        return this.findByGroupsAndStatus(executionContext, groupIds, ApplicationStatus.ACTIVE.name());
    }

    @Override
    public Set<ApplicationListItem> findByGroupsAndStatus(ExecutionContext executionContext, List<String> groupIds, String status) {
        this.LOGGER.debug("Find applications by groups {}", groupIds);
        try {
            ApplicationStatus requestedStatus = ApplicationStatus.valueOf((String)status.toUpperCase());
            Set applications = this.applicationRepository.findByGroups(groupIds, new ApplicationStatus[]{ApplicationStatus.valueOf((String)status.toUpperCase())});
            return ApplicationStatus.ACTIVE.equals((Object)requestedStatus) ? this.convertToList(executionContext, applications) : this.convertToSimpleList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for groups {}", groupIds, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for groups " + groupIds, ex);
        }
    }

    @Override
    public ApplicationEntity create(ExecutionContext executionContext, NewApplicationEntity newApplicationEntity, String userId) {
        this.LOGGER.debug("Create {} for user {}", (Object)newApplicationEntity, (Object)userId);
        if (newApplicationEntity.getSettings().getApp() != null && newApplicationEntity.getSettings().getoAuthClient() != null) {
            throw new InvalidApplicationTypeException();
        }
        if (newApplicationEntity.getSettings().getApp() == null && newApplicationEntity.getSettings().getoAuthClient() == null) {
            throw new InvalidApplicationTypeException();
        }
        if (newApplicationEntity.getApiKeyMode() == io.gravitee.rest.api.model.ApiKeyMode.SHARED && !this.parameterService.findAsBoolean(executionContext, Key.PLAN_SECURITY_APIKEY_SHARED_ALLOWED, ParameterReferenceType.ENVIRONMENT)) {
            throw new InvalidApplicationApiKeyModeException("Can't create application with SHARED api key mode cause environment setting is disabled");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (newApplicationEntity.getSettings().getApp() != null) {
            if (this.isClientRegistrationEnabled(executionContext, executionContext.getEnvironmentId()) && !this.isApplicationTypeAllowed(executionContext, "simple", executionContext.getEnvironmentId())) {
                throw new IllegalStateException("Application type 'simple' is not allowed");
            }
            String clientId = newApplicationEntity.getSettings().getApp().getClientId();
            if (clientId != null && !clientId.trim().isEmpty()) {
                this.checkClientIdIsUniqueForEnv(executionContext.getEnvironmentId(), clientId);
            }
        } else {
            this.checkClientRegistrationEnabled(executionContext, executionContext.getEnvironmentId());
            String appType = newApplicationEntity.getSettings().getoAuthClient().getApplicationType();
            if (!this.isApplicationTypeAllowed(executionContext, appType, executionContext.getEnvironmentId())) {
                throw new IllegalStateException("Application type '" + appType + "' is not allowed");
            }
            this.checkClientSettings(newApplicationEntity.getSettings().getoAuthClient());
            ClientRegistrationResponse registrationResponse = this.clientRegistrationService.register(executionContext, newApplicationEntity);
            try {
                metadata.put("client_id", registrationResponse.getClientId());
                metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
            }
            catch (JsonProcessingException e) {
                this.LOGGER.error("An error has occurred while serializing registration response", (Throwable)e);
            }
        }
        if (newApplicationEntity.getGroups() != null && !newApplicationEntity.getGroups().isEmpty()) {
            this.groupService.findByIds(newApplicationEntity.getGroups());
        }
        Application application = this.applicationConverter.toApplication(newApplicationEntity);
        application.setId(UuidString.generateRandom());
        application.setStatus(ApplicationStatus.ACTIVE);
        metadata.forEach((key, value) -> application.getMetadata().put(key, value));
        Set defaultGroups = this.groupService.findByEvent(executionContext.getEnvironmentId(), GroupEvent.APPLICATION_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
        if (!defaultGroups.isEmpty() && application.getGroups() == null) {
            application.setGroups(defaultGroups);
        } else if (!defaultGroups.isEmpty()) {
            application.getGroups().addAll(defaultGroups);
        }
        application.setCreatedAt(new Date());
        application.setUpdatedAt(application.getCreatedAt());
        return this.createApplicationForEnvironment(executionContext, userId, application);
    }

    @NotNull
    private ApplicationEntity createApplicationForEnvironment(ExecutionContext executionContext, String userId, Application application) {
        try {
            application.setEnvironmentId(executionContext.getEnvironmentId());
            Application createdApplication = (Application)this.applicationRepository.create((Object)application);
            this.auditService.createApplicationAuditLog(executionContext, createdApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_CREATED, createdApplication.getCreatedAt(), null, createdApplication);
            this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.APPLICATION, createdApplication.getId()), new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.APPLICATION, SystemRole.PRIMARY_OWNER.name()));
            UserEntity userEntity = this.userService.findById(executionContext, userId);
            if (userEntity.getEmail() != null && !userEntity.getEmail().isEmpty()) {
                GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
                notificationConfigEntity.setName("Default Mail Notifications");
                notificationConfigEntity.setReferenceType(HookScope.APPLICATION.name());
                notificationConfigEntity.setReferenceId(createdApplication.getId());
                notificationConfigEntity.setHooks(Arrays.stream(ApplicationHook.values()).map(Enum::name).collect(Collectors.toList()));
                notificationConfigEntity.setNotifier("default-email");
                notificationConfigEntity.setConfig(userEntity.getEmail());
                this.genericNotificationConfigService.create(notificationConfigEntity);
            }
            return this.convert(executionContext, createdApplication, userEntity);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for user {} in environment {}", new Object[]{application, userId, executionContext.getEnvironmentId(), ex});
            throw new TechnicalManagementException("An error occurs while trying create " + application + " for user " + userId + " in environment " + executionContext.getEnvironmentId(), ex);
        }
    }

    private void checkClientSettings(OAuthClientSettings oAuthClientSettings) {
        if (oAuthClientSettings.getGrantTypes() == null || oAuthClientSettings.getGrantTypes().isEmpty()) {
            throw new ApplicationGrantTypesNotFoundException();
        }
        ApplicationTypeEntity applicationType = this.applicationTypeService.getApplicationType(oAuthClientSettings.getApplicationType());
        List targetGrantTypes = oAuthClientSettings.getGrantTypes();
        List allowedGrantTypes = applicationType.getAllowed_grant_types().stream().map(ApplicationGrantTypeEntity::getType).collect(Collectors.toList());
        if (!allowedGrantTypes.containsAll(targetGrantTypes)) {
            throw new ApplicationGrantTypesNotAllowedException(oAuthClientSettings.getApplicationType(), targetGrantTypes);
        }
        List redirectUris = oAuthClientSettings.getRedirectUris();
        if (applicationType.getRequires_redirect_uris().booleanValue() && (redirectUris == null || redirectUris.isEmpty())) {
            throw new ApplicationRedirectUrisNotFound();
        }
        List responseTypes = applicationType.getAllowed_grant_types().stream().filter(applicationGrantTypeEntity -> targetGrantTypes.contains(applicationGrantTypeEntity.getType())).map(ApplicationGrantTypeEntity::getResponse_types).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        oAuthClientSettings.setResponseTypes(responseTypes);
    }

    @Override
    public ApplicationEntity update(ExecutionContext executionContext, String applicationId, UpdateApplicationEntity updateApplicationEntity) {
        try {
            Application applicationToUpdate;
            this.LOGGER.debug("Update application {}", (Object)applicationId);
            if (updateApplicationEntity.getGroups() != null && !updateApplicationEntity.getGroups().isEmpty()) {
                this.groupService.findByIds(updateApplicationEntity.getGroups());
            }
            if (ApplicationStatus.ARCHIVED.equals((Object)(applicationToUpdate = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new ApplicationNotFoundException(applicationId))).getStatus())) {
                throw new ApplicationArchivedException(applicationToUpdate.getName());
            }
            if (updateApplicationEntity.getSettings().getApp() != null && updateApplicationEntity.getSettings().getoAuthClient() != null) {
                throw new InvalidApplicationTypeException();
            }
            if (updateApplicationEntity.getSettings().getApp() == null && updateApplicationEntity.getSettings().getoAuthClient() == null) {
                throw new InvalidApplicationTypeException();
            }
            this.checkApiKeyModeUpdate(executionContext, updateApplicationEntity, applicationToUpdate);
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (applicationToUpdate.getType() == ApplicationType.SIMPLE && updateApplicationEntity.getSettings().getApp() != null) {
                String clientId = updateApplicationEntity.getSettings().getApp().getClientId();
                if (clientId != null && !clientId.trim().isEmpty()) {
                    this.LOGGER.debug("Check that client_id is unique among all applications");
                    Set applications = this.applicationRepository.findAllByEnvironment(executionContext.getEnvironmentId(), new ApplicationStatus[]{ApplicationStatus.ACTIVE});
                    Optional<Application> byClientId = applications.stream().filter(app -> app.getMetadata() != null && clientId.equals(app.getMetadata().get("client_id"))).findAny();
                    if (byClientId.isPresent() && !byClientId.get().getId().equals(applicationToUpdate.getId())) {
                        this.LOGGER.error("An application already exists with the same client_id");
                        throw new ClientIdAlreadyExistsException(clientId);
                    }
                }
            } else {
                this.checkClientRegistrationEnabled(executionContext, executionContext.getEnvironmentId());
                this.checkClientSettings(updateApplicationEntity.getSettings().getoAuthClient());
                String registrationPayload = (String)applicationToUpdate.getMetadata().get("registration_payload");
                if (registrationPayload != null) {
                    try {
                        ClientRegistrationResponse registrationResponse = this.clientRegistrationService.update(executionContext, registrationPayload, updateApplicationEntity);
                        metadata.put("client_id", registrationResponse.getClientId());
                        metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
                    }
                    catch (Exception e) {
                        this.LOGGER.error("Failed to update OAuth client data from client registration. Keeping old OAuth client data.", (Throwable)e);
                        metadata.put("client_id", (String)applicationToUpdate.getMetadata().get("client_id"));
                        metadata.put("registration_payload", (String)applicationToUpdate.getMetadata().get("registration_payload"));
                    }
                }
            }
            Application application = this.applicationConverter.toApplication(updateApplicationEntity);
            application.setId(applicationId);
            application.setEnvironmentId(applicationToUpdate.getEnvironmentId());
            application.setStatus(ApplicationStatus.ACTIVE);
            application.setType(applicationToUpdate.getType());
            application.setCreatedAt(applicationToUpdate.getCreatedAt());
            application.setUpdatedAt(new Date());
            metadata.forEach((key, value) -> application.getMetadata().put(key, value));
            Application updatedApplication = (Application)this.applicationRepository.update((Object)application);
            this.auditService.createApplicationAuditLog(executionContext, updatedApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_UPDATED, updatedApplication.getUpdatedAt(), applicationToUpdate, updatedApplication);
            SubscriptionQuery subQuery = new SubscriptionQuery();
            subQuery.setApplication(applicationId);
            subQuery.setStatuses(Collections.singleton(SubscriptionStatus.ACCEPTED));
            this.subscriptionService.search(executionContext, subQuery).forEach(subscriptionEntity -> {
                UpdateSubscriptionEntity updateSubscriptionEntity = new UpdateSubscriptionEntity();
                updateSubscriptionEntity.setId(subscriptionEntity.getId());
                updateSubscriptionEntity.setStartingAt(subscriptionEntity.getStartingAt());
                updateSubscriptionEntity.setEndingAt(subscriptionEntity.getEndingAt());
                this.subscriptionService.update(executionContext, updateSubscriptionEntity, (String)application.getMetadata().get("client_id"));
            });
            return this.convertApplication(executionContext, Collections.singleton(updatedApplication)).iterator().next();
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update application %s", applicationId), ex);
        }
    }

    @Override
    public ApplicationEntity renewClientSecret(ExecutionContext executionContext, String applicationId) {
        try {
            this.LOGGER.debug("Renew client secret for application {}", (Object)applicationId);
            Application applicationToUpdate = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new ApplicationNotFoundException(applicationId));
            if (ApplicationStatus.ARCHIVED.equals((Object)applicationToUpdate.getStatus())) {
                throw new ApplicationArchivedException(applicationToUpdate.getName());
            }
            this.checkClientRegistrationEnabled(executionContext, executionContext.getEnvironmentId());
            ApplicationEntity applicationEntity = this.findById(executionContext, applicationId);
            if (applicationEntity.getSettings().getoAuthClient() != null && applicationEntity.getSettings().getoAuthClient().isRenewClientSecretSupported()) {
                ClientRegistrationResponse registrationResponse = this.clientRegistrationService.renewClientSecret(executionContext, (String)applicationToUpdate.getMetadata().get("registration_payload"));
                HashMap<String, String> metadata = new HashMap<String, String>();
                try {
                    metadata.put("client_id", registrationResponse.getClientId());
                    metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
                }
                catch (JsonProcessingException e) {
                    this.LOGGER.error("An error has occurred while writing registration response", (Throwable)e);
                }
                applicationToUpdate.setUpdatedAt(new Date());
                metadata.forEach((key, value) -> applicationToUpdate.getMetadata().put(key, value));
                Application updatedApplication = (Application)this.applicationRepository.update((Object)applicationToUpdate);
                this.auditService.createApplicationAuditLog(executionContext, updatedApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_UPDATED, updatedApplication.getUpdatedAt(), applicationToUpdate, updatedApplication);
                return this.convertApplication(executionContext, Collections.singleton(updatedApplication)).iterator().next();
            }
            throw new ApplicationRenewClientSecretException(applicationToUpdate.getName());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to renew client secret {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to renew client secret %s", applicationId), ex);
        }
    }

    @Override
    public ApplicationEntity restore(ExecutionContext executionContext, String applicationId) {
        try {
            this.LOGGER.debug("Restore application {}", (Object)applicationId);
            Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new ApplicationNotFoundException(applicationId));
            if (!ApplicationStatus.ARCHIVED.equals((Object)application.getStatus())) {
                throw new ApplicationActiveException(application.getName());
            }
            if (application.getMetadata() != null && application.getMetadata().containsKey("client_id")) {
                this.checkClientIdIsUniqueForEnv(application.getEnvironmentId(), (String)application.getMetadata().get("client_id"));
            }
            application.setStatus(ApplicationStatus.ACTIVE);
            application.setUpdatedAt(new Date());
            String userId = this.getAuthenticatedUsername();
            this.membershipService.deleteReference(executionContext, MembershipReferenceType.APPLICATION, applicationId);
            this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.APPLICATION, applicationId), new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.APPLICATION, SystemRole.PRIMARY_OWNER.name()));
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.APPLICATION, applicationId);
            this.portalNotificationConfigService.deleteReference(NotificationReferenceType.APPLICATION, applicationId);
            Application restoredApplication = (Application)this.applicationRepository.update((Object)application);
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApplicationAndPlan(executionContext, applicationId, null);
            subscriptions.forEach(subscription -> {
                try {
                    this.subscriptionService.restore(executionContext, subscription.getId());
                }
                catch (SubscriptionNotPausedException snce) {
                    this.LOGGER.debug("The subscription can not be closed: {}", (Object)snce.getMessage());
                }
            });
            UserEntity userEntity = this.userService.findById(executionContext, userId);
            this.auditService.createApplicationAuditLog(executionContext, restoredApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_RESTORED, restoredApplication.getUpdatedAt(), application, restoredApplication);
            return this.convert(executionContext, restoredApplication, userEntity);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to restore {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to restore %s", applicationId), ex);
        }
    }

    private void checkClientRegistrationEnabled(ExecutionContext executionContext, String environmentId) {
        if (!this.isClientRegistrationEnabled(executionContext, environmentId)) {
            throw new IllegalStateException("The client registration is disabled");
        }
    }

    private boolean isClientRegistrationEnabled(ExecutionContext executionContext, String environmentId) {
        return this.parameterService.findAsBoolean(executionContext, Key.APPLICATION_REGISTRATION_ENABLED, environmentId, ParameterReferenceType.ENVIRONMENT);
    }

    private boolean isApplicationTypeAllowed(ExecutionContext executionContext, String applicationType, String environmentId) {
        Key key = Key.valueOf((String)("APPLICATION_TYPE_" + applicationType.toUpperCase() + "_ENABLED"));
        return this.parameterService.findAsBoolean(executionContext, key, environmentId, ParameterReferenceType.ENVIRONMENT);
    }

    @Override
    public void archive(ExecutionContext executionContext, String applicationId) {
        try {
            this.LOGGER.debug("Delete application {}", (Object)applicationId);
            Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new ApplicationNotFoundException(applicationId));
            Application previousApplication = new Application(application);
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApplicationAndPlan(executionContext, applicationId, null);
            subscriptions.forEach(subscription -> {
                List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(executionContext, subscription.getId());
                apiKeys.forEach(apiKey -> {
                    try {
                        this.apiKeyService.delete(apiKey.getKey());
                    }
                    catch (TechnicalManagementException tme) {
                        this.LOGGER.error("An error occurs while deleting API Key with id {}", (Object)apiKey.getId(), (Object)tme);
                    }
                });
                try {
                    this.subscriptionService.close(executionContext, subscription.getId());
                }
                catch (SubscriptionNotClosableException snce) {
                    this.LOGGER.debug("The subscription can not be closed: {}", (Object)snce.getMessage());
                }
            });
            application.setUpdatedAt(new Date());
            application.setStatus(ApplicationStatus.ARCHIVED);
            this.applicationRepository.update((Object)application);
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.APPLICATION, applicationId);
            this.membershipService.deleteReference(executionContext, MembershipReferenceType.APPLICATION, applicationId);
            this.applicationAlertService.deleteAll(applicationId);
            this.auditService.createApplicationAuditLog(executionContext, application.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_ARCHIVED, application.getUpdatedAt(), previousApplication, application);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete application %s", applicationId), ex);
        }
    }

    private Set<ApplicationEntity> convertApplication(ExecutionContext executionContext, Collection<Application> applications) throws TechnicalException {
        if (applications == null || applications.isEmpty()) {
            return Collections.emptySet();
        }
        RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.APPLICATION);
        if (primaryOwnerRole == null) {
            throw new RoleNotFoundException("APPLICATION_PRIMARY_OWNER");
        }
        List<String> activeApplicationIds = applications.parallelStream().filter(app -> ApplicationStatus.ACTIVE.equals((Object)app.getStatus())).map(Application::getId).collect(Collectors.toList());
        Set<MembershipEntity> memberships = this.membershipService.getMembershipsByReferencesAndRole(MembershipReferenceType.APPLICATION, activeApplicationIds, primaryOwnerRole.getId());
        int poMissing = activeApplicationIds.size() - memberships.size();
        if (poMissing > 0) {
            Set appMembershipsIds = memberships.stream().map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
            activeApplicationIds.removeAll(appMembershipsIds);
            Optional optionalApplicationsAsString = activeApplicationIds.stream().reduce((a, b) -> a + " / " + b);
            String applicationsAsString = "?";
            if (optionalApplicationsAsString.isPresent()) {
                applicationsAsString = (String)optionalApplicationsAsString.get();
            }
            this.LOGGER.error("{} applications has no identified primary owners in this list {}.", (Object)poMissing, (Object)applicationsAsString);
            throw new TechnicalManagementException(poMissing + " applications has no identified primary owners in this list " + applicationsAsString + ".");
        }
        HashMap applicationToUser = new HashMap(memberships.size());
        HashMap userIdToUserEntity = new HashMap(memberships.size());
        if (!memberships.isEmpty()) {
            memberships.forEach(membership -> applicationToUser.put(membership.getReferenceId(), membership.getMemberId()));
            this.userService.findByIds(executionContext, memberships.stream().map(MembershipEntity::getMemberId).collect(Collectors.toList()), false).forEach(userEntity -> userIdToUserEntity.put(userEntity.getId(), userEntity));
        }
        return applications.stream().map(publicApplication -> this.convert(executionContext, (Application)publicApplication, (UserEntity)userIdToUserEntity.get(applicationToUser.get(publicApplication.getId())))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<ApplicationListItem> convertToSimpleList(Collection<Application> applications) {
        return applications.stream().map(application -> {
            ApplicationListItem item = new ApplicationListItem();
            item.setId(application.getId());
            item.setName(application.getName());
            item.setDescription(application.getDescription());
            item.setDomain(application.getDomain());
            item.setCreatedAt(application.getCreatedAt());
            item.setUpdatedAt(application.getUpdatedAt());
            item.setType(application.getType().name());
            item.setStatus(application.getStatus().name());
            item.setPicture(application.getPicture());
            item.setBackground(application.getBackground());
            item.setDisableMembershipNotifications(application.isDisableMembershipNotifications());
            return item;
        }).collect(Collectors.toSet());
    }

    private Page<ApplicationListItem> convertToSimpleList(Page<Application> applications) {
        Set<ApplicationListItem> applicationListItems = this.convertToSimpleList(applications.getContent());
        return new Page(List.copyOf(applicationListItems), applications.getPageNumber(), applicationListItems.size(), applications.getTotalElements());
    }

    private Page<ApplicationListItem> convertToList(ExecutionContext executionContext, Page<Application> applications) throws TechnicalException {
        Set<ApplicationListItem> applicationListItems = this.convertToList(executionContext, applications.getContent());
        return new Page(List.copyOf(applicationListItems), applications.getPageNumber(), applicationListItems.size(), applications.getTotalElements());
    }

    private Set<ApplicationListItem> convertToList(ExecutionContext executionContext, Collection<Application> applications) throws TechnicalException {
        Set<ApplicationEntity> entities = this.convertApplication(executionContext, applications);
        return entities.stream().map(applicationEntity -> {
            ApplicationListItem item = new ApplicationListItem();
            item.setId(applicationEntity.getId());
            item.setName(applicationEntity.getName());
            item.setDescription(applicationEntity.getDescription());
            item.setDomain(applicationEntity.getDomain());
            item.setCreatedAt(applicationEntity.getCreatedAt());
            item.setUpdatedAt(applicationEntity.getUpdatedAt());
            item.setGroups(applicationEntity.getGroups());
            item.setPrimaryOwner(applicationEntity.getPrimaryOwner());
            item.setType(applicationEntity.getType());
            item.setStatus(applicationEntity.getStatus());
            item.setPicture(applicationEntity.getPicture());
            item.setBackground(applicationEntity.getBackground());
            item.setApiKeyMode(applicationEntity.getApiKeyMode());
            item.setDisableMembershipNotifications(applicationEntity.isDisableMembershipNotifications());
            Application app = applications.stream().filter(application -> application.getId().equals(applicationEntity.getId())).findFirst().get();
            item.setSettings(this.getSettings(executionContext, app));
            return item;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private ApplicationEntity convert(ExecutionContext executionContext, Application application, UserEntity primaryOwner) {
        if (primaryOwner == null) {
            primaryOwner = new UserEntity();
            primaryOwner.setId("0");
            primaryOwner.setFirstname("Unknown");
            primaryOwner.setLastname("User");
        }
        ApplicationEntity applicationEntity = new ApplicationEntity();
        applicationEntity.setId(application.getId());
        applicationEntity.setName(application.getName());
        applicationEntity.setDescription(application.getDescription());
        applicationEntity.setDomain(application.getDomain());
        if (application.getType() != null) {
            applicationEntity.setType(application.getType().name());
        }
        applicationEntity.setStatus(application.getStatus().toString());
        applicationEntity.setPicture(application.getPicture());
        applicationEntity.setBackground(application.getBackground());
        applicationEntity.setGroups(application.getGroups());
        applicationEntity.setCreatedAt(application.getCreatedAt());
        applicationEntity.setUpdatedAt(application.getUpdatedAt());
        applicationEntity.setPrimaryOwner(new PrimaryOwnerEntity(primaryOwner));
        applicationEntity.setSettings(this.getSettings(executionContext, application));
        applicationEntity.setDisableMembershipNotifications(application.isDisableMembershipNotifications());
        if (application.getApiKeyMode() != null) {
            applicationEntity.setApiKeyMode(io.gravitee.rest.api.model.ApiKeyMode.valueOf((String)application.getApiKeyMode().name()));
        }
        return applicationEntity;
    }

    private ApplicationSettings getSettings(ExecutionContext executionContext, Application application) {
        ApplicationSettings settings = new ApplicationSettings();
        if (application.getType() == ApplicationType.SIMPLE) {
            SimpleApplicationSettings simpleSettings = new SimpleApplicationSettings();
            if (application.getMetadata() != null) {
                if (application.getMetadata().get("client_id") != null) {
                    simpleSettings.setClientId((String)application.getMetadata().get("client_id"));
                }
                if (application.getMetadata().get("type") != null) {
                    simpleSettings.setType((String)application.getMetadata().get("type"));
                }
            }
            settings.setApp(simpleSettings);
        } else {
            OAuthClientSettings clientSettings = new OAuthClientSettings();
            if (application.getMetadata() != null) {
                try {
                    Iterator<ClientRegistrationProviderEntity> clientRegistrationProviderIte;
                    String registrationPayload = (String)application.getMetadata().get("registration_payload");
                    if (registrationPayload != null) {
                        ClientRegistrationResponse registrationResponse = (ClientRegistrationResponse)this.mapper.readValue(registrationPayload, ClientRegistrationResponse.class);
                        clientSettings.setClientId(registrationResponse.getClientId());
                        clientSettings.setClientSecret(registrationResponse.getClientSecret());
                        clientSettings.setClientUri(registrationResponse.getClientUri());
                        clientSettings.setApplicationType(registrationResponse.getApplicationType());
                        clientSettings.setLogoUri(registrationResponse.getLogoUri());
                        clientSettings.setResponseTypes(registrationResponse.getResponseTypes());
                        clientSettings.setRedirectUris(registrationResponse.getRedirectUris());
                        clientSettings.setGrantTypes(registrationResponse.getGrantTypes());
                    }
                    if ((clientRegistrationProviderIte = this.clientRegistrationService.findAll(executionContext).iterator()).hasNext()) {
                        clientSettings.setRenewClientSecretSupported(clientRegistrationProviderIte.next().isRenewClientSecretSupport());
                    }
                }
                catch (IOException e) {
                    this.LOGGER.error("An error occurred while reading client settings");
                }
            }
            settings.setoAuthClient(clientSettings);
        }
        return settings;
    }

    @Override
    public InlinePictureEntity getPicture(ExecutionContext executionContext, String applicationId) {
        ApplicationEntity applicationEntity = this.findById(executionContext, applicationId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (applicationEntity.getPicture() != null) {
            String[] parts = applicationEntity.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = applicationEntity.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public InlinePictureEntity getBackground(ExecutionContext executionContext, String applicationId) {
        ApplicationEntity applicationEntity = this.findById(executionContext, applicationId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (applicationEntity.getBackground() != null) {
            String[] parts = applicationEntity.getBackground().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = applicationEntity.getBackground().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public Map<String, Object> findByIdAsMap(String id) throws TechnicalException {
        Application application = (Application)this.applicationRepository.findById((Object)id).orElseThrow(() -> new ApplicationNotFoundException(id));
        ExecutionContext executionContext = new ExecutionContext(this.environmentService.findById(application.getEnvironmentId()));
        ApplicationEntity applicationEntity = this.convertAndFillPrimaryOwner(executionContext, application);
        Map dataAsMap = (Map)this.mapper.convertValue((Object)applicationEntity, Map.class);
        dataAsMap.remove("picture");
        return dataAsMap;
    }

    @Override
    public Set<String> searchIds(ExecutionContext executionContext, ApplicationQuery applicationQuery, Sortable sortable) {
        try {
            ApplicationCriteria searchCriteria = this.buildSearchCriteria(executionContext, applicationQuery);
            if (searchCriteria == null) {
                return Collections.emptySet();
            }
            return this.applicationRepository.searchIds(searchCriteria, ApplicationServiceImpl.convert(sortable));
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to search applications for query {}", (Object)applicationQuery, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for query " + applicationQuery, ex);
        }
    }

    @Override
    public Page<ApplicationListItem> search(ExecutionContext executionContext, ApplicationQuery applicationQuery, Sortable sortable, Pageable pageable) {
        try {
            ApplicationCriteria searchCriteria = this.buildSearchCriteria(executionContext, applicationQuery);
            if (searchCriteria == null) {
                return new Page(Collections.emptyList(), 1, 0, 0L);
            }
            Page applications = this.applicationRepository.search(searchCriteria, ApplicationServiceImpl.convert(pageable), ApplicationServiceImpl.convert(sortable));
            if (!ApplicationStatus.ARCHIVED.name().equals(applicationQuery.getStatus()) && applicationQuery.includeOwner()) {
                return this.convertToList(executionContext, (Page<Application>)applications);
            }
            return this.convertToSimpleList((Page<Application>)applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to search applications for query {}", (Object)applicationQuery, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for query " + applicationQuery, ex);
        }
    }

    private ApplicationCriteria buildSearchCriteria(ExecutionContext executionContext, ApplicationQuery applicationQuery) {
        ApplicationCriteria.Builder criteriaBuilder = new ApplicationCriteria.Builder();
        if (executionContext.hasEnvironmentId()) {
            criteriaBuilder.environmentIds((Set)Sets.newHashSet((Object[])new String[]{executionContext.getEnvironmentId()}));
        } else {
            Set environmentIds = this.environmentService.findByOrganization(executionContext.getOrganizationId()).stream().map(EnvironmentEntity::getId).collect(Collectors.toSet());
            criteriaBuilder.environmentIds(environmentIds);
        }
        if (applicationQuery.getIds() != null && !applicationQuery.getIds().isEmpty()) {
            criteriaBuilder.ids(applicationQuery.getIds());
        }
        ApplicationStatus applicationStatus = null;
        if (applicationQuery.getGroups() != null && !applicationQuery.getGroups().isEmpty()) {
            criteriaBuilder.groups(applicationQuery.getGroups());
        }
        if (applicationQuery.getStatus() != null && !applicationQuery.getStatus().isBlank()) {
            applicationStatus = ApplicationStatus.valueOf((String)applicationQuery.getStatus().toUpperCase());
            criteriaBuilder.status(applicationStatus);
        }
        if (applicationQuery.getName() != null && !applicationQuery.getName().isBlank()) {
            criteriaBuilder.name(applicationQuery.getName());
        }
        if (applicationQuery.getUser() != null && !applicationQuery.getUser().isBlank()) {
            Set<String> userApplicationsIds = this.findUserApplicationsIds(executionContext, applicationQuery.getUser(), applicationStatus);
            if (userApplicationsIds.isEmpty()) {
                return null;
            }
            criteriaBuilder.ids(userApplicationsIds);
        }
        return criteriaBuilder.build();
    }

    private Set<String> findUserApplicationsIds(ExecutionContext executionContext, String username, ApplicationStatus status) {
        Set<String> appIds = this.membershipService.getReferenceIdsByMemberAndReference(MembershipMemberType.USER, username, MembershipReferenceType.APPLICATION);
        List groupIds = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, username, MembershipReferenceType.GROUP).stream().filter(m -> m.getRoleId() != null && this.roleService.findById(m.getRoleId()).getScope().equals((Object)RoleScope.APPLICATION)).map(MembershipEntity::getReferenceId).collect(Collectors.toList());
        if (!groupIds.isEmpty()) {
            ApplicationQuery applicationQueryWithGroupsAndStatus = new ApplicationQuery();
            applicationQueryWithGroupsAndStatus.setGroups(new HashSet(groupIds));
            if (status != null) {
                applicationQueryWithGroupsAndStatus.setStatus(status.name());
            }
            appIds.addAll(this.searchIds(executionContext, applicationQueryWithGroupsAndStatus, null));
        }
        return appIds;
    }

    private void checkClientIdIsUniqueForEnv(String environmentId, String clientId) {
        boolean alreadyExistingApp;
        try {
            alreadyExistingApp = this.applicationRepository.findAllByEnvironment(environmentId, new ApplicationStatus[]{ApplicationStatus.ACTIVE}).stream().anyMatch(app -> app.getMetadata() != null && clientId.equals(app.getMetadata().get("client_id")));
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to fetch applications for environment [" + environmentId + "]", ex);
        }
        if (alreadyExistingApp) {
            throw new ClientIdAlreadyExistsException(clientId);
        }
    }

    private void checkApiKeyModeUpdate(ExecutionContext executionContext, UpdateApplicationEntity updateApplicationEntity, Application applicationToUpdate) {
        if (updateApplicationEntity.getApiKeyMode() == null && applicationToUpdate.getApiKeyMode() != null) {
            updateApplicationEntity.setApiKeyMode(io.gravitee.rest.api.model.ApiKeyMode.valueOf((String)applicationToUpdate.getApiKeyMode().name()));
        } else {
            if (applicationToUpdate.getApiKeyMode() != null && !applicationToUpdate.getApiKeyMode().isUpdatable() && !applicationToUpdate.getApiKeyMode().name().equals(updateApplicationEntity.getApiKeyMode().name())) {
                throw new InvalidApplicationApiKeyModeException(String.format("Can't update application %s Api key mode cause current Api Key Mode %s is not updatable", applicationToUpdate.getId(), applicationToUpdate.getApiKeyMode()));
            }
            if (updateApplicationEntity.getApiKeyMode() == io.gravitee.rest.api.model.ApiKeyMode.SHARED && applicationToUpdate.getApiKeyMode() != ApiKeyMode.SHARED && !this.parameterService.findAsBoolean(executionContext, Key.PLAN_SECURITY_APIKEY_SHARED_ALLOWED, ParameterReferenceType.ENVIRONMENT)) {
                throw new InvalidApplicationApiKeyModeException(String.format("Can't update application %s Api key mode to SHARED cause environment setting is disabled", applicationToUpdate.getId()));
            }
        }
    }

    private ApplicationEntity convertAndFillPrimaryOwner(ExecutionContext executionContext, Application application) {
        MembershipEntity primaryOwnerMemberEntity = this.membershipService.getPrimaryOwner(executionContext.getOrganizationId(), MembershipReferenceType.APPLICATION, application.getId());
        if (primaryOwnerMemberEntity == null) {
            if (!ApplicationStatus.ARCHIVED.equals((Object)application.getStatus())) {
                this.LOGGER.error("The Application {} doesn't have any primary owner.", (Object)application.getId());
            }
            return this.convert(executionContext, application, null);
        }
        return this.convert(executionContext, application, this.userService.findById(executionContext, primaryOwnerMemberEntity.getMemberId()));
    }
}

