/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.sanitizer;

import java.util.List;
import org.owasp.html.Handler;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;

final class AllowAllSanitizer {
    private AllowAllSanitizer() {
    }

    public static String sanitize(String content) {
        return new AllowAllPolicy().sanitize(content);
    }

    private static class AllowAllPolicy
    implements HtmlSanitizer.Policy {
        private final StringBuilder htmlOutput = new StringBuilder();
        private final HtmlStreamEventReceiver delegate = HtmlStreamRenderer.create((StringBuilder)this.htmlOutput, (Handler)Handler.DO_NOTHING);

        private AllowAllPolicy() {
        }

        public void openDocument() {
            this.delegate.openDocument();
        }

        public void openTag(String tagName, List<String> attrs) {
            this.delegate.openTag(tagName, attrs);
        }

        public void text(String text) {
            this.delegate.text(text);
        }

        public void closeTag(String tagName) {
            this.delegate.closeTag(tagName);
        }

        public void closeDocument() {
            this.delegate.closeDocument();
        }

        public String sanitize(String content) {
            HtmlSanitizer.sanitize((String)content, (HtmlSanitizer.Policy)this);
            return this.htmlOutput.toString();
        }
    }
}

