/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.ConsumerType;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.repository.management.model.flow.FlowConsumer;
import io.gravitee.repository.management.model.flow.FlowConsumerType;
import io.gravitee.repository.management.model.flow.FlowOperator;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.repository.management.model.flow.FlowStep;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FlowConverter {
    private static final Logger log = LoggerFactory.getLogger(FlowConverter.class);
    private ObjectMapper objectMapper;

    public FlowConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Flow toDefinition(io.gravitee.repository.management.model.flow.Flow model) {
        Flow flow = new Flow();
        flow.setCondition(model.getCondition());
        flow.setEnabled(model.isEnabled());
        flow.setMethods(model.getMethods());
        flow.setName(model.getName());
        PathOperator pathOperator = new PathOperator();
        pathOperator.setPath(model.getPath());
        pathOperator.setOperator(Operator.valueOf((String)model.getOperator().name()));
        flow.setPathOperator(pathOperator);
        flow.setPre(model.getPre().stream().map(this::toDefinitionStep).filter(Objects::nonNull).collect(Collectors.toList()));
        flow.setPost(model.getPost().stream().map(this::toDefinitionStep).filter(Objects::nonNull).collect(Collectors.toList()));
        flow.setConsumers(model.getConsumers().stream().map(this::toDefinitionConsumer).collect(Collectors.toList()));
        return flow;
    }

    public io.gravitee.repository.management.model.flow.Flow toRepository(Flow flowDefinition, FlowReferenceType referenceType, String referenceId, int order) {
        io.gravitee.repository.management.model.flow.Flow flow = new io.gravitee.repository.management.model.flow.Flow();
        flow.setId(UuidString.generateRandom());
        flow.setCreatedAt(new Date());
        flow.setUpdatedAt(flow.getCreatedAt());
        flow.setOrder(order);
        flow.setReferenceType(referenceType);
        flow.setReferenceId(referenceId);
        flow.setPost(flowDefinition.getPost().stream().map(this::toRepositoryStep).collect(Collectors.toList()));
        flow.setPre(flowDefinition.getPre().stream().map(this::toRepositoryStep).collect(Collectors.toList()));
        flow.setPath(flowDefinition.getPath());
        flow.setOperator(FlowOperator.valueOf((String)flowDefinition.getOperator().name()));
        flow.setName(flowDefinition.getName());
        flow.setMethods(flowDefinition.getMethods());
        flow.setEnabled(flowDefinition.isEnabled());
        flow.setCondition(flowDefinition.getCondition());
        flow.setConsumers(flowDefinition.getConsumers() != null ? flowDefinition.getConsumers().stream().map(this::toRepositoryConsumer).collect(Collectors.toList()) : Collections.emptyList());
        return flow;
    }

    private FlowConsumer toRepositoryConsumer(Consumer consumer) {
        FlowConsumer flowConsumer = new FlowConsumer();
        flowConsumer.setConsumerId(consumer.getConsumerId());
        flowConsumer.setConsumerType(FlowConsumerType.valueOf((String)consumer.getConsumerType().name()));
        return flowConsumer;
    }

    private Consumer toDefinitionConsumer(FlowConsumer flowConsumer) {
        Consumer consumer = new Consumer();
        consumer.setConsumerId(flowConsumer.getConsumerId());
        consumer.setConsumerType(ConsumerType.valueOf((String)flowConsumer.getConsumerType().name()));
        return consumer;
    }

    private FlowStep toRepositoryStep(Step step) {
        FlowStep flowStep = new FlowStep();
        flowStep.setPolicy(step.getPolicy());
        flowStep.setName(step.getName());
        flowStep.setEnabled(step.isEnabled());
        flowStep.setConfiguration(step.getConfiguration());
        flowStep.setDescription(step.getDescription());
        flowStep.setCondition(step.getCondition());
        return flowStep;
    }

    protected Step toDefinitionStep(FlowStep flowStep) {
        try {
            return (Step)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)flowStep), Step.class);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to convert repository flow step to model", (Throwable)e);
            return null;
        }
    }
}

