/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.installation.InstallationCommand;
import io.gravitee.cockpit.api.command.installation.InstallationPayload;
import io.gravitee.cockpit.api.command.installation.InstallationReply;
import io.gravitee.rest.api.service.InstallationService;
import io.reactivex.Single;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InstallationCommandHandler
implements CommandHandler<InstallationCommand, InstallationReply> {
    private final Logger logger = LoggerFactory.getLogger(InstallationCommandHandler.class);
    private final InstallationService installationService;

    public InstallationCommandHandler(InstallationService installationService) {
        this.installationService = installationService;
    }

    public Command.Type handleType() {
        return Command.Type.INSTALLATION_COMMAND;
    }

    public Single<InstallationReply> handle(InstallationCommand command) {
        InstallationPayload installationPayload = (InstallationPayload)command.getPayload();
        Map additionalInformation = this.installationService.getOrInitialize().getAdditionalInformation();
        additionalInformation.put("COCKPIT_INSTALLATION_STATUS", installationPayload.getStatus());
        try {
            this.installationService.setAdditionalInformation(additionalInformation);
            this.logger.info("Installation status is [{}].", (Object)installationPayload.getStatus());
            return Single.just((Object)new InstallationReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception ex) {
            this.logger.info("Error occurred when updating installation status.", (Throwable)ex);
            return Single.just((Object)new InstallationReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

