/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.DuplicateApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.ApiImportException;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.imports.ImportApiJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNodeWithIds;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiDuplicatorServiceImpl
extends AbstractService
implements ApiDuplicatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDuplicatorServiceImpl.class);
    public static final String API_DEFINITION_FIELD_GROUPS = "groups";
    public static final String API_DEFINITION_FIELD_PLANS = "plans";
    public static final String API_DEFINITION_FIELD_MEMBERS = "members";
    public static final String API_DEFINITION_FIELD_PAGES = "pages";
    private final HttpClientService httpClientService;
    private final ImportConfiguration importConfiguration;
    private final MediaService mediaService;
    private final ObjectMapper objectMapper;
    private final ApiMetadataService apiMetadataService;
    private final MembershipService membershipService;
    private final RoleService roleService;
    private final PageService pageService;
    private final PlanService planService;
    private final GroupService groupService;
    private final UserService userService;
    private final ApiService apiService;
    private final ApiConverter apiConverter;
    private final PlanConverter planConverter;
    private final PermissionService permissionService;

    public ApiDuplicatorServiceImpl(HttpClientService httpClientService, ImportConfiguration importConfiguration, MediaService mediaService, ObjectMapper objectMapper, ApiMetadataService apiMetadataService, MembershipService membershipService, RoleService roleService, PageService pageService, PlanService planService, GroupService groupService, UserService userService, ApiService apiService, ApiConverter apiConverter, PlanConverter planConverter, PermissionService permissionService) {
        this.httpClientService = httpClientService;
        this.importConfiguration = importConfiguration;
        this.mediaService = mediaService;
        this.objectMapper = objectMapper;
        this.apiMetadataService = apiMetadataService;
        this.membershipService = membershipService;
        this.roleService = roleService;
        this.pageService = pageService;
        this.planService = planService;
        this.groupService = groupService;
        this.userService = userService;
        this.apiService = apiService;
        this.apiConverter = apiConverter;
        this.planConverter = planConverter;
        this.permissionService = permissionService;
    }

    @Override
    public ApiEntity createWithImportedDefinition(String apiDefinitionOrURL, String organizationId, String environmentId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            ImportApiJsonNode apiJsonNode = this.recalculateApiDefinitionIds(new ImportApiJsonNode(this.objectMapper.readTree(apiDefinition)), environmentId);
            this.checkApiJsonConsistency(apiJsonNode);
            UpdateApiEntity importedApi = this.convertToEntity(apiJsonNode.toString(), apiJsonNode, environmentId);
            ApiEntity createdApiEntity = this.apiService.createWithApiDefinition(importedApi, this.getAuthenticatedUsername(), apiJsonNode.getJsonNode());
            this.createOrUpdateApiNestedEntities(createdApiEntity.getId(), apiJsonNode, organizationId, environmentId);
            this.createPageAndMedia(createdApiEntity, apiJsonNode, environmentId);
            return createdApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity updateWithImportedDefinition(String urlApiId, String apiDefinitionOrURL, String organizationId, String environmentId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            ImportApiJsonNode apiJsonNode = this.recalculateApiDefinitionIds(new ImportApiJsonNode(this.objectMapper.readTree(apiDefinition)), environmentId, urlApiId);
            if (!this.isAuthenticated() || !this.isAdmin() && !this.permissionService.hasPermission(RolePermission.API_DEFINITION, apiJsonNode.getId(), RolePermissionAction.UPDATE)) {
                throw new ForbiddenAccessException();
            }
            this.checkApiJsonConsistency(apiJsonNode, urlApiId, environmentId);
            UpdateApiEntity importedApi = this.convertToEntity(apiJsonNode.toString(), apiJsonNode, environmentId);
            ApiEntity updatedApiEntity = this.apiService.update(apiJsonNode.getId(), importedApi);
            this.createOrUpdateApiNestedEntities(updatedApiEntity.getId(), apiJsonNode, organizationId, environmentId);
            return updatedApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity duplicate(ApiEntity apiEntity, DuplicateApiEntity duplicateApiEntity, String organizationId, String environmentId) {
        Objects.requireNonNull(apiEntity, "Missing ApiEntity");
        String apiId = apiEntity.getId();
        LOGGER.debug("Duplicate API {}", (Object)apiId);
        UpdateApiEntity newApiEntity = this.apiConverter.toUpdateApiEntity(apiEntity, true);
        Proxy proxy = apiEntity.getProxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(duplicateApiEntity.getContextPath())));
        newApiEntity.setProxy(proxy);
        newApiEntity.setVersion(duplicateApiEntity.getVersion() == null ? apiEntity.getVersion() : duplicateApiEntity.getVersion());
        if (duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_GROUPS)) {
            newApiEntity.setGroups(null);
        } else {
            newApiEntity.setGroups(apiEntity.getGroups());
        }
        HashMap plansIdsMap = new HashMap();
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            newApiEntity.getPlans().forEach(plan -> {
                String newPlanId = UuidString.generateRandom();
                plansIdsMap.put(plan.getId(), newPlanId);
                plan.setId(newPlanId);
            });
        }
        ApiEntity duplicatedApi = this.apiService.createWithApiDefinition(newApiEntity, this.getAuthenticatedUsername(), null);
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_MEMBERS)) {
            Set<MembershipEntity> membershipsToDuplicate = this.membershipService.getMembershipsByReference(MembershipReferenceType.API, apiId);
            RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, RoleScope.API);
            if (primaryOwnerRole != null) {
                String primaryOwnerRoleId = primaryOwnerRole.getId();
                membershipsToDuplicate.forEach(membership -> {
                    String roleId = membership.getRoleId();
                    if (!primaryOwnerRoleId.equals(roleId)) {
                        this.membershipService.addRoleToMemberOnReference(organizationId, environmentId, MembershipReferenceType.API, duplicatedApi.getId(), membership.getMemberType(), membership.getMemberId(), roleId);
                    }
                });
            }
        }
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PAGES)) {
            List<PageEntity> pages = this.pageService.search(new PageQuery.Builder().api(apiId).build(), true, environmentId);
            this.pageService.duplicatePages(pages, environmentId, duplicatedApi.getId());
        }
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            this.planService.findByApi(apiId).forEach(plan -> {
                plan.setId((String)plansIdsMap.get(plan.getId()));
                plan.setApi(duplicatedApi.getId());
                this.planService.create(this.planConverter.toNewPlanEntity((PlanEntity)plan, true));
            });
        }
        return duplicatedApi;
    }

    private UpdateApiEntity convertToEntity(String apiDefinition, ImportApiJsonNode apiJsonNode, String environmentId) throws JsonProcessingException {
        List<ImportJsonNode> viewsNodes;
        UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(apiDefinition, UpdateApiEntity.class);
        if (Objects.equals(importedApi.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (importedApi.getPaths() == null || importedApi.getPaths().isEmpty())) {
            importedApi.setPaths(Collections.singletonMap("/", new ArrayList()));
        }
        if (importedApi.getGroups() != null) {
            HashSet groupNames = new HashSet(importedApi.getGroups());
            importedApi.getGroups().clear();
            for (String name : groupNames) {
                GroupEntity group;
                List<GroupEntity> groupEntities = this.groupService.findByName(environmentId, name);
                if (groupEntities.isEmpty()) {
                    NewGroupEntity newGroupEntity = new NewGroupEntity();
                    newGroupEntity.setName(name);
                    group = this.groupService.create(environmentId, newGroupEntity);
                } else {
                    group = groupEntities.get(0);
                }
                importedApi.getGroups().add(group.getId());
            }
        }
        if (!(viewsNodes = apiJsonNode.getViews()).isEmpty()) {
            Set categories = viewsNodes.stream().map(ImportJsonNode::asText).collect(Collectors.toSet());
            importedApi.setCategories(categories);
        }
        return importedApi;
    }

    private void createPageAndMedia(ApiEntity createdApiEntity, ImportApiJsonNode apiJsonNode, String environmentId) throws JsonProcessingException {
        for (ImportJsonNode media : apiJsonNode.getMedia()) {
            this.mediaService.createWithDefinition(createdApiEntity.getId(), media.toString());
        }
        List<PageEntity> search = this.pageService.search(new PageQuery.Builder().api(createdApiEntity.getId()).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build(), environmentId);
        if (search.isEmpty()) {
            this.pageService.createAsideFolder(createdApiEntity.getId(), environmentId);
        }
    }

    private String fetchApiDefinitionContentFromURL(String apiDefinitionOrURL) {
        if (apiDefinitionOrURL.toUpperCase().startsWith("HTTP")) {
            UrlSanitizerUtils.checkAllowed(apiDefinitionOrURL, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
            Buffer buffer = this.httpClientService.request(HttpMethod.GET, apiDefinitionOrURL, null, null, null);
            return buffer.toString();
        }
        return apiDefinitionOrURL;
    }

    private void createOrUpdateApiNestedEntities(String apiId, ImportApiJsonNode apiJsonNode, String organizationId, String environmentId) throws IOException {
        this.createOrUpdateMembers(apiId, apiJsonNode, organizationId, environmentId);
        this.createOrUpdatePages(apiId, apiJsonNode, environmentId);
        this.createOrUpdatePlans(apiId, apiJsonNode, environmentId);
        this.createOrUpdateMetadata(apiId, apiJsonNode);
    }

    private void createOrUpdateMembers(String apiId, ImportApiJsonNode apiJsonNode, String organizationId, String environmentId) throws JsonProcessingException {
        if (apiJsonNode.hasMembers()) {
            Set<MemberToImport> membersAlreadyPresent = this.getAPICurrentMembers(apiId);
            RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, RoleScope.API);
            assert (poRole != null);
            String poRoleId = poRole.getId();
            MemberToImport currentPo = membersAlreadyPresent.stream().filter(memberToImport -> memberToImport.getRoles().contains(poRoleId)).findFirst().orElse(new MemberToImport());
            List<String> roleUsedInTransfert = null;
            MemberToImport futurePo = null;
            for (ImportJsonNode memberNode : apiJsonNode.getMembers()) {
                MemberToImport memberToImport2 = (MemberToImport)this.objectMapper.readValue(memberNode.toString(), MemberToImport.class);
                boolean presentWithSameRole = this.isPresentWithSameRole(membersAlreadyPresent, memberToImport2);
                List<String> roleIdsToImport = this.getRoleIdsToImport(memberToImport2);
                this.addOrUpdateMembers(apiId, organizationId, environmentId, poRoleId, currentPo, memberToImport2, roleIdsToImport, presentWithSameRole);
                if (currentPo.getSourceId().equals(memberToImport2.getSourceId()) && currentPo.getSource().equals(memberToImport2.getSource()) && !roleIdsToImport.contains(poRoleId)) {
                    roleUsedInTransfert = roleIdsToImport;
                }
                if (!roleIdsToImport.contains(poRoleId)) continue;
                futurePo = memberToImport2;
            }
            this.transferOwnership(apiId, organizationId, environmentId, currentPo, roleUsedInTransfert, futurePo);
        }
    }

    @NotNull
    protected Set<MemberToImport> getAPICurrentMembers(String apiId) {
        return this.membershipService.getMembersByReference(MembershipReferenceType.API, apiId).stream().filter(member -> member.getType() == MembershipMemberType.USER).map(member -> {
            UserEntity userEntity = this.userService.findById(member.getId());
            return new MemberToImport(userEntity.getSource(), userEntity.getSourceId(), member.getRoles().stream().map(RoleEntity::getId).collect(Collectors.toList()), null);
        }).collect(Collectors.toSet());
    }

    protected boolean isPresentWithSameRole(Set<MemberToImport> membersAlreadyPresent, MemberToImport memberToImport) {
        return memberToImport.getRoles() != null && !memberToImport.getRoles().isEmpty() && membersAlreadyPresent.stream().anyMatch(m -> {
            m.getRoles().sort(Comparator.naturalOrder());
            return m.getRoles().equals(memberToImport.getRoles()) && m.getSourceId().equals(memberToImport.getSourceId()) && m.getSource().equals(memberToImport.getSource());
        });
    }

    protected List<String> getRoleIdsToImport(MemberToImport memberToImport) {
        List<String> roleIdsToImport = memberToImport.getRoles();
        if (roleIdsToImport == null) {
            roleIdsToImport = new ArrayList<String>();
            memberToImport.setRoles(roleIdsToImport);
        } else {
            roleIdsToImport = new ArrayList<String>(roleIdsToImport);
        }
        String roleNameToAdd = memberToImport.getRole();
        if (roleNameToAdd != null && !roleNameToAdd.isEmpty()) {
            Optional<RoleEntity> optRoleToAddEntity = this.roleService.findByScopeAndName(RoleScope.API, roleNameToAdd);
            if (optRoleToAddEntity.isPresent()) {
                roleIdsToImport.add(optRoleToAddEntity.get().getId());
            } else {
                LOGGER.warn("Role {} does not exist", (Object)roleNameToAdd);
            }
        }
        roleIdsToImport.sort(Comparator.naturalOrder());
        return roleIdsToImport;
    }

    private void addOrUpdateMembers(String apiId, String organizationId, String environmentId, String poRoleId, MemberToImport currentPo, MemberToImport memberToImport, List<String> rolesToImport, boolean presentWithSameRole) {
        if (!(presentWithSameRole || memberToImport.getRoles() == null || memberToImport.getRoles().isEmpty() || memberToImport.getRoles().contains(poRoleId) || memberToImport.getSourceId().equals(currentPo.getSourceId()) && memberToImport.getSource().equals(currentPo.getSource()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(memberToImport.getSource(), memberToImport.getSourceId(), false);
                rolesToImport.forEach(role -> {
                    try {
                        this.membershipService.addRoleToMemberOnReference(organizationId, environmentId, MembershipReferenceType.API, apiId, MembershipMemberType.USER, userEntity.getId(), (String)role);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to add role '{}' to member '{}' on API '{}' due to : {}", new Object[]{role, userEntity.getId(), apiId, e.getMessage()});
                    }
                });
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    private void transferOwnership(String apiId, String organizationId, String environmentId, MemberToImport currentPo, List<String> roleUsedInTransfert, MemberToImport futurePo) {
        if (!(futurePo == null || currentPo.getSource().equals(futurePo.getSource()) && currentPo.getSourceId().equals(futurePo.getSourceId()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(futurePo.getSource(), futurePo.getSourceId(), false);
                List roleEntity = null;
                if (roleUsedInTransfert != null && !roleUsedInTransfert.isEmpty()) {
                    roleEntity = roleUsedInTransfert.stream().map(this.roleService::findById).collect(Collectors.toList());
                }
                this.membershipService.transferApiOwnership(organizationId, environmentId, apiId, new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), roleEntity);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void createOrUpdateMetadata(String apiId, ImportApiJsonNode apiJsonNode) {
        try {
            for (ImportJsonNode metadataNode : apiJsonNode.getMetadata()) {
                UpdateApiMetadataEntity updateApiMetadataEntity = (UpdateApiMetadataEntity)this.objectMapper.readValue(metadataNode.toString(), UpdateApiMetadataEntity.class);
                updateApiMetadataEntity.setApiId(apiId);
                this.apiMetadataService.update(updateApiMetadataEntity);
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while creating API metadata", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while creating API Metadata", ex);
        }
    }

    protected void createOrUpdatePlans(String apiId, ImportApiJsonNode apiJsonNode, String environmentId) throws IOException {
        if (apiJsonNode.hasPlans()) {
            Map<String, PlanEntity> existingPlans = this.planService.findByApi(apiId).stream().collect(Collectors.toMap(PlanEntity::getId, Function.identity()));
            List<PlanEntity> plansToImport = this.readPlansToImportFromDefinition(apiJsonNode, existingPlans);
            this.findRemovedPlansIds(existingPlans.values(), plansToImport).forEach(this.planService::delete);
            plansToImport.forEach(planEntity -> {
                planEntity.setApi(apiId);
                this.planService.createOrUpdatePlan((PlanEntity)planEntity, environmentId);
            });
        }
    }

    protected void createOrUpdatePages(String apiId, ImportApiJsonNode apiJsonNode, String environmentId) throws JsonProcessingException {
        if (apiJsonNode.hasPages() && !apiJsonNode.getPages().isEmpty()) {
            List pagesList = (List)this.objectMapper.readValue(apiJsonNode.getPages().toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PageEntity.class));
            this.pageService.createOrUpdatePages(pagesList, environmentId, apiId);
        }
    }

    private Stream<String> findRemovedPlansIds(Collection<PlanEntity> existingPlans, Collection<PlanEntity> importedPlans) {
        return existingPlans.stream().filter(existingPlan -> !importedPlans.contains(existingPlan)).map(PlanEntity::getId);
    }

    private List<PlanEntity> readPlansToImportFromDefinition(ImportApiJsonNode apiJsonNode, Map<String, PlanEntity> existingPlans) throws IOException {
        ArrayList<PlanEntity> plansToImport = new ArrayList<PlanEntity>();
        for (ImportJsonNodeWithIds planNode : apiJsonNode.getPlans()) {
            PlanEntity existingPlan;
            PlanEntity planEntity = existingPlan = planNode.hasId() ? existingPlans.get(planNode.getId()) : null;
            if (existingPlan != null) {
                plansToImport.add((PlanEntity)this.objectMapper.readerForUpdating((Object)existingPlan).readValue(planNode.getJsonNode()));
                continue;
            }
            plansToImport.add((PlanEntity)this.objectMapper.readValue(planNode.toString(), PlanEntity.class));
        }
        return plansToImport;
    }

    private void checkApiJsonConsistency(ImportApiJsonNode apiJsonNode, String urlApiId, String environmentId) {
        if (urlApiId != null && !urlApiId.equals(apiJsonNode.getId())) {
            throw new ApiImportException(String.format("Can't update API [%s] cause crossId [%s] already belongs to another API in environment [%s]", urlApiId, apiJsonNode.getCrossId(), environmentId));
        }
        this.checkApiJsonConsistency(apiJsonNode);
    }

    private void checkApiJsonConsistency(ImportApiJsonNode apiJsonNode) {
        this.checkPagesConsistency(apiJsonNode);
        this.checkPlansConsistency(apiJsonNode);
    }

    private void checkPlansConsistency(ImportApiJsonNode apiJsonNode) {
        List<String> planIds;
        if (apiJsonNode.hasPlans() && this.planService.anyPlanMismatchWithApi(planIds = apiJsonNode.getPlans().stream().map(ImportJsonNodeWithIds::getId).collect(Collectors.toList()), apiJsonNode.getId())) {
            throw new ApiImportException("Some inconsistencies were found in the API plans definition");
        }
    }

    private void checkPagesConsistency(ImportApiJsonNode apiJsonNode) {
        long systemFoldersCount;
        if (apiJsonNode.hasPages() && (systemFoldersCount = apiJsonNode.getPagesArray().findValuesAsText("type").stream().filter(type -> PageType.SYSTEM_FOLDER.name().equals(type)).count()) > 1L) {
            throw new ApiImportException("Only one system folder is allowed in the API pages definition");
        }
    }

    protected ImportApiJsonNode recalculateApiDefinitionIds(ImportApiJsonNode apiJsonNode, String environmentId) {
        return this.recalculateApiDefinitionIds(apiJsonNode, environmentId, null);
    }

    protected ImportApiJsonNode recalculateApiDefinitionIds(ImportApiJsonNode apiJsonNode, String environmentId, String urlApiId) {
        if (!apiJsonNode.hasId() || !apiJsonNode.getId().equals(urlApiId)) {
            this.findApiByEnvironmentAndCrossId(environmentId, apiJsonNode.getCrossId()).ifPresentOrElse(api -> this.recalculateIdsFromCrossId(apiJsonNode, (ApiEntity)api), () -> this.recalculateIdsFromDefinitionIds(environmentId, apiJsonNode, urlApiId));
        }
        return this.generateEmptyIds(apiJsonNode);
    }

    private Optional<ApiEntity> findApiByEnvironmentAndCrossId(String environmentId, String crossId) {
        return crossId == null ? Optional.empty() : this.apiService.findByEnvironmentIdAndCrossId(environmentId, crossId);
    }

    private void recalculateIdsFromCrossId(ImportApiJsonNode apiJsonNode, ApiEntity api) {
        apiJsonNode.setId(api.getId());
        this.recalculatePlanIdsFromCrossIds(api, apiJsonNode.getPlans());
        this.recalculatePageIdsFromCrossIds(api, apiJsonNode.getPages());
    }

    private void recalculatePlanIdsFromCrossIds(ApiEntity api, List<ImportJsonNodeWithIds> plansNodes) {
        Map plansByCrossId = this.planService.findByApi(api.getId()).stream().filter(plan -> plan.getCrossId() != null).collect(Collectors.toMap(PlanEntity::getCrossId, Function.identity()));
        plansNodes.stream().filter(ImportJsonNodeWithIds::hasCrossId).forEach(plan -> {
            PlanEntity matchingPlan = (PlanEntity)plansByCrossId.get(plan.getCrossId());
            plan.setApi(api.getId());
            plan.setId(matchingPlan != null ? matchingPlan.getId() : UuidString.generateRandom());
        });
    }

    private void recalculatePageIdsFromCrossIds(ApiEntity api, List<ImportJsonNodeWithIds> pagesNodes) {
        Map pagesByCrossId = this.pageService.findByApi(api.getId()).stream().filter(page -> page.getCrossId() != null).collect(Collectors.toMap(PageEntity::getCrossId, Function.identity()));
        pagesNodes.stream().filter(ImportJsonNodeWithIds::hasCrossId).forEach(page -> {
            String pageId = page.hasId() ? page.getId() : null;
            PageEntity matchingPage = (PageEntity)pagesByCrossId.get(page.getCrossId());
            page.setApi(api.getId());
            if (matchingPage != null) {
                page.setId(matchingPage.getId());
                this.updatePagesHierarchy(pagesNodes, pageId, matchingPage.getId());
            } else {
                String newPageId = UuidString.generateRandom();
                page.setId(newPageId);
                this.updatePagesHierarchy(pagesNodes, pageId, newPageId);
            }
        });
    }

    private void recalculateIdsFromDefinitionIds(String environmentId, ImportApiJsonNode apiJsonNode, String urlApiId) {
        String targetApiId = urlApiId == null ? UuidString.generateForEnvironment(environmentId, apiJsonNode.getId()) : urlApiId;
        apiJsonNode.setId(targetApiId);
        this.recalculatePlanIdsFromDefinitionIds(apiJsonNode.getPlans(), environmentId, targetApiId);
        this.recalculatePageIdsFromDefinitionIds(apiJsonNode.getPages(), environmentId, targetApiId);
    }

    private void recalculatePlanIdsFromDefinitionIds(List<ImportJsonNodeWithIds> plansNodes, String environmentId, String apiId) {
        plansNodes.stream().filter(ImportJsonNodeWithIds::hasId).forEach(plan -> {
            plan.setId(UuidString.generateForEnvironment(environmentId, apiId, plan.getId()));
            plan.setApi(apiId);
        });
    }

    private void recalculatePageIdsFromDefinitionIds(List<ImportJsonNodeWithIds> pagesNodes, String environmentId, String apiId) {
        pagesNodes.stream().filter(ImportJsonNodeWithIds::hasId).forEach(page -> {
            String pageId = page.getId();
            String generatedPageId = UuidString.generateForEnvironment(environmentId, apiId, pageId);
            page.setId(generatedPageId);
            page.setApi(apiId);
            this.updatePagesHierarchy(pagesNodes, pageId, generatedPageId);
        });
    }

    private void updatePagesHierarchy(List<ImportJsonNodeWithIds> pagesNodes, String parentId, String newParentId) {
        pagesNodes.stream().filter(child -> this.isChildPageOf((ImportJsonNodeWithIds)child, parentId)).forEach(child -> child.setParentId(newParentId));
    }

    private boolean isChildPageOf(ImportJsonNodeWithIds pageNode, String parentPageId) {
        return pageNode.hasParentId() && pageNode.getParentId().equals(parentPageId);
    }

    private ImportApiJsonNode generateEmptyIds(ImportApiJsonNode apiJsonNode) {
        Stream.concat(apiJsonNode.getPlans().stream(), apiJsonNode.getPages().stream()).filter(node -> !node.hasId()).forEach(node -> node.setId(UuidString.generateRandom()));
        return apiJsonNode;
    }

    protected static class MemberToImport {
        private String source;
        private String sourceId;
        private List<String> roles;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, List<String> roles, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.roles = roles;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }
}

