/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.NewEventEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.EventNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventServiceImpl
extends TransactionalService
implements EventService {
    private final Logger LOGGER = LoggerFactory.getLogger(EventServiceImpl.class);
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private UserService userService;

    @Override
    public EventEntity findById(String id) {
        try {
            this.LOGGER.debug("Find event by ID: {}", (Object)id);
            Optional event = this.eventRepository.findById((Object)id);
            if (event.isPresent()) {
                return this.convert((Event)event.get());
            }
            throw new EventNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an event using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an event using its ID " + id, ex);
        }
    }

    @Override
    public EventEntity create(Set<String> environmentsIds, NewEventEntity newEventEntity) {
        String hostAddress = "";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
            this.LOGGER.debug("Create {} for server {}", (Object)newEventEntity, (Object)hostAddress);
            Event event = this.convert(newEventEntity);
            event.setId(UuidString.generateRandom());
            event.setEnvironments(environmentsIds);
            event.getProperties().put(Event.EventProperties.ORIGIN.getValue(), hostAddress);
            event.setCreatedAt(new Date());
            event.setUpdatedAt(event.getCreatedAt());
            Event createdEvent = (Event)this.eventRepository.create((Object)event);
            return this.convert(createdEvent);
        }
        catch (UnknownHostException e) {
            this.LOGGER.error("An error occurs while getting the server IP address", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while getting the server IP address", e);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for server {}", new Object[]{newEventEntity, hostAddress, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + newEventEntity + " for server " + hostAddress, ex);
        }
    }

    @Override
    public EventEntity create(Set<String> environmentsIds, io.gravitee.rest.api.model.EventType type, String payload, Map<String, String> properties) {
        NewEventEntity event = new NewEventEntity();
        event.setType(type);
        event.setPayload(payload);
        event.setProperties(properties);
        return this.create(environmentsIds, event);
    }

    @Override
    public void delete(String eventId) {
        try {
            this.LOGGER.debug("Delete Event {}", (Object)eventId);
            this.eventRepository.delete((Object)eventId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete Event {}", (Object)eventId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Event " + eventId, ex);
        }
    }

    @Override
    public Page<EventEntity> search(List<io.gravitee.rest.api.model.EventType> eventTypes, Map<String, Object> properties, long from, long to, int page, int size, List<String> environmentsIds) {
        EventCriteria.Builder builder = new EventCriteria.Builder().from(from).to(to);
        if (eventTypes != null) {
            EventType[] eventTypesArr = (EventType[])eventTypes.stream().map(eventType -> EventType.valueOf((String)eventType.toString())).toArray(EventType[]::new);
            builder.types(eventTypesArr);
        }
        if (properties != null) {
            properties.forEach((arg_0, arg_1) -> ((EventCriteria.Builder)builder).property(arg_0, arg_1));
        }
        builder.environments(environmentsIds);
        Page pageEvent = this.eventRepository.search(builder.build(), new PageableBuilder().pageNumber(page).pageSize(size).build());
        List content = pageEvent.getContent().stream().map(this::convert).collect(Collectors.toList());
        return new Page(content, pageEvent.getPageNumber(), (int)pageEvent.getPageElements(), pageEvent.getTotalElements());
    }

    @Override
    public <T> Page<T> search(List<io.gravitee.rest.api.model.EventType> eventTypes, Map<String, Object> properties, long from, long to, int page, int size, Function<EventEntity, T> mapper, List<String> environmentsIds) {
        return this.search(eventTypes, properties, from, to, page, size, mapper, t -> true, environmentsIds);
    }

    @Override
    public <T> Page<T> search(List<io.gravitee.rest.api.model.EventType> eventTypes, Map<String, Object> properties, long from, long to, int page, int size, Function<EventEntity, T> mapper, Predicate<T> filter, List<String> environmentsIds) {
        Page<EventEntity> result = this.search(eventTypes, properties, from, to, page, size, environmentsIds);
        return new Page(result.getContent().stream().map(mapper).filter(filter).collect(Collectors.toList()), page, size, result.getTotalElements());
    }

    @Override
    public Collection<EventEntity> search(EventQuery query) {
        this.LOGGER.debug("Search APIs by {}", (Object)query);
        return this.convert(this.eventRepository.search(this.queryToCriteria(query).build()));
    }

    private EventCriteria.Builder queryToCriteria(EventQuery query) {
        EventCriteria.Builder builder = new EventCriteria.Builder().environments(Collections.singletonList(GraviteeContext.getCurrentEnvironment()));
        if (query == null) {
            return builder;
        }
        builder.from(query.getFrom()).to(query.getTo());
        if (!CollectionUtils.isEmpty((Collection)query.getTypes())) {
            query.getTypes().forEach(eventType -> builder.types(new EventType[]{EventType.valueOf((String)eventType.name())}));
        }
        if (!CollectionUtils.isEmpty((Map)query.getProperties())) {
            query.getProperties().forEach((arg_0, arg_1) -> ((EventCriteria.Builder)builder).property(arg_0, arg_1));
        }
        if (!StringUtils.isBlank((CharSequence)query.getApi())) {
            builder.property(Event.EventProperties.API_ID.getValue(), (Object)query.getApi());
        }
        if (!StringUtils.isBlank((CharSequence)query.getId())) {
            builder.property(Event.EventProperties.ID.getValue(), (Object)query.getId());
        }
        return builder;
    }

    private Set<EventEntity> convert(List<Event> events) {
        return events.stream().map(this::convert).collect(Collectors.toSet());
    }

    private EventEntity convert(Event event) {
        String userId;
        EventEntity eventEntity = new EventEntity();
        eventEntity.setId(event.getId());
        eventEntity.setType(io.gravitee.rest.api.model.EventType.valueOf((String)event.getType().toString()));
        eventEntity.setPayload(event.getPayload());
        eventEntity.setParentId(event.getParentId());
        eventEntity.setProperties(event.getProperties());
        eventEntity.setCreatedAt(event.getCreatedAt());
        eventEntity.setUpdatedAt(event.getUpdatedAt());
        eventEntity.setEnvironments(event.getEnvironments());
        if (event.getProperties() != null && (userId = (String)event.getProperties().get(Event.EventProperties.USER.getValue())) != null && !userId.isEmpty()) {
            try {
                eventEntity.setUser(this.userService.findById(userId));
            }
            catch (UserNotFoundException unfe) {
                UserEntity user = new UserEntity();
                user.setSource("system");
                user.setId(userId);
                eventEntity.setUser(user);
            }
        }
        return eventEntity;
    }

    private Event convert(NewEventEntity newEventEntity) {
        Event event = new Event();
        event.setType(EventType.valueOf((String)newEventEntity.getType().toString()));
        event.setPayload(newEventEntity.getPayload());
        event.setParentId(newEventEntity.getParentId());
        event.setProperties(new HashMap(newEventEntity.getProperties()));
        return event;
    }
}

