/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.DuplicateApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.PageImportException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiDuplicatorServiceImpl
extends AbstractService
implements ApiDuplicatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDuplicatorServiceImpl.class);
    public static final String API_DEFINITION_FIELD_GROUPS = "groups";
    public static final String API_DEFINITION_FIELD_PLANS = "plans";
    public static final String API_DEFINITION_FIELD_MEMBERS = "members";
    public static final String API_DEFINITION_FIELD_PAGES = "pages";
    public static final String API_DEFINITION_FIELD_VIEWS = "views";
    public static final String API_DEFINITION_FIELD_METADATA = "metadata";
    private final HttpClientService httpClientService;
    private final ImportConfiguration importConfiguration;
    private final MediaService mediaService;
    private final ObjectMapper objectMapper;
    private final ApiMetadataService apiMetadataService;
    private final MembershipService membershipService;
    private final RoleService roleService;
    private final PageService pageService;
    private final PlanService planService;
    private final GroupService groupService;
    private final UserService userService;
    private final ApiService apiService;

    public ApiDuplicatorServiceImpl(HttpClientService httpClientService, ImportConfiguration importConfiguration, MediaService mediaService, ObjectMapper objectMapper, ApiMetadataService apiMetadataService, MembershipService membershipService, RoleService roleService, PageService pageService, PlanService planService, GroupService groupService, UserService userService, ApiService apiService) {
        this.httpClientService = httpClientService;
        this.importConfiguration = importConfiguration;
        this.mediaService = mediaService;
        this.objectMapper = objectMapper;
        this.apiMetadataService = apiMetadataService;
        this.membershipService = membershipService;
        this.roleService = roleService;
        this.pageService = pageService;
        this.planService = planService;
        this.groupService = groupService;
        this.userService = userService;
        this.apiService = apiService;
    }

    @Override
    public ApiEntity createWithImportedDefinition(String apiDefinitionOrURL, String userId, String organizationId, String environmentId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            JsonNode jsonNode = this.objectMapper.readTree(apiDefinition);
            if (!jsonNode.hasNonNull("id")) {
                ((ObjectNode)jsonNode).put("id", UuidString.generateRandom());
            }
            apiDefinition = this.preprocessApiDefinitionUpdatingIds(jsonNode, environmentId);
            if (jsonNode.has(API_DEFINITION_FIELD_PAGES) && jsonNode.get(API_DEFINITION_FIELD_PAGES).isArray()) {
                ArrayNode pagesDefinition = (ArrayNode)jsonNode.get(API_DEFINITION_FIELD_PAGES);
                this.checkPagesConsistency(pagesDefinition);
            }
            UpdateApiEntity importedApi = this.convertToEntity(apiDefinition, jsonNode, environmentId);
            ApiEntity createdApiEntity = this.apiService.createWithApiDefinition(importedApi, userId, jsonNode);
            this.createMediaAndSystemFolder(createdApiEntity, jsonNode, environmentId);
            this.updateApiReferences(createdApiEntity.getId(), jsonNode, organizationId, environmentId, false);
            return createdApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity duplicate(ApiEntity apiEntity, DuplicateApiEntity duplicateApiEntity, String organizationId, String environmentId) {
        Objects.requireNonNull(apiEntity, "Missing ApiEntity");
        String apiId = apiEntity.getId();
        LOGGER.debug("Duplicate API {}", (Object)apiId);
        UpdateApiEntity newApiEntity = ApiService.convert(apiEntity);
        Proxy proxy = apiEntity.getProxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(duplicateApiEntity.getContextPath())));
        newApiEntity.setProxy(proxy);
        newApiEntity.setVersion(duplicateApiEntity.getVersion() == null ? apiEntity.getVersion() : duplicateApiEntity.getVersion());
        if (duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_GROUPS)) {
            newApiEntity.setGroups(null);
        } else {
            newApiEntity.setGroups(apiEntity.getGroups());
        }
        HashMap plansIdsMap = new HashMap();
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            newApiEntity.getPlans().forEach(plan -> {
                String newPlanId = UuidString.generateRandom();
                plansIdsMap.put(plan.getId(), newPlanId);
                plan.setId(newPlanId);
            });
        }
        ApiEntity duplicatedApi = this.apiService.createWithApiDefinition(newApiEntity, this.getAuthenticatedUsername(), null);
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_MEMBERS)) {
            Set<MembershipEntity> membershipsToDuplicate = this.membershipService.getMembershipsByReference(MembershipReferenceType.API, apiId);
            RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, RoleScope.API);
            if (primaryOwnerRole != null) {
                String primaryOwnerRoleId = primaryOwnerRole.getId();
                membershipsToDuplicate.forEach(membership -> {
                    String roleId = membership.getRoleId();
                    if (!primaryOwnerRoleId.equals(roleId)) {
                        this.membershipService.addRoleToMemberOnReference(organizationId, environmentId, MembershipReferenceType.API, duplicatedApi.getId(), membership.getMemberType(), membership.getMemberId(), roleId);
                    }
                });
            }
        }
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PAGES)) {
            List<PageEntity> pages = this.pageService.search(new PageQuery.Builder().api(apiId).build(), true, environmentId);
            this.pageService.duplicatePages(pages, environmentId, duplicatedApi.getId());
        }
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            this.planService.findByApi(apiId).forEach(plan -> {
                plan.setId((String)plansIdsMap.get(plan.getId()));
                plan.setApi(duplicatedApi.getId());
                this.planService.create(NewPlanEntity.from((PlanEntity)plan));
            });
        }
        return duplicatedApi;
    }

    @Override
    public String exportAsJson(String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.apiService.findById(apiId);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        try {
            return this.objectMapper.writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public ApiEntity updateWithImportedDefinition(String apiId, String apiDefinitionOrURL, String userId, String organizationId, String environmentId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            JsonNode jsonNode = this.objectMapper.readTree(apiDefinition);
            if (!jsonNode.has("id") || !apiId.equals(jsonNode.get("id").asText())) {
                ((ObjectNode)jsonNode).put("id", apiId);
                apiDefinition = this.preprocessApiDefinitionUpdatingIds(jsonNode, environmentId);
            }
            if (jsonNode.has(API_DEFINITION_FIELD_PAGES) && jsonNode.get(API_DEFINITION_FIELD_PAGES).isArray()) {
                ArrayNode pagesDefinition = (ArrayNode)jsonNode.get(API_DEFINITION_FIELD_PAGES);
                this.checkPagesConsistency(pagesDefinition);
            }
            if (jsonNode.has(API_DEFINITION_FIELD_PLANS) && jsonNode.get(API_DEFINITION_FIELD_PLANS).isArray()) {
                ArrayNode plansDefinition = (ArrayNode)jsonNode.get(API_DEFINITION_FIELD_PLANS);
                this.checkPlansDefinitionOwnership(plansDefinition, apiId);
            }
            UpdateApiEntity importedApi = this.convertToEntity(apiDefinition, jsonNode, environmentId);
            ApiEntity updatedApiEntity = this.apiService.update(apiId, importedApi, false);
            this.updateApiReferences(apiId, jsonNode, organizationId, environmentId, true);
            return updatedApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    private UpdateApiEntity convertToEntity(String apiDefinition, JsonNode jsonNode, String environmentId) throws JsonProcessingException {
        JsonNode viewsDefinition;
        UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(apiDefinition, UpdateApiEntity.class);
        if (Objects.equals(importedApi.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (importedApi.getPaths() == null || importedApi.getPaths().isEmpty())) {
            importedApi.setPaths(Collections.singletonMap("/", new ArrayList()));
        }
        if (importedApi.getGroups() != null) {
            HashSet groupNames = new HashSet(importedApi.getGroups());
            importedApi.getGroups().clear();
            for (String name : groupNames) {
                GroupEntity group;
                List<GroupEntity> groupEntities = this.groupService.findByName(environmentId, name);
                if (groupEntities.isEmpty()) {
                    NewGroupEntity newGroupEntity = new NewGroupEntity();
                    newGroupEntity.setName(name);
                    group = this.groupService.create(environmentId, newGroupEntity);
                } else {
                    group = groupEntities.get(0);
                }
                importedApi.getGroups().add(group.getId());
            }
        }
        if ((viewsDefinition = jsonNode.path(API_DEFINITION_FIELD_VIEWS)) != null && viewsDefinition.isArray()) {
            HashSet<String> categories = new HashSet<String>();
            for (JsonNode viewNode : viewsDefinition) {
                categories.add(viewNode.asText());
            }
            importedApi.setCategories(categories);
        }
        return importedApi;
    }

    private void createMediaAndSystemFolder(ApiEntity createdApiEntity, JsonNode jsonNode, String environmentId) throws JsonProcessingException {
        List<PageEntity> search;
        JsonNode apiMedia = jsonNode.path("apiMedia");
        if (apiMedia != null && apiMedia.isArray()) {
            for (JsonNode media : apiMedia) {
                this.mediaService.createWithDefinition(createdApiEntity.getId(), media.toString());
            }
        }
        if ((search = this.pageService.search(new PageQuery.Builder().api(createdApiEntity.getId()).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build(), environmentId)).isEmpty()) {
            this.pageService.createAsideFolder(createdApiEntity.getId(), environmentId);
        }
    }

    private String fetchApiDefinitionContentFromURL(String apiDefinitionOrURL) {
        if (apiDefinitionOrURL.toUpperCase().startsWith("HTTP")) {
            UrlSanitizerUtils.checkAllowed(apiDefinitionOrURL, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
            Buffer buffer = this.httpClientService.request(HttpMethod.GET, apiDefinitionOrURL, null, null, null);
            return buffer.toString();
        }
        return apiDefinitionOrURL;
    }

    private void updateApiReferences(String apiId, JsonNode jsonNode, String organizationId, String environmentId, boolean isUpdate) throws IOException {
        this.updateMembers(apiId, jsonNode, organizationId, environmentId);
        this.updatePages(apiId, jsonNode, environmentId);
        this.updatePlans(apiId, jsonNode, environmentId, isUpdate);
        this.updateMetadata(apiId, jsonNode);
    }

    private void updateMembers(String apiId, JsonNode jsonNode, String organizationId, String environmentId) throws JsonProcessingException {
        JsonNode membersToImport = jsonNode.path(API_DEFINITION_FIELD_MEMBERS);
        if (membersToImport != null && membersToImport.isArray() && membersToImport.size() > 0) {
            Set<MemberToImport> membersAlreadyPresent = this.getAPICurrentMembers(apiId);
            RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, RoleScope.API);
            assert (poRole != null);
            String poRoleId = poRole.getId();
            MemberToImport currentPo = membersAlreadyPresent.stream().filter(memberToImport -> memberToImport.getRoles().contains(poRoleId)).findFirst().orElse(new MemberToImport());
            List<String> roleUsedInTransfert = null;
            MemberToImport futurePo = null;
            for (JsonNode memberNode : membersToImport) {
                MemberToImport memberToImport2 = (MemberToImport)this.objectMapper.readValue(memberNode.toString(), MemberToImport.class);
                boolean presentWithSameRole = this.isPresentWithSameRole(membersAlreadyPresent, memberToImport2);
                List<String> rolesToImport = this.getRolesToImport(memberToImport2);
                this.addOrUpdateMembers(apiId, organizationId, environmentId, poRoleId, currentPo, memberToImport2, rolesToImport, presentWithSameRole);
                if (currentPo.getSourceId().equals(memberToImport2.getSourceId()) && currentPo.getSource().equals(memberToImport2.getSource()) && !rolesToImport.contains(poRoleId)) {
                    roleUsedInTransfert = rolesToImport;
                }
                if (!rolesToImport.contains(poRoleId)) continue;
                futurePo = memberToImport2;
            }
            this.transferOwnership(apiId, organizationId, environmentId, currentPo, roleUsedInTransfert, futurePo);
        }
    }

    protected boolean isPresentWithSameRole(Set<MemberToImport> membersAlreadyPresent, MemberToImport memberToImport) {
        return memberToImport.getRoles() != null && !memberToImport.getRoles().isEmpty() && membersAlreadyPresent.stream().anyMatch(m -> {
            m.getRoles().sort(Comparator.naturalOrder());
            return m.getRoles().equals(memberToImport.getRoles()) && m.getSourceId().equals(memberToImport.getSourceId()) && m.getSource().equals(memberToImport.getSource());
        });
    }

    protected List<String> getRolesToImport(MemberToImport memberToImport) {
        List<String> rolesToImport = memberToImport.getRoles();
        if (rolesToImport == null) {
            rolesToImport = new ArrayList<String>();
            memberToImport.setRoles(rolesToImport);
        } else {
            rolesToImport = new ArrayList<String>(rolesToImport);
        }
        String roleToAdd = memberToImport.getRole();
        if (roleToAdd != null && !roleToAdd.isEmpty()) {
            rolesToImport.add(roleToAdd);
        }
        return rolesToImport.stream().map(role -> {
            Optional<RoleEntity> optRoleToAddEntity = this.roleService.findByScopeAndName(RoleScope.API, (String)role);
            if (optRoleToAddEntity.isPresent()) {
                return role;
            }
            LOGGER.warn("Role {} does not exist", (Object)roleToAdd);
            return null;
        }).filter(Objects::nonNull).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private void addOrUpdateMembers(String apiId, String organizationId, String environmentId, String poRoleId, MemberToImport currentPo, MemberToImport memberToImport, List<String> rolesToImport, boolean presentWithSameRole) {
        if (!(presentWithSameRole || memberToImport.getRoles() == null || memberToImport.getRoles().isEmpty() || memberToImport.getRoles().contains(poRoleId) || memberToImport.getSourceId().equals(currentPo.getSourceId()) && memberToImport.getSource().equals(currentPo.getSource()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(memberToImport.getSource(), memberToImport.getSourceId(), false);
                rolesToImport.forEach(role -> {
                    try {
                        this.membershipService.addRoleToMemberOnReference(organizationId, environmentId, MembershipReferenceType.API, apiId, MembershipMemberType.USER, userEntity.getId(), (String)role);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to add role '{}' to member '{}' on API '{}' due to : {}", new Object[]{role, userEntity.getId(), apiId, e.getMessage()});
                    }
                });
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    private void transferOwnership(String apiId, String organizationId, String environmentId, MemberToImport currentPo, List<String> roleUsedInTransfert, MemberToImport futurePo) {
        if (!(futurePo == null || currentPo.getSource().equals(futurePo.getSource()) && currentPo.getSourceId().equals(futurePo.getSourceId()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(futurePo.getSource(), futurePo.getSourceId(), false);
                List roleEntity = null;
                if (roleUsedInTransfert != null && !roleUsedInTransfert.isEmpty()) {
                    roleEntity = roleUsedInTransfert.stream().map(this.roleService::findById).collect(Collectors.toList());
                }
                this.membershipService.transferApiOwnership(organizationId, environmentId, apiId, new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), roleEntity);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    protected Set<MemberToImport> getAPICurrentMembers(String apiId) {
        return this.membershipService.getMembersByReference(MembershipReferenceType.API, apiId).stream().filter(member -> member.getType() == MembershipMemberType.USER).map(member -> {
            UserEntity userEntity = this.userService.findById(member.getId());
            return new MemberToImport(userEntity.getSource(), userEntity.getSourceId(), member.getRoles().stream().map(RoleEntity::getId).collect(Collectors.toList()), null);
        }).collect(Collectors.toSet());
    }

    protected void updatePages(String apiId, JsonNode jsonNode, String environmentId) throws JsonProcessingException {
        JsonNode pagesDefinition = jsonNode.path(API_DEFINITION_FIELD_PAGES);
        if (pagesDefinition != null && pagesDefinition.isArray() && pagesDefinition.size() > 0) {
            List pagesList = (List)this.objectMapper.readValue(pagesDefinition.toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PageEntity.class));
            this.pageService.createOrUpdatePages(pagesList, environmentId, apiId);
        }
    }

    protected void updatePlans(String apiId, JsonNode jsonNode, String environmentId, boolean isUpdate) throws IOException {
        JsonNode plansDefinition = jsonNode.path(API_DEFINITION_FIELD_PLANS);
        if (plansDefinition != null && plansDefinition.isArray() && plansDefinition.size() > 0) {
            Map<String, PlanEntity> existingPlans = isUpdate ? this.planService.findByApi(apiId).stream().collect(Collectors.toMap(PlanEntity::getId, plan -> plan)) : Collections.emptyMap();
            List<PlanEntity> plansToImport = this.readPlansToImportFromDefinition(plansDefinition, existingPlans);
            this.findRemovedPlansIds(existingPlans.values(), plansToImport).forEach(this.planService::delete);
            plansToImport.forEach(planEntity -> {
                planEntity.setApi(apiId);
                this.planService.createOrUpdatePlan((PlanEntity)planEntity, environmentId);
            });
        }
    }

    protected void updateMetadata(String apiId, JsonNode jsonNode) {
        JsonNode metadataDefinition = jsonNode.path(API_DEFINITION_FIELD_METADATA);
        if (metadataDefinition != null && metadataDefinition.isArray()) {
            try {
                for (JsonNode metadataNode : metadataDefinition) {
                    UpdateApiMetadataEntity updateApiMetadataEntity = (UpdateApiMetadataEntity)this.objectMapper.readValue(metadataNode.toString(), UpdateApiMetadataEntity.class);
                    updateApiMetadataEntity.setApiId(apiId);
                    this.apiMetadataService.update(updateApiMetadataEntity);
                }
            }
            catch (Exception ex) {
                LOGGER.error("An error occurs while creating API metadata", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while creating API Metadata", ex);
            }
        }
    }

    protected String preprocessApiDefinitionUpdatingIds(JsonNode apiJsonNode, String environmentId) {
        JsonNode pagesDefinition;
        JsonNode plansDefinition = apiJsonNode.path(API_DEFINITION_FIELD_PLANS);
        if (plansDefinition != null && plansDefinition.isArray()) {
            plansDefinition.forEach(planJsonNode -> this.regeneratePlanId(apiJsonNode, (JsonNode)planJsonNode, environmentId));
        }
        if ((pagesDefinition = apiJsonNode.path(API_DEFINITION_FIELD_PAGES)) != null && pagesDefinition.isArray()) {
            this.regeneratePageIds(apiJsonNode, (ArrayNode)pagesDefinition, environmentId);
        }
        return apiJsonNode.toString();
    }

    private void regeneratePlanId(JsonNode apiJsonNode, JsonNode planJsonNode, String environmentId) {
        String apiId = apiJsonNode.has("id") ? apiJsonNode.get("id").asText() : null;
        String planId = planJsonNode.has("id") ? planJsonNode.get("id").asText() : null;
        ((ObjectNode)planJsonNode).put("id", UuidString.generateForEnvironment(environmentId, apiId, planId));
    }

    private void regeneratePageIds(JsonNode apiJsonNode, ArrayNode pagesNode, String environmentId) {
        String apiId = apiJsonNode.hasNonNull("id") ? apiJsonNode.get("id").asText() : null;
        pagesNode.forEach(pageNode -> {
            String pageId = pageNode.hasNonNull("id") ? pageNode.get("id").asText() : null;
            String newPageId = UuidString.generateForEnvironment(environmentId, apiId, pageId);
            ((ObjectNode)pageNode).put("id", newPageId);
            pagesNode.forEach(childNode -> {
                if (childNode.hasNonNull("parentId") && childNode.get("parentId").asText().equals(pageId)) {
                    ((ObjectNode)childNode).put("parentId", newPageId);
                }
            });
        });
    }

    private Stream<String> findRemovedPlansIds(Collection<PlanEntity> existingPlans, Collection<PlanEntity> importedPlans) {
        return existingPlans.stream().filter(existingPlan -> !importedPlans.contains(existingPlan)).map(PlanEntity::getId);
    }

    private List<PlanEntity> readPlansToImportFromDefinition(JsonNode plansDefinition, Map<String, PlanEntity> existingPlans) throws IOException {
        ArrayList<PlanEntity> plansToImport = new ArrayList<PlanEntity>();
        Iterator it = plansDefinition.elements();
        while (it.hasNext()) {
            PlanEntity existingPlan;
            JsonNode planDefinition = (JsonNode)it.next();
            PlanEntity planEntity = existingPlan = planDefinition.has("id") ? existingPlans.get(planDefinition.get("id").asText()) : null;
            if (existingPlan != null) {
                plansToImport.add((PlanEntity)this.objectMapper.readerForUpdating((Object)existingPlan).readValue(planDefinition));
                continue;
            }
            plansToImport.add((PlanEntity)this.objectMapper.readValue(planDefinition.toString(), PlanEntity.class));
        }
        return plansToImport;
    }

    private void checkPlansDefinitionOwnership(ArrayNode plansDefinition, String apiId) {
        List planIds = plansDefinition.findValuesAsText("id");
        if (this.planService.anyPlanMismatchWithApi(planIds, apiId)) {
            throw new TechnicalManagementException("Some inconsistencies were found in the API plans definition");
        }
    }

    private void checkPagesConsistency(ArrayNode pagesDefinition) {
        long systemFoldersCount = pagesDefinition.findValuesAsText("type").stream().filter(type -> PageType.SYSTEM_FOLDER.name().equals(type)).count();
        if (systemFoldersCount > 1L) {
            throw new PageImportException("Only one system folder is allowed in the API pages definition");
        }
    }

    protected static class MemberToImport {
        private String source;
        private String sourceId;
        private List<String> roles;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, List<String> roles, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.roles = roles;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }
}

