/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.alert.api.condition.StringCondition;
import io.gravitee.alert.api.trigger.Trigger;
import io.gravitee.alert.api.trigger.TriggerProvider;
import io.gravitee.alert.api.trigger.command.AlertNotificationCommand;
import io.gravitee.alert.api.trigger.command.Command;
import io.gravitee.alert.api.trigger.command.Handler;
import io.gravitee.alert.api.trigger.command.ResolvePropertyCommand;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.utils.UUID;
import io.gravitee.notifier.api.Notification;
import io.gravitee.plugin.alert.AlertTriggerProviderManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AlertEventRepository;
import io.gravitee.repository.management.api.AlertTriggerRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.AlertEventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.AlertEvent;
import io.gravitee.repository.management.model.AlertEventRule;
import io.gravitee.repository.management.model.AlertEventType;
import io.gravitee.repository.management.model.AlertTrigger;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.AlertEventQuery;
import io.gravitee.rest.api.model.AlertEventRuleEntity;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.alert.AlertEventEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntityWrapper;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.AlertNotFoundException;
import io.gravitee.rest.api.service.exceptions.AlertTemplateInvalidException;
import io.gravitee.rest.api.service.exceptions.AlertUnavailableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.impl.alert.EmailNotifierConfiguration;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class AlertServiceImpl
extends TransactionalService
implements AlertService,
InitializingBean {
    private final Logger LOGGER = LoggerFactory.getLogger(AlertServiceImpl.class);
    private static final String UNKNOWN_SERVICE = "1";
    private static final String FIELD_API = "api";
    private static final String FIELD_APPLICATION = "application";
    private static final String FIELD_TENANT = "tenant";
    private static final String FIELD_PLAN = "plan";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_VERSION = "version";
    private static final String METADATA_UNKNOWN_API_NAME = "Unknown API (not found)";
    private static final String METADATA_UNKNOWN_APPLICATION_NAME = "Unknown application (keyless)";
    private static final String METADATA_DELETED_API_NAME = "Deleted API";
    private static final String METADATA_DELETED_APPLICATION_NAME = "Deleted application";
    private static final String METADATA_DELETED_TENANT_NAME = "Deleted tenant";
    private static final String METADATA_DELETED_PLAN_NAME = "Deleted plan";
    private final String subject;
    private final String host;
    private final String port;
    private final String username;
    private final String password;
    private final Set<String> authMethods;
    private final boolean startTLSEnabled;
    private final boolean sslTrustAll;
    private final String sslKeyStore;
    private final String sslKeyStorePassword;
    private final ConfigurableEnvironment environment;
    private final ObjectMapper mapper;
    private final AlertTriggerRepository alertTriggerRepository;
    private final ApiService apiService;
    private final ApplicationService applicationService;
    private final PlanService planService;
    private final AlertEventRepository alertEventRepository;
    private final TriggerProvider triggerProvider;
    private final AlertTriggerProviderManager triggerProviderManager;
    private final ParameterService parameterService;
    private final ApiRepository apiRepository;
    private final ApiMetadataService apiMetadataService;

    @Autowired
    public AlertServiceImpl(@Value(value="${notifiers.email.subject:[Gravitee.io] %s}") String subject, @Value(value="${notifiers.email.host:#{null}}") String host, @Value(value="${notifiers.email.port}") String port, @Value(value="${notifiers.email.username:#{null}}") String username, @Value(value="${notifiers.email.password:#{null}}") String password, @Value(value="${notifiers.email.authMethods:#{null}}") String[] authMethods, @Value(value="${notifiers.email.starttls.enabled:false}") boolean startTLSEnabled, @Value(value="${notifiers.email.ssl.trustAll:false}") boolean sslTrustAll, @Value(value="${notifiers.email.ssl.keyStore:#{null}}") String sslKeyStore, @Value(value="${notifiers.email.ssl.keyStorePassword:#{null}}") String sslKeyStorePassword, ConfigurableEnvironment environment, ObjectMapper mapper, AlertTriggerRepository alertTriggerRepository, ApiService apiService, ApplicationService applicationService, PlanService planService, AlertEventRepository alertEventRepository, TriggerProvider triggerProvider, AlertTriggerProviderManager triggerProviderManager, ParameterService parameterService, ApiRepository apiRepository, ApiMetadataService apiMetadataService) {
        this.subject = subject;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.authMethods = Optional.ofNullable(authMethods).map(Set::of).orElse(null);
        this.startTLSEnabled = startTLSEnabled;
        this.sslTrustAll = sslTrustAll;
        this.sslKeyStore = sslKeyStore;
        this.sslKeyStorePassword = sslKeyStorePassword;
        this.environment = environment;
        this.mapper = mapper;
        this.alertTriggerRepository = alertTriggerRepository;
        this.apiService = apiService;
        this.applicationService = applicationService;
        this.planService = planService;
        this.alertEventRepository = alertEventRepository;
        this.triggerProvider = triggerProvider;
        this.triggerProviderManager = triggerProviderManager;
        this.parameterService = parameterService;
        this.apiRepository = apiRepository;
        this.apiMetadataService = apiMetadataService;
    }

    @Override
    public AlertStatusEntity getStatus() {
        AlertStatusEntity status = new AlertStatusEntity();
        status.setEnabled(this.parameterService.findAsBoolean(Key.ALERT_ENABLED, ParameterReferenceType.ORGANIZATION));
        status.setPlugins(this.triggerProviderManager.findAll().size());
        return status;
    }

    @Override
    public AlertTriggerEntity create(NewAlertTriggerEntity newAlertTrigger) {
        this.checkAlert();
        try {
            AlertTrigger alertTrigger = this.convert(newAlertTrigger);
            alertTrigger.setCreatedAt(new Date());
            alertTrigger.setUpdatedAt(alertTrigger.getCreatedAt());
            return this.create0(alertTrigger);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create an alert " + newAlertTrigger;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private AlertTriggerEntity create0(AlertTrigger alertTrigger) throws TechnicalException {
        AlertTrigger createdAlert = (AlertTrigger)this.alertTriggerRepository.create((Object)alertTrigger);
        AlertTriggerEntity alertTriggerEntity = this.convert(createdAlert);
        this.enhance(alertTriggerEntity, alertTriggerEntity.getReferenceType(), alertTriggerEntity.getReferenceId());
        if (!alertTriggerEntity.isTemplate()) {
            this.triggerOrCancelAlert((Trigger)alertTriggerEntity);
        }
        return alertTriggerEntity;
    }

    @Override
    public AlertTriggerEntity update(UpdateAlertTriggerEntity updateAlertTrigger) {
        this.checkAlert();
        try {
            Optional alertOptional = this.alertTriggerRepository.findById((Object)updateAlertTrigger.getId());
            if (alertOptional.isPresent()) {
                AlertTrigger alertToUpdate = (AlertTrigger)alertOptional.get();
                if (!alertToUpdate.getReferenceId().equals(updateAlertTrigger.getReferenceId())) {
                    throw new AlertNotFoundException(updateAlertTrigger.getId());
                }
                AlertTrigger trigger = this.convert(updateAlertTrigger);
                trigger.setId(updateAlertTrigger.getId());
                trigger.setReferenceId(((AlertTrigger)alertOptional.get()).getReferenceId());
                trigger.setReferenceType(((AlertTrigger)alertOptional.get()).getReferenceType());
                trigger.setCreatedAt(((AlertTrigger)alertOptional.get()).getCreatedAt());
                trigger.setType(((AlertTrigger)alertOptional.get()).getType());
                trigger.setUpdatedAt(new Date());
                AlertTriggerEntity alertTriggerEntity = this.convert((AlertTrigger)this.alertTriggerRepository.update((Object)trigger));
                this.enhance(alertTriggerEntity, updateAlertTrigger.getReferenceType(), updateAlertTrigger.getReferenceId());
                if (!alertTriggerEntity.isTemplate()) {
                    this.triggerOrCancelAlert((Trigger)alertTriggerEntity);
                }
                return alertTriggerEntity;
            }
            throw new AlertNotFoundException(updateAlertTrigger.getId());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to update an alert " + updateAlertTrigger;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public AlertTriggerEntity findById(String alertId) {
        try {
            AlertTrigger alertTrigger = (AlertTrigger)this.alertTriggerRepository.findById((Object)alertId).orElseThrow(() -> new AlertNotFoundException(alertId));
            return this.convert(alertTrigger);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to find alert by id {}", (Object)alertId, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to find alert with id", e);
        }
    }

    private List<AlertTriggerEntity> findAll() {
        try {
            Set triggers = this.alertTriggerRepository.findAll();
            return triggers.stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list all alerts";
            this.LOGGER.error("An error occurs while trying to list all alerts", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all alerts", ex);
        }
    }

    @Override
    public List<AlertTriggerEntity> findByReference(AlertReferenceType referenceType, String referenceId) {
        try {
            return this.alertTriggerRepository.findByReference(referenceType.name(), referenceId).stream().map(this::convert).sorted(Comparator.comparing(alertTriggerEntity -> alertTriggerEntity != null ? alertTriggerEntity.getName() : null)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts by reference " + referenceType + "/" + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public List<AlertTriggerEntity> findByReferenceAndReferenceIds(AlertReferenceType referenceType, List<String> referenceIds) {
        try {
            return this.alertTriggerRepository.findByReferenceAndReferenceIds(referenceType.name(), referenceIds).stream().map(this::convert).sorted(Comparator.comparing(alertTriggerEntity -> alertTriggerEntity != null ? alertTriggerEntity.getName() : null)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts by reference " + referenceType + "/" + referenceIds;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public List<AlertTriggerEntity> findByReferenceWithEventCounts(AlertReferenceType referenceType, String referenceId) {
        try {
            List triggers = this.alertTriggerRepository.findByReference(referenceType.name(), referenceId);
            return triggers.stream().map(new Function<AlertTrigger, AlertTriggerEntity>(){

                @Override
                public AlertTriggerEntity apply(AlertTrigger alertTrigger) {
                    AlertTriggerEntity entity = AlertServiceImpl.this.convert(alertTrigger);
                    AlertServiceImpl.this.getLastEvent(entity.getId()).ifPresent(alertEvent -> {
                        entity.setLastAlertAt(alertEvent.getCreatedAt());
                        entity.setLastAlertMessage(alertEvent.getMessage());
                    });
                    Date from = new Date(System.currentTimeMillis());
                    HashMap<String, Integer> counters = new HashMap<String, Integer>();
                    counters.put("5m", AlertServiceImpl.this.countEvents(entity.getId(), from.toInstant().minus(Duration.ofMinutes(5L)).toEpochMilli(), from.getTime()));
                    counters.put("1h", AlertServiceImpl.this.countEvents(entity.getId(), from.toInstant().minus(Duration.ofHours(1L)).toEpochMilli(), from.getTime()));
                    counters.put("1d", AlertServiceImpl.this.countEvents(entity.getId(), from.toInstant().minus(Duration.ofDays(1L)).toEpochMilli(), from.getTime()));
                    counters.put("1M", AlertServiceImpl.this.countEvents(entity.getId(), from.toInstant().minus(Duration.ofDays(30L)).toEpochMilli(), from.getTime()));
                    entity.setCounters(counters);
                    return entity;
                }
            }).sorted(Comparator.comparing(Trigger::getName)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts by reference " + referenceType + "/" + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public void delete(String alertId, String referenceId) {
        try {
            Optional optionalAlert = this.alertTriggerRepository.findById((Object)alertId);
            if (!optionalAlert.isPresent() || !((AlertTrigger)optionalAlert.get()).getReferenceId().equals(referenceId)) {
                throw new AlertNotFoundException(alertId);
            }
            AlertTriggerEntity alert = this.convert((AlertTrigger)optionalAlert.get());
            this.alertTriggerRepository.delete((Object)alertId);
            this.alertEventRepository.deleteAll(alertId);
            this.disableTrigger((Trigger)alert);
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while trying to delete the alert " + alertId;
            this.LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    @Override
    public Page<AlertEventEntity> findEvents(String alertId, AlertEventQuery eventQuery) {
        Page alertEventsRepo = this.alertEventRepository.search(new AlertEventCriteria.Builder().alert(alertId).from(eventQuery.getFrom()).to(eventQuery.getTo()).build(), new PageableBuilder().pageNumber(eventQuery.getPageNumber()).pageSize(eventQuery.getPageSize()).build());
        if (alertEventsRepo.getPageElements() == 0L) {
            return new Page(Collections.emptyList(), 1, 0, 0L);
        }
        List alertEvents = alertEventsRepo.getContent().stream().map(new Function<AlertEvent, AlertEventEntity>(){

            @Override
            public AlertEventEntity apply(AlertEvent alertEventRepo) {
                AlertEventEntity alertEvent = new AlertEventEntity();
                alertEvent.setCreatedAt(alertEventRepo.getCreatedAt());
                alertEvent.setMessage(alertEventRepo.getMessage());
                return alertEvent;
            }
        }).collect(Collectors.toList());
        return new Page(alertEvents, alertEventsRepo.getPageNumber(), (int)alertEventsRepo.getPageElements(), alertEventsRepo.getTotalElements());
    }

    private Set<AlertTriggerEntity> findByEvent(AlertEventType event) {
        try {
            this.LOGGER.debug("findByEvent: {}", (Object)event);
            Set set = this.alertTriggerRepository.findAll().stream().filter(alert -> alert.isTemplate() && alert.getEventRules() != null && alert.getEventRules().stream().map(AlertEventRule::getEvent).collect(Collectors.toList()).contains(event)).map(this::convert).sorted(Comparator.comparing(Trigger::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
            this.LOGGER.debug("findByEvent : {} - DONE", (Object)set);
            return set;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find alert triggers by event", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find alert triggers by event", ex);
        }
    }

    @Override
    public void createDefaults(AlertReferenceType referenceType, String referenceId) {
        if (this.getStatus().isEnabled()) {
            Set<AlertTriggerEntity> defaultAlerts = this.findByEvent(AlertEventType.API_CREATE);
            for (AlertTriggerEntity alert : defaultAlerts) {
                AlertTrigger trigger = this.convert(alert);
                AlertTriggerEntity triggerEntity = this.convert(trigger);
                triggerEntity.setId(UUID.toString((java.util.UUID)UUID.random()));
                triggerEntity.setReferenceType(AlertReferenceType.API);
                triggerEntity.setReferenceId(referenceId);
                triggerEntity.setTemplate(false);
                triggerEntity.setEnabled(true);
                triggerEntity.setEventRules(null);
                triggerEntity.setParentId(alert.getId());
                triggerEntity.setCreatedAt(new Date());
                triggerEntity.setUpdatedAt(trigger.getCreatedAt());
                try {
                    this.create0(this.convert(triggerEntity));
                }
                catch (TechnicalException te) {
                    this.LOGGER.error("Unable to create default alert", (Throwable)te);
                }
            }
        }
    }

    @Override
    public void applyDefaults(final String alertId, AlertReferenceType referenceType) {
        try {
            Optional optionalAlert = this.alertTriggerRepository.findById((Object)alertId);
            if (!optionalAlert.isPresent()) {
                throw new AlertNotFoundException(alertId);
            }
            final AlertTriggerEntity alert = this.convert((AlertTrigger)optionalAlert.get());
            if (!alert.isTemplate()) {
                throw new AlertTemplateInvalidException(alertId);
            }
            if (referenceType == AlertReferenceType.API) {
                this.apiRepository.search(null).stream().map(Api::getId).forEach(new Consumer<String>(){

                    @Override
                    public void accept(String apiId) {
                        try {
                            boolean create = AlertServiceImpl.this.alertTriggerRepository.findByReference(AlertReferenceType.API.name(), apiId).stream().noneMatch(alertTrigger -> alertId.equals(alertTrigger.getParentId()));
                            if (create) {
                                AlertTrigger trigger = AlertServiceImpl.this.convert(alert);
                                AlertTriggerEntity triggerEntity = AlertServiceImpl.this.convert(trigger);
                                triggerEntity.setId(UUID.toString((java.util.UUID)UUID.random()));
                                triggerEntity.setReferenceType(AlertReferenceType.API);
                                triggerEntity.setReferenceId(apiId);
                                triggerEntity.setTemplate(false);
                                triggerEntity.setEnabled(true);
                                triggerEntity.setEventRules(null);
                                triggerEntity.setParentId(alertId);
                                triggerEntity.setCreatedAt(new Date());
                                triggerEntity.setUpdatedAt(trigger.getCreatedAt());
                                AlertServiceImpl.this.create0(AlertServiceImpl.this.convert(triggerEntity));
                            }
                        }
                        catch (TechnicalException te) {
                            AlertServiceImpl.this.LOGGER.error("Unable to create default alert for API {}", (Object)apiId, (Object)te);
                        }
                    }
                });
            }
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while trying to apply template alert " + alertId;
            this.LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    private void enhance(AlertTriggerEntity trigger, AlertReferenceType referenceType, String referenceId) {
        ArrayList notifications = trigger.getNotifications();
        if (notifications == null) {
            notifications = new ArrayList();
            trigger.setNotifications(notifications);
        }
        notifications.forEach(new Consumer<Notification>(){

            @Override
            public void accept(Notification notification) {
                if ("default-email".equalsIgnoreCase(notification.getType())) {
                    AlertServiceImpl.this.setDefaultEmailNotifier(notification);
                }
            }
        });
        ArrayList<StringCondition> filters = trigger.getFilters();
        if (filters == null) {
            filters = new ArrayList<StringCondition>();
            trigger.setFilters(filters);
        }
        switch (referenceType) {
            case API: 
            case APPLICATION: {
                filters.add(StringCondition.equals((String)referenceType.name().toLowerCase(), (String)referenceId).build());
                break;
            }
            case PLATFORM: {
                filters.add(StringCondition.matches((String)GraviteeContext.ReferenceContextType.ORGANIZATION.name().toLowerCase(), (String)("(?:.*,|^)" + GraviteeContext.getCurrentOrganization() + "(?:,.*|$)|\\*"), (boolean)true).build());
                filters.add(StringCondition.matches((String)GraviteeContext.ReferenceContextType.ENVIRONMENT.name().toLowerCase(), (String)("(?:.*|^)" + GraviteeContext.getCurrentEnvironment() + "(?:,.*|$)|\\*"), (boolean)true).build());
            }
        }
    }

    private void setDefaultEmailNotifier(Notification notification) {
        EmailNotifierConfiguration configuration = new EmailNotifierConfiguration();
        if (this.host == null) {
            configuration.setHost(this.parameterService.find(Key.EMAIL_HOST, ParameterReferenceType.ORGANIZATION));
            String emailPort = this.parameterService.find(Key.EMAIL_PORT, ParameterReferenceType.ORGANIZATION);
            if (emailPort != null) {
                configuration.setPort(Integer.parseInt(emailPort));
            }
            configuration.setUsername(this.parameterService.find(Key.EMAIL_USERNAME, ParameterReferenceType.ORGANIZATION));
            configuration.setPassword(this.parameterService.find(Key.EMAIL_PASSWORD, ParameterReferenceType.ORGANIZATION));
            configuration.setStartTLSEnabled(this.parameterService.findAsBoolean(Key.EMAIL_HOST, ParameterReferenceType.ORGANIZATION));
        } else {
            configuration.setHost(this.host);
            configuration.setPort(Integer.parseInt(this.port));
            configuration.setUsername(this.username);
            configuration.setPassword(this.password);
            configuration.setStartTLSEnabled(this.startTLSEnabled);
            configuration.setSslKeyStore(this.sslKeyStore);
            configuration.setSslKeyStorePassword(this.sslKeyStorePassword);
            configuration.setSslTrustAll(this.sslTrustAll);
        }
        configuration.setAuthMethods(this.authMethods);
        try {
            JsonNode emailNode = this.mapper.readTree(notification.getConfiguration());
            configuration.setFrom(emailNode.path("from").asText());
            configuration.setTo(emailNode.path("to").asText());
            configuration.setSubject(String.format(this.subject, emailNode.path("subject").asText()));
            configuration.setBody(emailNode.path("body").asText());
            notification.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
            notification.setType("email-notifier");
        }
        catch (IOException e) {
            this.LOGGER.error("Unexpected error while converting system email configuration to email notifier");
        }
    }

    private void checkAlert() {
        if (!this.parameterService.findAsBoolean(Key.ALERT_ENABLED, ParameterReferenceType.ORGANIZATION) || this.triggerProviderManager.findAll().isEmpty()) {
            throw new AlertUnavailableException();
        }
    }

    private void triggerOrCancelAlert(Trigger trigger) {
        if (trigger.isEnabled()) {
            this.pushTrigger(trigger);
        } else {
            this.disableTrigger(trigger);
        }
    }

    private void pushTrigger(Trigger trigger) {
        this.triggerProvider.register(trigger);
    }

    private void disableTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.triggerProvider.unregister(trigger);
    }

    public void afterPropertiesSet() throws Exception {
        this.triggerProvider.addListener((TriggerProvider.Listener)new TriggerProvider.OnConnectionListener(){

            public void doOnConnect() {
                AlertServiceImpl.this.LOGGER.info("Connected to alerting system. Sync alert triggers...");
                AlertServiceImpl.this.findAll().stream().filter(alertTriggerEntity -> !alertTriggerEntity.isTemplate()).forEach(new Consumer<AlertTriggerEntity>(){

                    @Override
                    public void accept(AlertTriggerEntity alertTriggerEntity) {
                        AlertServiceImpl.this.enhance(alertTriggerEntity, alertTriggerEntity.getReferenceType(), alertTriggerEntity.getReferenceId());
                        AlertServiceImpl.this.triggerOrCancelAlert((Trigger)alertTriggerEntity);
                    }
                });
                AlertServiceImpl.this.LOGGER.info("Alert triggers synchronized with the alerting system.");
            }
        });
        this.triggerProvider.addListener((TriggerProvider.Listener)new TriggerProvider.OnDisconnectionListener(){

            public void doOnDisconnect() {
                AlertServiceImpl.this.LOGGER.error("Connection with the alerting system has been loose.");
            }
        });
        this.triggerProvider.addListener((TriggerProvider.Listener)new TriggerProvider.OnCommandListener(){

            public void doOnCommand(Command command) {
                if (command instanceof AlertNotificationCommand) {
                    AlertServiceImpl.this.handleAlertNotificationCommand((AlertNotificationCommand)command);
                } else {
                    AlertServiceImpl.this.LOGGER.warn("Unknown alert command: {}", (Object)command);
                }
            }
        });
        this.triggerProvider.addListener((TriggerProvider.Listener)new TriggerProvider.OnCommandResultListener(){

            public <T> void doOnCommand(Command command, Handler<T> resultHandler) {
                ResolvePropertyCommandHandler supplier = null;
                if (command instanceof ResolvePropertyCommand) {
                    supplier = new ResolvePropertyCommandHandler((ResolvePropertyCommand)command);
                } else {
                    AlertServiceImpl.this.LOGGER.warn("Unknown alert command: {}", (Object)command);
                }
                if (supplier != null) {
                    resultHandler.handle(supplier.get());
                } else {
                    resultHandler.handle(null);
                }
            }
        });
    }

    private void handleAlertNotificationCommand(AlertNotificationCommand command) {
        try {
            AlertEvent alertEvent = new AlertEvent();
            alertEvent.setId(UUID.toString((java.util.UUID)UUID.random()));
            alertEvent.setAlert(command.getTrigger());
            alertEvent.setCreatedAt(new Date(command.getTimestamp()));
            alertEvent.setUpdatedAt(alertEvent.getCreatedAt());
            alertEvent.setMessage(command.getMessage());
            this.alertEventRepository.create((Object)alertEvent);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create an alert event from command {}" + command;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private int countEvents(String triggerId, long from, long to) {
        return (int)this.alertEventRepository.search(new AlertEventCriteria.Builder().alert(triggerId).from(from).to(to).build(), new PageableBuilder().pageNumber(0).pageSize(1).build()).getTotalElements();
    }

    private Optional<AlertEvent> getLastEvent(String triggerId) {
        Page alertEventsRepo = this.alertEventRepository.search(new AlertEventCriteria.Builder().alert(triggerId).from(0L).to(0L).build(), new PageableBuilder().pageNumber(0).pageSize(1).build());
        return alertEventsRepo.getPageElements() == 0L ? Optional.empty() : Optional.of((AlertEvent)alertEventsRepo.getContent().get(0));
    }

    private AlertTrigger convert(AlertTriggerEntity alertEntity) {
        AlertTrigger alert = new AlertTrigger();
        alert.setId(alertEntity.getId());
        alert.setName(alertEntity.getName());
        alert.setDescription(alertEntity.getDescription());
        alert.setReferenceId(alertEntity.getReferenceId());
        alert.setReferenceType(alertEntity.getReferenceType().name());
        alert.setEnabled(alertEntity.isTemplate() || alertEntity.isEnabled());
        alert.setType(alertEntity.getType());
        alert.setSeverity(alertEntity.getSeverity().name());
        alert.setTemplate(alertEntity.isTemplate());
        alert.setParentId(alertEntity.getParentId());
        alert.setCreatedAt(alertEntity.getCreatedAt());
        if (alertEntity.getEventRules() != null && !alertEntity.getEventRules().isEmpty()) {
            alert.setEventRules(alertEntity.getEventRules().stream().map(alertEventRuleEntity -> new AlertEventRule(AlertEventType.valueOf((String)alertEventRuleEntity.getEvent().toUpperCase()))).collect(Collectors.toList()));
        }
        try {
            String definition = this.mapper.writeValueAsString((Object)alertEntity);
            alert.setDefinition(definition);
        }
        catch (Exception ex) {
            this.LOGGER.error("An unexpected error occurs while transforming the alert trigger definition into string", (Throwable)ex);
        }
        return alert;
    }

    private AlertTrigger convert(NewAlertTriggerEntity alertEntity) {
        AlertTrigger alert = new AlertTrigger();
        alert.setId(UUID.toString((java.util.UUID)UUID.random()));
        alertEntity.setId(alert.getId());
        alert.setName(alertEntity.getName());
        alert.setDescription(alertEntity.getDescription());
        alert.setReferenceId(alertEntity.getReferenceId());
        alert.setReferenceType(alertEntity.getReferenceType().name());
        alert.setEnabled(alertEntity.isEnabled());
        alert.setType(alertEntity.getType());
        alert.setSeverity(alertEntity.getSeverity().name());
        alert.setTemplate(alertEntity.isTemplate());
        if (alertEntity.getEventRules() != null && !alertEntity.getEventRules().isEmpty()) {
            alert.setEventRules(alertEntity.getEventRules().stream().map(alertEventRuleEntity -> new AlertEventRule(AlertEventType.valueOf((String)alertEventRuleEntity.getEvent().toUpperCase()))).collect(Collectors.toList()));
        }
        try {
            String definition = this.mapper.writeValueAsString((Object)alertEntity);
            alert.setDefinition(definition);
        }
        catch (Exception ex) {
            this.LOGGER.error("An unexpected error occurs while transforming the alert trigger definition into string", (Throwable)ex);
        }
        return alert;
    }

    private AlertTrigger convert(UpdateAlertTriggerEntity alertEntity) {
        AlertTrigger alert = new AlertTrigger();
        alert.setId(UUID.toString((java.util.UUID)UUID.random()));
        alert.setName(alertEntity.getName());
        alert.setDescription(alertEntity.getDescription());
        alert.setEnabled(alertEntity.isEnabled());
        alert.setSeverity(alertEntity.getSeverity().name());
        if (alertEntity.getEventRules() != null && !alertEntity.getEventRules().isEmpty()) {
            alert.setEventRules(alertEntity.getEventRules().stream().map(alertEventRuleEntity -> new AlertEventRule(AlertEventType.valueOf((String)alertEventRuleEntity.getEvent().toUpperCase()))).collect(Collectors.toList()));
        } else {
            alert.setEventRules(null);
        }
        try {
            String definition = this.mapper.writeValueAsString((Object)alertEntity);
            alert.setDefinition(definition);
        }
        catch (Exception ex) {
            this.LOGGER.error("An unexpected error occurs while transforming the alert trigger definition into string", (Throwable)ex);
        }
        return alert;
    }

    private AlertTriggerEntity convert(AlertTrigger alert) {
        try {
            Trigger trigger = (Trigger)this.mapper.readValue(alert.getDefinition(), Trigger.class);
            AlertTriggerEntityWrapper alertTriggerEntity = new AlertTriggerEntityWrapper(trigger);
            alertTriggerEntity.setDescription(alert.getDescription());
            alertTriggerEntity.setReferenceId(alert.getReferenceId());
            alertTriggerEntity.setReferenceType(AlertReferenceType.valueOf((String)alert.getReferenceType()));
            alertTriggerEntity.setCreatedAt(alert.getCreatedAt());
            alertTriggerEntity.setUpdatedAt(alert.getUpdatedAt());
            alertTriggerEntity.setType(alert.getType());
            if (alert.getSeverity() != null) {
                alertTriggerEntity.setSeverity(Trigger.Severity.valueOf((String)alert.getSeverity()));
            } else {
                alertTriggerEntity.setSeverity(Trigger.Severity.INFO);
            }
            alertTriggerEntity.setEnabled(alert.isEnabled());
            alertTriggerEntity.setTemplate(alert.isTemplate());
            alertTriggerEntity.setParentId(alert.getParentId());
            if (alert.getEventRules() != null) {
                alertTriggerEntity.setEventRules(alert.getEventRules().stream().map(alertEventRule -> new AlertEventRuleEntity(alertEventRule.getEvent().name())).collect(Collectors.toList()));
            }
            return alertTriggerEntity;
        }
        catch (Exception ex) {
            this.LOGGER.error("An unexpected error occurs while transforming the alert trigger from its definition", (Throwable)ex);
            return null;
        }
    }

    private final class ResolvePropertyCommandHandler
    implements Supplier<Map<String, Map<String, Object>>> {
        private final ResolvePropertyCommand command;

        ResolvePropertyCommandHandler(ResolvePropertyCommand command) {
            this.command = command;
        }

        @Override
        public Map<String, Map<String, Object>> get() {
            Map properties = this.command.getProperties();
            final HashMap<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
            if (properties != null) {
                properties.entrySet().stream().forEach(new Consumer<Map.Entry<String, String>>(){

                    @Override
                    public void accept(Map.Entry<String, String> entry) {
                        switch (entry.getKey()) {
                            case "api": {
                                values.put(entry.getKey(), ResolvePropertyCommandHandler.this.getAPIMetadata(entry.getValue()));
                                break;
                            }
                            case "application": {
                                values.put(entry.getKey(), ResolvePropertyCommandHandler.this.getApplicationMetadata(entry.getValue()));
                                break;
                            }
                            case "plan": {
                                values.put(entry.getKey(), ResolvePropertyCommandHandler.this.getPlanMetadata(entry.getValue()));
                            }
                        }
                    }
                });
            }
            return values;
        }

        private Map<String, Object> getAPIMetadata(String api) {
            Map<String, Object> metadata = new HashMap<String, Object>();
            try {
                if (api.equals(AlertServiceImpl.UNKNOWN_SERVICE)) {
                    metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_UNKNOWN_API_NAME);
                    metadata.put(AlertServiceImpl.METADATA_UNKNOWN, Boolean.TRUE.toString());
                } else {
                    ApiEntity apiEntity = AlertServiceImpl.this.apiService.findById(api);
                    metadata = (Map)AlertServiceImpl.this.mapper.convertValue((Object)apiEntity, Map.class);
                    metadata.put("id", api);
                    metadata.put("primaryOwner", AlertServiceImpl.this.mapper.convertValue((Object)apiEntity.getPrimaryOwner(), Map.class));
                    metadata.remove("picture");
                    metadata.remove("proxy");
                    metadata.remove("paths");
                    metadata.remove("properties");
                    metadata.remove("services");
                    metadata.remove("resources");
                    metadata.remove("response_templates");
                    metadata.remove("path_mappings");
                    List<ApiMetadataEntity> metadataList = AlertServiceImpl.this.apiMetadataService.findAllByApi(api);
                    HashMap mapMetadata = new HashMap(metadataList.size());
                    metadataList.forEach(m -> mapMetadata.put(m.getKey(), m.getValue() == null ? m.getDefaultValue() : m.getValue()));
                    metadata.put("metadata", AlertServiceImpl.this.mapper.convertValue(mapMetadata, Map.class));
                }
            }
            catch (ApiNotFoundException anfe) {
                metadata.put(AlertServiceImpl.METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_DELETED_API_NAME);
            }
            return metadata;
        }

        private Map<String, Object> getApplicationMetadata(String application) {
            Map<String, Object> metadata = new HashMap<String, Object>();
            try {
                if (application.equals(AlertServiceImpl.UNKNOWN_SERVICE)) {
                    metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_UNKNOWN_APPLICATION_NAME);
                    metadata.put(AlertServiceImpl.METADATA_UNKNOWN, Boolean.TRUE.toString());
                } else {
                    ApplicationEntity applicationEntity = AlertServiceImpl.this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), application);
                    metadata = (Map)AlertServiceImpl.this.mapper.convertValue((Object)applicationEntity, Map.class);
                    metadata.remove("picture");
                }
            }
            catch (ApplicationNotFoundException anfe) {
                metadata.put(AlertServiceImpl.METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_DELETED_APPLICATION_NAME);
            }
            return metadata;
        }

        private Map<String, Object> getPlanMetadata(String plan) {
            HashMap<String, Object> metadata = new HashMap<String, String>();
            try {
                PlanEntity planEntity = AlertServiceImpl.this.planService.findById(plan);
                metadata = (Map)AlertServiceImpl.this.mapper.convertValue((Object)planEntity, Map.class);
            }
            catch (PlanNotFoundException anfe) {
                metadata.put(AlertServiceImpl.METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_DELETED_PLAN_NAME);
            }
            return metadata;
        }
    }
}

