/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.notifier.NotifierPlugin;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.repository.management.model.PortalNotificationDefaultReferenceId;
import io.gravitee.rest.api.model.NotifierEntity;
import io.gravitee.rest.api.model.PluginEntity;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.PortalNotificationService;
import io.gravitee.rest.api.service.exceptions.NotifierNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.PortalHook;
import io.gravitee.rest.api.service.notifiers.EmailNotifierService;
import io.gravitee.rest.api.service.notifiers.WebhookNotifierService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class NotifierServiceImpl
extends AbstractService
implements NotifierService {
    public static final String DEFAULT_EMAIL_NOTIFIER_ID = "default-email";
    private static final String DEFAULT_WEBHOOK_NOTIFIER_ID = "default-webhook";
    private final Logger LOGGER = LoggerFactory.getLogger(NotifierServiceImpl.class);
    private static final NotifierEntity DEFAULT_EMAIL_NOTIFIER = new NotifierEntity();
    @Autowired
    private ConfigurablePluginManager<NotifierPlugin> notifierManager;
    @Autowired
    PortalNotificationConfigRepository portalNotificationConfigRepository;
    @Autowired
    PortalNotificationService portalNotificationService;
    @Autowired
    GenericNotificationConfigRepository genericNotificationConfigRepository;
    @Autowired
    @Lazy
    EmailNotifierService emailNotifierService;
    @Autowired
    @Lazy
    WebhookNotifierService webhookNotifierService;

    @Override
    @Async
    public void trigger(ApiHook hook, String apiId, Map<String, Object> params) {
        this.triggerPortalNotifications(hook, NotificationReferenceType.API, apiId, params);
        this.triggerGenericNotifications(hook, NotificationReferenceType.API, apiId, params);
    }

    @Override
    @Async
    public void triggerEmail(ApplicationHook hook, String appId, Map<String, Object> params, String recipient) {
        if (recipient != null && !recipient.isEmpty()) {
            GenericNotificationConfig genericNotificationConfig = new GenericNotificationConfig();
            genericNotificationConfig.setConfig(recipient);
            genericNotificationConfig.setNotifier(DEFAULT_EMAIL_NOTIFIER_ID);
            this.emailNotifierService.trigger(hook, genericNotificationConfig, params);
        } else {
            this.LOGGER.debug("Recipient email is missing, ignore email trigger '{}' for application '{}'", (Object)hook, (Object)appId);
        }
    }

    @Override
    @Async
    public void trigger(ApplicationHook hook, String applicationId, Map<String, Object> params) {
        this.triggerPortalNotifications(hook, NotificationReferenceType.APPLICATION, applicationId, params);
        this.triggerGenericNotifications(hook, NotificationReferenceType.APPLICATION, applicationId, params);
    }

    @Override
    public boolean hasEmailNotificationFor(ApplicationHook hook, String applicationId, Map<String, Object> params, String recipient) {
        boolean result = false;
        try {
            for (GenericNotificationConfig genericNotificationConfig : this.genericNotificationConfigRepository.findByReferenceAndHook(hook.name(), NotificationReferenceType.APPLICATION, applicationId)) {
                if (!genericNotificationConfig.getNotifier().equals(DEFAULT_EMAIL_NOTIFIER_ID)) continue;
                List<String> mails = this.emailNotifierService.getMails(genericNotificationConfig, params);
                result = mails != null && mails.contains(recipient);
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error looking for GenericNotificationConfig with {}/{}/{}", new Object[]{hook, NotificationReferenceType.APPLICATION, applicationId, e});
        }
        return result;
    }

    @Override
    @Async
    public void trigger(PortalHook hook, Map<String, Object> params) {
        this.triggerPortalNotifications(hook, NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name(), params);
        this.triggerGenericNotifications(hook, NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name(), params);
    }

    private void triggerPortalNotifications(Hook hook, NotificationReferenceType refType, String refId, Map<String, Object> params) {
        try {
            List<String> userIds = this.portalNotificationConfigRepository.findByReferenceAndHook(hook.name(), refType, refId).stream().map(PortalNotificationConfig::getUser).collect(Collectors.toList());
            if (!userIds.isEmpty()) {
                this.portalNotificationService.create(hook, userIds, params);
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error looking for PortalNotificationConfig with {}/{}/{}", new Object[]{hook, refType, refId, e});
        }
    }

    private void triggerGenericNotifications(Hook hook, NotificationReferenceType refType, String refId, Map<String, Object> params) {
        try {
            block10: for (GenericNotificationConfig genericNotificationConfig : this.genericNotificationConfigRepository.findByReferenceAndHook(hook.name(), refType, refId)) {
                switch (genericNotificationConfig.getNotifier()) {
                    case "default-email": {
                        this.emailNotifierService.trigger(hook, genericNotificationConfig, params);
                        continue block10;
                    }
                    case "default-webhook": {
                        this.webhookNotifierService.trigger(hook, genericNotificationConfig, params);
                        continue block10;
                    }
                }
                this.LOGGER.error("Unknown notifier {}", (Object)genericNotificationConfig.getNotifier());
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error looking for GenericNotificationConfig with {}/{}/{}", new Object[]{hook, refType, refId, e});
        }
    }

    @Override
    public List<io.gravitee.rest.api.model.notification.NotifierEntity> list(NotificationReferenceType referenceType, String referenceId) {
        io.gravitee.rest.api.model.notification.NotifierEntity emailNotifier = new io.gravitee.rest.api.model.notification.NotifierEntity();
        emailNotifier.setId(DEFAULT_EMAIL_NOTIFIER_ID);
        emailNotifier.setName("Default Email Notifier");
        emailNotifier.setType("EMAIL");
        io.gravitee.rest.api.model.notification.NotifierEntity webHookNotifier = new io.gravitee.rest.api.model.notification.NotifierEntity();
        webHookNotifier.setId(DEFAULT_WEBHOOK_NOTIFIER_ID);
        webHookNotifier.setName("Default Webhook Notifier");
        webHookNotifier.setType("WEBHOOK");
        return Arrays.asList(emailNotifier, webHookNotifier);
    }

    @Override
    public Set<NotifierEntity> findAll() {
        try {
            this.LOGGER.debug("List all notifiers");
            Collection plugins = this.notifierManager.findAll();
            Set<NotifierEntity> notifiers = plugins.stream().map(plugin -> this.convert((NotifierPlugin)plugin, false)).collect(Collectors.toSet());
            notifiers.add(DEFAULT_EMAIL_NOTIFIER);
            return notifiers;
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to list all notifiers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all notifiers", ex);
        }
    }

    @Override
    public NotifierEntity findById(String notifier) {
        this.LOGGER.debug("Find policy by ID: {}", (Object)notifier);
        if (DEFAULT_EMAIL_NOTIFIER_ID.equals(notifier)) {
            return DEFAULT_EMAIL_NOTIFIER;
        }
        NotifierPlugin plugin = (NotifierPlugin)this.notifierManager.get(notifier);
        if (plugin == null) {
            throw new NotifierNotFoundException(notifier);
        }
        return this.convert(plugin, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSchema(String notifier) {
        try {
            this.LOGGER.debug("Find notifier schema by ID: {}", (Object)notifier);
            if (DEFAULT_EMAIL_NOTIFIER_ID.equals(notifier)) {
                URL url = this.getClass().getResource("/notifiers/default-email.json");
                if (url == null) {
                    throw new IOException("Resource not found for: /notifiers/default-email.json");
                }
                try (InputStream notifierInputStream = url.openStream();){
                    String string;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(notifierInputStream, StandardCharsets.UTF_8));){
                        string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                    }
                    return string;
                }
            }
            return this.notifierManager.getSchema(notifier);
        }
        catch (IOException ioex) {
            this.LOGGER.error("An error occurs while trying to get notifier schema for notifier {}", (Object)notifier, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get notifier schema for notifier " + notifier, ioex);
        }
    }

    private NotifierEntity convert(NotifierPlugin plugin, boolean withPlugin) {
        NotifierEntity entity = new NotifierEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        if (withPlugin) {
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setPlugin(plugin.clazz());
            pluginEntity.setPath(plugin.path().toString());
            pluginEntity.setType(plugin.type().toString().toLowerCase());
            pluginEntity.setDependencies(plugin.dependencies());
            entity.setPlugin(pluginEntity);
        }
        return entity;
    }

    static {
        DEFAULT_EMAIL_NOTIFIER.setId(DEFAULT_EMAIL_NOTIFIER_ID);
        DEFAULT_EMAIL_NOTIFIER.setName("System email");
        DEFAULT_EMAIL_NOTIFIER.setDescription("System email notifier");
    }
}

