/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.validator.JsonHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaLocation;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.RegexFormatValidator;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class JsonSchemaServiceImpl
implements JsonSchemaService {
    private final Pattern errorFieldNamePattern = Pattern.compile("\\[(.*?)\\]");

    @Override
    public String validate(String schema, String configuration) {
        String safeConfiguration = JsonHelper.clearNullValues(configuration);
        if (schema != null && !schema.equals("")) {
            JSONObject schemaJson = new JSONObject(schema);
            JSONObject safeConfigurationJson = new JSONObject(safeConfiguration);
            Schema schemaValidator = SchemaLoader.builder().useDefaults(true).addFormatValidator((FormatValidator)new JavaRegexValidator()).schemaJson(schemaJson).draftV7Support().build().load().build();
            try {
                schemaValidator.validate((Object)safeConfigurationJson);
            }
            catch (ValidationException e) {
                if (e.getCausingExceptions().isEmpty()) {
                    this.checkAndUpdate(safeConfigurationJson, e);
                }
                e.getCausingExceptions().forEach(cause -> this.checkAndUpdate(safeConfigurationJson, (ValidationException)((Object)cause)));
            }
            return safeConfigurationJson.toString();
        }
        return safeConfiguration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject checkAndUpdate(JSONObject safeConfigurationJson, ValidationException validationException) {
        if ("required".equalsIgnoreCase(validationException.getKeyword())) {
            Optional<String> errorField = this.getField(validationException);
            if (!errorField.isPresent()) return safeConfigurationJson;
            ObjectSchema violatedSchema = (ObjectSchema)validationException.getViolatedSchema();
            Schema schemaField = (Schema)violatedSchema.getPropertySchemas().get(errorField.get());
            if (!schemaField.hasDefaultValue()) throw new InvalidDataException(this.getAllMessages(validationException));
            SchemaLocation location = violatedSchema.getLocation();
            this.updateProperty(location, errorField.get(), schemaField.getDefaultValue(), safeConfigurationJson);
            return safeConfigurationJson;
        } else {
            if (!"additionalProperties".equalsIgnoreCase(validationException.getKeyword())) throw new InvalidDataException(this.getAllMessages(validationException));
            Optional<String> errorField = this.getField(validationException);
            if (!errorField.isPresent()) throw new InvalidDataException(this.getAllMessages(validationException));
            safeConfigurationJson.remove(errorField.get());
        }
        return safeConfigurationJson;
    }

    private void updateProperty(SchemaLocation location, String key, Object value, JSONObject target) {
        Arrays.stream(location.toString().split("/")).filter(token -> !token.equals("properties") && !token.isEmpty()).map(property -> {
            if (!property.equals("#")) {
                if (!target.has(property)) {
                    target.put(property, (Object)new JSONObject());
                }
                return target.getJSONObject(property);
            }
            return target;
        }).reduce((toForgot, toKeep) -> toKeep).ifPresent(propertyToUpdate -> propertyToUpdate.put(key, value));
    }

    private String getAllMessages(ValidationException validationException) {
        return String.join((CharSequence)"\n", validationException.getAllMessages());
    }

    private Optional<String> getField(ValidationException validationException) {
        Matcher matcher = this.errorFieldNamePattern.matcher(validationException.getErrorMessage());
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private class JavaRegexValidator
    extends RegexFormatValidator {
        private JavaRegexValidator() {
        }

        public String formatName() {
            return "java-regex";
        }
    }
}

