/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.ConsumerType;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.repository.management.model.flow.FlowConsumer;
import io.gravitee.repository.management.model.flow.FlowConsumerType;
import io.gravitee.repository.management.model.flow.FlowOperator;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.repository.management.model.flow.FlowStep;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class FlowConverter {
    public Flow toDefinition(io.gravitee.repository.management.model.flow.Flow model) {
        Flow flow = new Flow();
        flow.setCondition(model.getCondition());
        flow.setEnabled(model.isEnabled());
        flow.setMethods(model.getMethods());
        flow.setName(model.getName());
        PathOperator pathOperator = new PathOperator();
        pathOperator.setPath(model.getPath());
        pathOperator.setOperator(Operator.valueOf((String)model.getOperator().name()));
        flow.setPathOperator(pathOperator);
        flow.setPre(model.getPre().stream().map(this::toDefinitionFlow).collect(Collectors.toList()));
        flow.setPost(model.getPost().stream().map(this::toDefinitionFlow).collect(Collectors.toList()));
        flow.setConsumers(model.getConsumers().stream().map(this::toDefinitionFlow).collect(Collectors.toList()));
        return flow;
    }

    public io.gravitee.repository.management.model.flow.Flow toModel(Flow flowDefinition, FlowReferenceType referenceType, String referenceId, int order) {
        io.gravitee.repository.management.model.flow.Flow flow = new io.gravitee.repository.management.model.flow.Flow();
        flow.setId(UuidString.generateRandom());
        flow.setCreatedAt(new Date());
        flow.setUpdatedAt(flow.getCreatedAt());
        flow.setOrder(order);
        flow.setReferenceType(referenceType);
        flow.setReferenceId(referenceId);
        flow.setPost(this.convertFlowSteps(flowDefinition.getPost()));
        flow.setPre(this.convertFlowSteps(flowDefinition.getPre()));
        flow.setPath(flowDefinition.getPath());
        flow.setOperator(FlowOperator.valueOf((String)flowDefinition.getOperator().name()));
        flow.setName(flowDefinition.getName());
        flow.setMethods(flowDefinition.getMethods());
        flow.setEnabled(flowDefinition.isEnabled());
        flow.setCondition(flowDefinition.getCondition());
        flow.setConsumers(flowDefinition.getConsumers().stream().map(this::convertConsumer).collect(Collectors.toList()));
        return flow;
    }

    @NotNull
    private List<FlowStep> convertFlowSteps(List<Step> steps) {
        if (steps == null) {
            return Collections.emptyList();
        }
        return IntStream.range(0, steps.size()).mapToObj(index -> this.convertStep((Step)steps.get(index), index)).collect(Collectors.toList());
    }

    private FlowConsumer convertConsumer(Consumer consumer) {
        FlowConsumer flowConsumer = new FlowConsumer();
        flowConsumer.setConsumerId(consumer.getConsumerId());
        flowConsumer.setConsumerType(FlowConsumerType.valueOf((String)consumer.getConsumerType().name()));
        return flowConsumer;
    }

    private Consumer toDefinitionFlow(FlowConsumer flowConsumer) {
        Consumer consumer = new Consumer();
        consumer.setConsumerId(flowConsumer.getConsumerId());
        consumer.setConsumerType(ConsumerType.valueOf((String)flowConsumer.getConsumerType().name()));
        return consumer;
    }

    private FlowStep convertStep(Step step, int order) {
        FlowStep flowStep = new FlowStep();
        flowStep.setPolicy(step.getPolicy());
        flowStep.setName(step.getName());
        flowStep.setEnabled(step.isEnabled());
        flowStep.setConfiguration(step.getConfiguration());
        flowStep.setDescription(step.getDescription());
        flowStep.setCondition(step.getCondition());
        flowStep.setOrder(order);
        return flowStep;
    }

    private Step toDefinitionFlow(FlowStep flowStep) {
        Step step = new Step();
        step.setPolicy(flowStep.getPolicy());
        step.setName(flowStep.getName());
        step.setEnabled(flowStep.isEnabled());
        step.setConfiguration(flowStep.getConfiguration());
        step.setDescription(flowStep.getDescription());
        step.setCondition(flowStep.getCondition());
        return step;
    }
}

