/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.parser;

import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.impl.swagger.parser.AbstractDescriptorParser;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIParser
extends AbstractDescriptorParser<OAIDescriptor> {
    private final Logger logger = LoggerFactory.getLogger(OAIParser.class);

    public OAIDescriptor parse(String content, ParseOptions options) {
        OpenAPIParser parser = new OpenAPIParser();
        String path = content;
        File temp = null;
        if (!OAIParser.isLocationUrl(content)) {
            temp = this.createTempFile(content);
            path = temp.getAbsolutePath();
        }
        SwaggerParseResult parseResult = parser.readLocation(path, null, options);
        if (temp != null) {
            temp.delete();
        }
        if (parseResult.getMessages() != null) {
            List filteredMessages = parseResult.getMessages().stream().filter(message -> message != null && !message.matches("^attribute info.contact.*")).collect(Collectors.toList());
            parseResult.setMessages(filteredMessages);
        }
        if (parseResult.getOpenAPI() == null) {
            throw new SwaggerDescriptorException("Malformed descriptor");
        }
        OAIDescriptor descriptor = new OAIDescriptor(parseResult.getOpenAPI());
        descriptor.setMessages(parseResult.getMessages());
        return descriptor;
    }

    @Override
    public OAIDescriptor parse(String content) {
        return this.parse(content, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(String content) {
        File temp = null;
        String fileName = "gio_swagger_" + System.currentTimeMillis();
        BufferedWriter bw = null;
        FileWriter out = null;
        try {
            temp = File.createTempFile(fileName, ".tmp");
            out = new FileWriter(temp);
            bw = new BufferedWriter(out);
            bw.write(content);
            bw.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return temp;
    }

    static {
        System.setProperty(String.format("%s.trustAll", RemoteUrl.class.getName()), Boolean.TRUE.toString());
    }
}

