/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.converter.api;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.policy.api.swagger.Policy;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.impl.swagger.converter.api.OAIToAPIConverter;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.validator.JsonHelper;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OAIToAPIV2Converter
extends OAIToAPIConverter {
    public OAIToAPIV2Converter(ImportSwaggerDescriptorEntity swaggerDescriptor, PolicyOperationVisitorManager policyOperationVisitorManager, GroupService groupService, TagService tagService) {
        super(swaggerDescriptor, policyOperationVisitorManager, groupService, tagService);
    }

    @Override
    protected SwaggerApiEntity fill(SwaggerApiEntity apiEntity, OpenAPI oai) {
        apiEntity.setGraviteeDefinitionVersion(DefinitionVersion.V2.getLabel());
        if (this.swaggerDescriptor.isWithPolicyPaths()) {
            ArrayList allFlows = new ArrayList();
            oai.getPaths().forEach((key, pathItem) -> {
                String path = key.replaceAll("\\{(.[^/\\}]*)\\}", ":$1");
                Map operations = pathItem.readOperationsMap();
                operations.forEach((httpMethod, operation) -> {
                    Flow flow = this.createFlow(path, Collections.singleton(HttpMethod.valueOf((String)httpMethod.name())));
                    this.getVisitors().forEach(oaiOperationVisitor -> {
                        Optional policy = (Optional)oaiOperationVisitor.visit(oai, operation);
                        if (policy.isPresent()) {
                            Step step = new Step();
                            step.setName(((Policy)policy.get()).getName());
                            step.setEnabled(true);
                            step.setDescription(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary());
                            step.setPolicy(((Policy)policy.get()).getName());
                            String configuration = JsonHelper.clearNullValues(((Policy)policy.get()).getConfiguration());
                            step.setConfiguration(configuration);
                            String scope = JsonHelper.getScope(configuration);
                            if (scope != null && scope.toLowerCase().equals("response")) {
                                flow.getPost().add(step);
                            } else {
                                flow.getPre().add(step);
                            }
                        }
                    });
                    allFlows.add(flow);
                });
            });
            apiEntity.setFlows(allFlows);
            if (this.swaggerDescriptor.isWithPathMapping() && allFlows.size() > 0) {
                apiEntity.setPathMappings(allFlows.stream().map(flow -> flow.getPath()).collect(Collectors.toSet()));
            }
        }
        String defaultDeclaredPath = "/";
        if (!this.swaggerDescriptor.isWithPathMapping()) {
            apiEntity.setPathMappings(Collections.singleton("/"));
        }
        return apiEntity;
    }

    private Flow createFlow(String path, Set<HttpMethod> methods) {
        Flow flow = new Flow();
        flow.setName("");
        flow.setCondition("");
        flow.setEnabled(true);
        PathOperator pathOperator = new PathOperator();
        pathOperator.setPath(path);
        pathOperator.setOperator(Operator.EQUALS);
        flow.setPathOperator(pathOperator);
        flow.setMethods(methods);
        return flow;
    }
}

