/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.ApiServiceCockpit;
import io.gravitee.rest.api.service.cockpit.services.ImportSwaggerDescriptorBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiServiceCockpitImpl
implements ApiServiceCockpit {
    private final Logger logger = LoggerFactory.getLogger(ApiServiceCockpitImpl.class);
    private final ObjectMapper objectMapper;
    private final ApiService apiService;
    private final SwaggerService swaggerService;
    private final PageService pageService;
    private final ApiMetadataService apiMetadataService;
    private final PlanService planService;

    public ApiServiceCockpitImpl(ObjectMapper objectMapper, ApiService apiService, SwaggerService swaggerService, PageService pageService, ApiMetadataService apiMetadataService, PlanService planService) {
        this.objectMapper = objectMapper;
        this.apiService = apiService;
        this.swaggerService = swaggerService;
        this.pageService = pageService;
        this.apiMetadataService = apiMetadataService;
        this.planService = planService;
    }

    @Override
    public ApiEntity createApi(String apiId, String userId, String swaggerDefinition, String environmentId, DeploymentMode mode) {
        GraviteeContext.setCurrentEnvironment(environmentId);
        if (mode == DeploymentMode.API_MOCKED) {
            this.logger.debug("Create Mocked Api [{}].", (Object)apiId);
            return this.createMockedApi(apiId, userId, swaggerDefinition, environmentId);
        }
        if (mode == DeploymentMode.API_PUBLISHED) {
            this.logger.debug("Create Published Api [{}].", (Object)apiId);
            return this.createPublishedApi(apiId, userId, swaggerDefinition, environmentId);
        }
        this.logger.debug("Create Documented Api [{}].", (Object)apiId);
        return this.createDocumentedApi(apiId, userId, swaggerDefinition, environmentId);
    }

    @Override
    public ApiEntity updateApi(String apiId, String userId, String swaggerDefinition, String environmentId, DeploymentMode mode) {
        GraviteeContext.setCurrentEnvironment(environmentId);
        if (mode == DeploymentMode.API_DOCUMENTED) {
            this.logger.debug("Update Documented Api [{}].", (Object)apiId);
            return this.updateDocumentedApi(apiId, swaggerDefinition);
        }
        if (mode == DeploymentMode.API_MOCKED) {
            this.logger.debug("Update Mocked Api [{}].", (Object)apiId);
            return this.updateMockedApi(apiId, userId, swaggerDefinition);
        }
        this.logger.debug("Update Published Api [{}].", (Object)apiId);
        return this.updateMockedApi(apiId, userId, swaggerDefinition);
    }

    private ApiEntity createDocumentedApi(String apiId, String userId, String swaggerDefinition, String environmentId) {
        ImportSwaggerDescriptorEntity swaggerDescriptor = ImportSwaggerDescriptorBuilder.buildForDocumentedApi(swaggerDefinition);
        return this.createApiEntity(apiId, userId, swaggerDescriptor);
    }

    private ApiEntity updateDocumentedApi(String apiId, String swaggerDefinition) {
        return this.updateApiEntity(apiId, ImportSwaggerDescriptorBuilder.buildForDocumentedApi(swaggerDefinition));
    }

    private ApiEntity createMockedApi(String apiId, String userId, String swaggerDefinition, String environmentId) {
        ImportSwaggerDescriptorEntity swaggerDescriptor = ImportSwaggerDescriptorBuilder.buildForMockedApi(swaggerDefinition);
        this.createApiEntity(apiId, userId, swaggerDescriptor);
        this.planService.create(this.createKeylessPlan(apiId, environmentId));
        return this.apiService.start(apiId, userId);
    }

    private ApiEntity updateMockedApi(String apiId, String userId, String swaggerDefinition) {
        this.updateApiEntity(apiId, ImportSwaggerDescriptorBuilder.buildForMockedApi(swaggerDefinition));
        ApiDeploymentEntity apiDeployment = new ApiDeploymentEntity();
        apiDeployment.setDeploymentLabel("Model updated");
        return this.apiService.deploy(apiId, userId, EventType.PUBLISH_API, apiDeployment);
    }

    private ApiEntity createPublishedApi(String apiId, String userId, String swaggerDefinition, String environmentId) {
        ImportSwaggerDescriptorEntity swaggerDescriptor = ImportSwaggerDescriptorBuilder.buildForMockedApi(swaggerDefinition);
        this.createApiEntity(apiId, userId, swaggerDescriptor);
        this.planService.create(this.createKeylessPlan(apiId, environmentId));
        ApiEntity apiEntity = this.apiService.start(apiId, userId);
        this.publishSwaggerDocumentation(apiId);
        UpdateApiEntity updateEntity = ApiService.convert(apiEntity);
        updateEntity.setVisibility(Visibility.PUBLIC);
        updateEntity.setLifecycleState(ApiLifecycleState.PUBLISHED);
        return this.apiService.update(apiId, updateEntity);
    }

    private ApiEntity updateApiEntity(String apiId, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        SwaggerApiEntity api = this.swaggerService.createAPI(swaggerDescriptor, DefinitionVersion.V2);
        api.setPaths(null);
        return this.apiService.updateFromSwagger(apiId, api, swaggerDescriptor);
    }

    private ApiEntity createApiEntity(String apiId, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        SwaggerApiEntity api = this.swaggerService.createAPI(swaggerDescriptor, DefinitionVersion.V2);
        api.setPaths(null);
        ObjectNode apiDefinition = (ObjectNode)this.objectMapper.valueToTree((Object)api);
        apiDefinition.put("id", apiId);
        ApiEntity createdApi = this.apiService.createWithApiDefinition((UpdateApiEntity)api, userId, (JsonNode)apiDefinition);
        this.pageService.createAsideFolder(apiId, GraviteeContext.getCurrentEnvironment());
        this.pageService.createOrUpdateSwaggerPage(apiId, swaggerDescriptor, true);
        this.apiMetadataService.create(api.getMetadata(), createdApi.getId());
        return createdApi;
    }

    private NewPlanEntity createKeylessPlan(String apiId, String environmentId) {
        NewPlanEntity plan = new NewPlanEntity();
        plan.setId(UuidString.generateForEnvironment(environmentId, apiId));
        plan.setName("Keyless plan");
        plan.setSecurity(PlanSecurityType.KEY_LESS);
        plan.setApi(apiId);
        plan.setStatus(PlanStatus.PUBLISHED);
        return plan;
    }

    private void publishSwaggerDocumentation(String apiId) {
        PageEntity page;
        List<PageEntity> apiDocs = this.pageService.search(new PageQuery.Builder().api(apiId).type(PageType.SWAGGER).build(), GraviteeContext.getCurrentEnvironment());
        if (apiDocs.isEmpty()) {
            this.logger.error("No swagger documentation to publish");
            return;
        }
        if (apiDocs.size() > 1) {
            this.logger.error("More than one swagger documentation, this should not happen");
        }
        if (!(page = apiDocs.get(0)).isPublished()) {
            UpdatePageEntity updatePage = UpdatePageEntity.from((PageEntity)page);
            updatePage.setPublished(Boolean.valueOf(true));
            this.pageService.update(page.getId(), updatePage);
        }
    }
}

