/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class ApiQualityRuleNotFoundException
extends AbstractNotFoundException {
    private final String api;
    private final String qualityRule;

    public ApiQualityRuleNotFoundException(String api, String qualityRule) {
        this.api = api;
        this.qualityRule = qualityRule;
    }

    @Override
    public String getMessage() {
        return "API quality rule [" + this.qualityRule + "] can not be found for api [" + this.api + "].";
    }

    @Override
    public String getTechnicalCode() {
        return "apiQuality.rule.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("api", ApiQualityRuleNotFoundException.this.api);
                this.put("qualityRule", ApiQualityRuleNotFoundException.this.qualityRule);
            }
        };
    }
}

