/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.api.NewApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ApiService {
    public ApiEntity findById(String var1);

    public Set<ApiEntity> findAllByEnvironment(String var1);

    default public Set<ApiEntity> findAllLightByEnvironment(String environmentId) {
        return this.findAllLightByEnvironment(environmentId, true);
    }

    public Set<ApiEntity> findAllLightByEnvironment(String var1, boolean var2);

    public Set<ApiEntity> findAllLight();

    public Page<ApiEntity> findByUser(String var1, ApiQuery var2, Sortable var3, Pageable var4, boolean var5);

    public Set<ApiEntity> findByUser(String var1, ApiQuery var2, boolean var3);

    public Page<ApiEntity> findPublishedByUser(String var1, ApiQuery var2, Sortable var3, Pageable var4);

    public Set<ApiEntity> findPublishedByUser(String var1);

    public List<String> findIdsByUser(String var1, ApiQuery var2, boolean var3);

    public Set<ApiEntity> findPublishedByUser(String var1, ApiQuery var2);

    public Set<ApiEntity> findByVisibility(Visibility var1);

    public ApiEntity create(NewApiEntity var1, String var2);

    public ApiEntity createFromCockpit(String var1, String var2, String var3);

    public ApiEntity createFromSwagger(SwaggerApiEntity var1, String var2, ImportSwaggerDescriptorEntity var3);

    public ApiEntity createWithApiDefinition(UpdateApiEntity var1, String var2, JsonNode var3);

    public ApiEntity update(String var1, UpdateApiEntity var2);

    public ApiEntity update(String var1, UpdateApiEntity var2, boolean var3);

    public ApiEntity updateFromSwagger(String var1, SwaggerApiEntity var2, ImportSwaggerDescriptorEntity var3);

    public void delete(String var1);

    public ApiEntity start(String var1, String var2);

    public ApiEntity stop(String var1, String var2);

    public boolean isSynchronized(String var1);

    public ApiEntity deploy(String var1, String var2, EventType var3, ApiDeploymentEntity var4);

    public ApiEntity rollback(String var1, UpdateApiEntity var2);

    public String exportAsJson(String var1, String var2, String ... var3);

    public ApiEntity createWithImportedDefinition(ApiEntity var1, String var2, String var3);

    public ApiEntity updateWithImportedDefinition(ApiEntity var1, String var2, String var3);

    public InlinePictureEntity getPicture(String var1);

    public void deleteCategoryFromAPIs(String var1);

    public void deleteTagFromAPIs(String var1);

    public ApiModelEntity findByIdForTemplates(String var1, boolean var2);

    default public ApiModelEntity findByIdForTemplates(String apiId) {
        return this.findByIdForTemplates(apiId, false);
    }

    public boolean exists(String var1);

    public ApiEntity importPathMappingsFromPage(ApiEntity var1, String var2);

    public static UpdateApiEntity convert(ApiEntity apiEntity) {
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        updateApiEntity.setProxy(apiEntity.getProxy());
        updateApiEntity.setVersion(apiEntity.getVersion());
        updateApiEntity.setName(apiEntity.getName());
        updateApiEntity.setProperties(new PropertiesEntity(apiEntity.getProperties()));
        updateApiEntity.setDescription(apiEntity.getDescription());
        updateApiEntity.setGroups(apiEntity.getGroups());
        updateApiEntity.setPaths(apiEntity.getPaths());
        updateApiEntity.setPicture(apiEntity.getPicture());
        updateApiEntity.setBackground(apiEntity.getBackground());
        updateApiEntity.setResources(apiEntity.getResources());
        updateApiEntity.setTags(apiEntity.getTags());
        updateApiEntity.setServices(apiEntity.getServices());
        updateApiEntity.setVisibility(apiEntity.getVisibility());
        updateApiEntity.setLabels(apiEntity.getLabels());
        updateApiEntity.setPathMappings(apiEntity.getPathMappings());
        updateApiEntity.setLifecycleState(apiEntity.getLifecycleState());
        updateApiEntity.setPlans(apiEntity.getPlans());
        updateApiEntity.setFlows(apiEntity.getFlows());
        updateApiEntity.setGraviteeDefinitionVersion(apiEntity.getGraviteeDefinitionVersion());
        updateApiEntity.setFlowMode(apiEntity.getFlowMode());
        updateApiEntity.setResponseTemplates(apiEntity.getResponseTemplates());
        updateApiEntity.setCategories(apiEntity.getCategories());
        updateApiEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        return updateApiEntity;
    }

    public Page<ApiEntity> search(ApiQuery var1, Sortable var2, Pageable var3);

    public Collection<ApiEntity> search(ApiQuery var1);

    public Collection<String> searchIds(ApiQuery var1);

    public Page<ApiEntity> search(String var1, Map<String, Object> var2, Sortable var3, Pageable var4);

    public Collection<ApiEntity> search(String var1, Map<String, Object> var2) throws TechnicalException;

    public List<ApiHeaderEntity> getPortalHeaders(String var1);

    public ApiEntity askForReview(String var1, String var2, ReviewEntity var3);

    public ApiEntity acceptReview(String var1, String var2, ReviewEntity var3);

    public ApiEntity rejectReview(String var1, String var2, ReviewEntity var3);

    public InlinePictureEntity getBackground(String var1);

    public ApiEntity migrate(String var1);

    public boolean hasHealthCheckEnabled(ApiEntity var1, boolean var2);

    public ApiEntity fetchMetadataForApi(ApiEntity var1);

    public PrimaryOwnerEntity getPrimaryOwner(String var1) throws TechnicalManagementException;

    public void addGroup(String var1, String var2);

    public void removeGroup(String var1, String var2);

    public void checkPolicyConfigurations(Map<String, List<Rule>> var1, List<Flow> var2, List<Plan> var3);
}

