/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.search.SearchEngineService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class SearchIndexUpgrader
implements Upgrader,
Ordered {
    @Autowired
    private ApiService apiService;
    @Autowired
    private PageService pageService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private EnvironmentService environmentService;

    @Override
    public boolean upgrade() {
        try {
            this.organizationService.findAll().forEach(organization -> this.environmentService.findByOrganization(organization.getId()).forEach(environment -> {
                GraviteeContext.setCurrentOrganization(organization.getId());
                GraviteeContext.setCurrentEnvironment(environment.getId());
                Set<ApiEntity> apis = this.apiService.findAll();
                apis.forEach(apiEntity -> {
                    this.searchEngineService.index((Indexable)apiEntity, true);
                    List<PageEntity> apiPages = this.pageService.search(new PageQuery.Builder().api(apiEntity.getId()).published(Boolean.valueOf(true)).build(), true, GraviteeContext.getCurrentEnvironment());
                    apiPages.forEach(page -> {
                        try {
                            if (!(PageType.FOLDER.name().equals(page.getType()) || PageType.ROOT.name().equals(page.getType()) || PageType.SYSTEM_FOLDER.name().equals(page.getType()) || PageType.LINK.name().equals(page.getType()))) {
                                this.pageService.transformSwagger((PageEntity)page, apiEntity.getId());
                                this.searchEngineService.index((Indexable)page, true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                });
                Page<UserEntity> users = this.userService.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ACTIVE}).build(), (Pageable)new PageableImpl(1, Integer.MAX_VALUE));
                users.getContent().forEach(userEntity -> this.searchEngineService.index((Indexable)userEntity, true));
            }));
        }
        finally {
            GraviteeContext.cleanContext();
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 250;
    }
}

