/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.spel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.common.http.HttpHeaders;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.el.spel.context.SecuredMethodResolver;
import io.gravitee.rest.api.service.configuration.spel.SpelService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpelServiceImpl
implements SpelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpelServiceImpl.class);
    private static final String GRAMMAR_PATH = "/spel/grammar.json";
    private final ObjectMapper mapper;
    private final SecuredMethodResolver securedMethodResolver;
    private final List<Class<?>> supportedTypes = new ArrayList<Class<?>>(){
        {
            this.add(MultiValueMap.class);
            this.add(HttpHeaders.class);
            this.add(Map.class);
            this.add(Boolean.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Math.class);
            this.add(Object.class);
            this.add(List.class);
            this.add(Collection.class);
            this.add(Set.class);
            this.add(String.class);
            this.add(String[].class);
        }
    };

    public SpelServiceImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        this.securedMethodResolver = new SecuredMethodResolver();
    }

    @Override
    public JsonNode getGrammar() {
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(GRAMMAR_PATH);
            JsonNode actualObj = this.mapper.readTree(resourceAsStream);
            ObjectNode typesNode = ((ObjectNode)actualObj).putObject("_types");
            this.buildTypes(typesNode);
            return actualObj;
        }
        catch (IOException e) {
            LOGGER.error("Error while getting the Expression Language grammar", (Throwable)e);
            return null;
        }
    }

    private void buildTypes(ObjectNode types) {
        this.supportedTypes.forEach(aClass -> {
            ObjectNode type = types.putObject(aClass.getSimpleName());
            this.buildType(type, (Class<?>)aClass);
        });
    }

    private void buildType(ObjectNode type, Class<?> classz) {
        ArrayNode methodsNode = type.putArray("methods");
        Arrays.stream(this.securedMethodResolver.getMethods(classz)).filter(f -> Modifier.isPublic(f.getModifiers())).forEach(method -> {
            ObjectNode methodNode = methodsNode.addObject();
            this.fillMethod(methodNode, (Method)method);
        });
    }

    private void fillMethod(ObjectNode methodNode, Method method) {
        methodNode.put("name", method.getName());
        methodNode.put("returnType", method.getReturnType().getSimpleName());
        Parameter[] parameters = method.getParameters();
        if (parameters.length > 0) {
            ArrayNode paramsNode = methodNode.putArray("params");
            Arrays.stream(parameters).forEach(parameter -> {
                ObjectNode paramNode = paramsNode.addObject();
                this.fillParameter(paramNode, (Parameter)parameter);
            });
        }
    }

    private void fillParameter(ObjectNode parameterNode, Parameter parameter) {
        parameterNode.put("name", parameter.getName());
        parameterNode.put("type", parameter.getType().getSimpleName());
    }
}

