/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.bridge.operation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.bridge.BridgeMultiReply;
import io.gravitee.cockpit.api.command.bridge.BridgeReply;
import io.gravitee.cockpit.api.command.bridge.BridgeSimpleReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperation;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperationHandler;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.reactivex.Single;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ListEnvironmentOperationHandler
implements BridgeOperationHandler {
    private final Logger logger = LoggerFactory.getLogger(ListEnvironmentOperationHandler.class);
    private final EnvironmentService environmentService;
    private final InstallationService installationService;
    private final ObjectMapper objectMapper;

    public ListEnvironmentOperationHandler(EnvironmentService environmentService, InstallationService installationService, ObjectMapper objectMapper) {
        this.environmentService = environmentService;
        this.installationService = installationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canHandle(String bridgeOperation) {
        return Objects.equals(BridgeOperation.LIST_ENVIRONMENT.name(), bridgeOperation);
    }

    @Override
    public Single<BridgeReply> handle(BridgeCommand bridgeCommand) {
        BridgeMultiReply multiReply = new BridgeMultiReply();
        multiReply.setCommandId(bridgeCommand.getId());
        try {
            List<EnvironmentEntity> managedEnvironments = this.environmentService.findByOrganization(bridgeCommand.getOrganizationId());
            multiReply.setCommandStatus(CommandStatus.SUCCEEDED);
            multiReply.setReplies(managedEnvironments.stream().map(environmentEntity -> {
                BridgeSimpleReply simpleReply = new BridgeSimpleReply();
                simpleReply.setCommandId(bridgeCommand.getId());
                simpleReply.setCommandStatus(CommandStatus.SUCCEEDED);
                simpleReply.setOrganizationId(environmentEntity.getOrganizationId());
                simpleReply.setEnvironmentId(environmentEntity.getId());
                simpleReply.setInstallationId(this.installationService.get().getId());
                try {
                    simpleReply.setPayload(this.objectMapper.writeValueAsString(environmentEntity));
                }
                catch (JsonProcessingException e) {
                    this.logger.warn("Problem while serializing environment {}", (Object)environmentEntity.getId());
                    simpleReply.setMessage("Problem while serializing environment: " + environmentEntity.getId());
                    simpleReply.setCommandStatus(CommandStatus.ERROR);
                }
                return simpleReply;
            }).collect(Collectors.toList()));
        }
        catch (TechnicalManagementException ex) {
            multiReply.setCommandStatus(CommandStatus.ERROR);
            multiReply.setMessage("No environment available for organization: " + bridgeCommand.getOrganizationId());
        }
        return Single.just((Object)multiReply);
    }
}

