/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.user.UserCommand;
import io.gravitee.cockpit.api.command.user.UserPayload;
import io.gravitee.cockpit.api.command.user.UserReply;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.reactivex.Single;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserCommandHandler
implements CommandHandler<UserCommand, UserReply> {
    public static final String COCKPIT_SOURCE = "cockpit";
    private final Logger logger = LoggerFactory.getLogger(UserCommandHandler.class);
    private final UserService userService;

    public UserCommandHandler(UserService userService) {
        this.userService = userService;
    }

    public Command.Type handleType() {
        return Command.Type.USER_COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Single<UserReply> handle(UserCommand command) {
        UserPayload userPayload = (UserPayload)command.getPayload();
        GraviteeContext.setCurrentOrganization(userPayload.getOrganizationId());
        try {
            UserEntity existingUser = this.userService.findBySource(COCKPIT_SOURCE, userPayload.getId(), false);
            UpdateUserEntity updatedUser = new UpdateUserEntity();
            updatedUser.setFirstname(userPayload.getFirstName());
            updatedUser.setLastname(userPayload.getLastName());
            updatedUser.setEmail(userPayload.getEmail());
            updatedUser.setPicture(userPayload.getPicture());
            updatedUser.setCustomFields(new HashMap());
            if (userPayload.getAdditionalInformation() != null) {
                updatedUser.getCustomFields().putAll(userPayload.getAdditionalInformation());
            }
            updatedUser.getCustomFields().computeIfAbsent("picture", k -> userPayload.getPicture());
            updatedUser.getCustomFields().computeIfAbsent("sub", k -> userPayload.getUsername());
            UserEntity cockpitUserEntity = this.userService.update(existingUser.getId(), updatedUser);
            this.logger.info("User [{}] with APIM id [{}] updated.", (Object)userPayload.getUsername(), (Object)cockpitUserEntity.getId());
            Single single = Single.just((Object)new UserReply(command.getId(), CommandStatus.SUCCEEDED));
            return single;
        }
        catch (UserNotFoundException unfe) {
            NewExternalUserEntity newUser = new NewExternalUserEntity();
            newUser.setSourceId(userPayload.getId());
            newUser.setFirstname(userPayload.getFirstName());
            newUser.setLastname(userPayload.getLastName());
            newUser.setEmail(userPayload.getEmail());
            newUser.setPicture(userPayload.getPicture());
            newUser.setSource(COCKPIT_SOURCE);
            newUser.setCustomFields(new HashMap());
            if (userPayload.getAdditionalInformation() != null) {
                newUser.getCustomFields().putAll(userPayload.getAdditionalInformation());
            }
            newUser.getCustomFields().computeIfAbsent("picture", k -> userPayload.getPicture());
            newUser.getCustomFields().computeIfAbsent("sub", k -> userPayload.getUsername());
            try {
                UserEntity cockpitUserEntity = this.userService.create(newUser, false);
                this.logger.info("User [{}] created with APIM id [{}].", (Object)userPayload.getUsername(), (Object)cockpitUserEntity.getId());
                Single single = Single.just((Object)new UserReply(command.getId(), CommandStatus.SUCCEEDED));
                return single;
            }
            catch (Exception e) {
                this.logger.info("Error occurred when creating user [{}] for organization [{}].", new Object[]{userPayload.getUsername(), userPayload.getOrganizationId(), e});
                Single single = Single.just((Object)new UserReply(command.getId(), CommandStatus.ERROR));
                return single;
            }
        }
        catch (Exception e) {
            this.logger.info("Error occurred when updating user [{}] for organization [{}].", new Object[]{userPayload.getUsername(), userPayload.getOrganizationId(), e});
            Single single = Single.just((Object)new UserReply(command.getId(), CommandStatus.ERROR));
            return single;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }
}

