/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.converter.api;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.policy.api.swagger.Policy;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.impl.swagger.converter.api.OAIToAPIConverter;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.validator.PolicyHelper;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OAIToAPIV2Converter
extends OAIToAPIConverter {
    public OAIToAPIV2Converter(ImportSwaggerDescriptorEntity swaggerDescriptor, PolicyOperationVisitorManager policyOperationVisitorManager, GroupService groupService, TagService tagService) {
        super(swaggerDescriptor, policyOperationVisitorManager, groupService, tagService);
    }

    @Override
    protected SwaggerApiEntity fill(SwaggerApiEntity apiEntity, OpenAPI oai) {
        apiEntity.setGraviteeDefinitionVersion(DefinitionVersion.V2.getLabel());
        ArrayList allFlows = new ArrayList();
        HashSet<String> pathMappings = new HashSet<String>();
        if (this.swaggerDescriptor.isWithPolicyPaths() || this.swaggerDescriptor.isWithPathMapping()) {
            oai.getPaths().forEach((key, pathItem) -> {
                String path = PATH_PARAMS_PATTERN.matcher((CharSequence)key).replaceAll(":$1");
                if (this.swaggerDescriptor.isWithPathMapping()) {
                    pathMappings.add(path);
                }
                if (this.swaggerDescriptor.isWithPolicyPaths()) {
                    Map operations = pathItem.readOperationsMap();
                    operations.forEach((httpMethod, operation) -> {
                        Flow flow = this.createFlow(path, Collections.singleton(HttpMethod.valueOf((String)httpMethod.name())));
                        this.getVisitors().forEach(oaiOperationVisitor -> {
                            Optional policy = (Optional)oaiOperationVisitor.visit(oai, operation);
                            if (policy.isPresent()) {
                                Step step = new Step();
                                step.setName(((Policy)policy.get()).getName());
                                step.setEnabled(true);
                                step.setDescription(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary());
                                step.setPolicy(((Policy)policy.get()).getName());
                                String configuration = PolicyHelper.clearNullValues(((Policy)policy.get()).getConfiguration());
                                step.setConfiguration(configuration);
                                String scope = PolicyHelper.getScope(configuration);
                                if (scope != null && scope.toLowerCase().equals("response")) {
                                    flow.getPost().add(step);
                                } else {
                                    flow.getPre().add(step);
                                }
                            }
                        });
                        allFlows.add(flow);
                    });
                }
            });
        }
        if (pathMappings.isEmpty()) {
            String defaultDeclaredPath = "/";
            pathMappings.add("/");
        }
        apiEntity.setFlows(allFlows);
        apiEntity.setPathMappings(pathMappings);
        return apiEntity;
    }

    private Flow createFlow(String path, Set<HttpMethod> methods) {
        Flow flow = new Flow();
        flow.setName("");
        flow.setCondition("");
        flow.setEnabled(true);
        PathOperator pathOperator = new PathOperator();
        pathOperator.setPath(path);
        pathOperator.setOperator(Operator.EQUALS);
        flow.setPathOperator(pathOperator);
        flow.setMethods(methods);
        return flow;
    }
}

