/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Plan;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class PlansDataFixUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlansDataFixUpgrader.class);
    private static final String PLAN_DESCRIPTION = "This plan has been recreated during a data fix process. See documentation : https://docs.gravitee.io/apim/3.x/apim_installguide_migration.html#upgrade_to_3_10_8";
    private static final String PLAN_NAME_SUFFIX = "-Recreated";
    @Autowired
    private InstallationService installationService;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private EmailService emailService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${services.plans-data-fix-upgrader.enabled:true}")
    private boolean enabled;
    @Value(value="${services.plans-data-fix-upgrader.dryRun:true}")
    private boolean dryRun;
    @Value(value="${services.plans-data-fix-upgrader.notifyApiOwner:false}")
    private boolean notifyApiOwner;
    private boolean anomalyFound = false;

    @Override
    public boolean upgrade() {
        if (!this.enabled) {
            LOGGER.info("Skipping {} execution cause it's not enabled in configuration", (Object)this.getClass().getSimpleName());
            return false;
        }
        InstallationEntity installation = this.installationService.getOrInitialize();
        if (this.dryRun && this.isStatus(installation, Status.DRY_SUCCESS)) {
            LOGGER.info("Skipping {} execution cause it has already been successfully executed in dry mode", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.isStatus(installation, Status.SUCCESS)) {
            LOGGER.info("Skipping {} execution cause it has already been successfully executed", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.isStatus(installation, Status.RUNNING)) {
            LOGGER.warn("Skipping {} execution cause it's already running", (Object)this.getClass().getSimpleName());
            return false;
        }
        try {
            LOGGER.info("Starting {} execution with dry-run {}", (Object)this.getClass().getSimpleName(), (Object)(this.dryRun ? "enabled" : "disabled"));
            this.setExecutionStatus(installation, Status.RUNNING);
            this.fixPlansData();
            this.setExecutionStatus(installation, this.dryRun ? Status.DRY_SUCCESS : Status.SUCCESS);
        }
        catch (Throwable e) {
            LOGGER.error("{} execution failed", (Object)this.getClass().getSimpleName(), (Object)e);
            this.setExecutionStatus(installation, Status.FAILURE);
            return false;
        }
        LOGGER.info("Finishing {} execution", (Object)this.getClass().getSimpleName());
        return true;
    }

    @Override
    public int getOrder() {
        return 500;
    }

    protected void fixPlansData() throws Exception {
        for (Api api : this.apiRepository.findAll()) {
            io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
            if (DefinitionVersion.V2 != apiDefinition.getDefinitionVersion()) continue;
            this.fixApiPlans(api, apiDefinition);
        }
        if (!this.anomalyFound) {
            LOGGER.info("No plan data anomaly found");
        }
    }

    protected void fixApiPlans(Api api, io.gravitee.definition.model.Api apiDefinition) throws Exception {
        List definitionPlans;
        Set apiPlans = this.planRepository.findByApi(api.getId());
        if (!this.hasPlansDataAnomaly(apiPlans, definitionPlans = apiDefinition.getPlans())) {
            LOGGER.debug("Skipping API {} : no plans anomaly detected", (Object)api.getId());
            return;
        }
        if (!this.anomalyFound) {
            this.logWarningHeaderBlock();
            this.anomalyFound = true;
        }
        LOGGER.info("Plans anomalies found for API \"{}\" ({}) :", (Object)api.getName(), (Object)api.getId());
        Map<String, io.gravitee.repository.management.model.Plan> apiPlansMap = apiPlans.stream().collect(Collectors.toMap(io.gravitee.repository.management.model.Plan::getId, plan -> plan));
        Map<String, Plan> definitionPlansMap = definitionPlans.stream().collect(Collectors.toMap(Plan::getId, plan -> plan, (plan1, plan2) -> plan1));
        List<io.gravitee.repository.management.model.Plan> closedPlans = this.closeExtraApiPlans(definitionPlansMap, apiPlansMap);
        List<io.gravitee.repository.management.model.Plan> createdPlans = this.createMissingApiPlans(definitionPlansMap, apiPlansMap, api);
        this.updateApiDefinitionPlans(api, apiDefinition, definitionPlansMap);
        if (!this.dryRun && this.notifyApiOwner) {
            this.sendEmailToApiOwner(api, createdPlans, closedPlans);
        }
    }

    protected List<io.gravitee.repository.management.model.Plan> createMissingApiPlans(Map<String, Plan> definitionPlansMap, Map<String, io.gravitee.repository.management.model.Plan> apiPlansMap, Api api) throws TechnicalException {
        ArrayList<io.gravitee.repository.management.model.Plan> addedPlans = new ArrayList<io.gravitee.repository.management.model.Plan>();
        for (Map.Entry<String, Plan> definitionPlanEntry : definitionPlansMap.entrySet()) {
            String planId = definitionPlanEntry.getKey();
            if (apiPlansMap.containsKey(planId)) continue;
            Plan definitionPlan = definitionPlanEntry.getValue();
            io.gravitee.repository.management.model.Plan newApiPlan = this.planFromDefinitionPlan(definitionPlan, api.getId());
            LOGGER.info("- Will create plan \"{}\" for API \"{}\" ({}), which is missing in plans table", new Object[]{newApiPlan.getName(), api.getName(), api.getId()});
            if (!this.dryRun) {
                this.planRepository.create((Object)newApiPlan);
            }
            apiPlansMap.put(planId, newApiPlan);
            definitionPlan.setId(newApiPlan.getId());
            definitionPlan.setName(newApiPlan.getName());
            addedPlans.add(newApiPlan);
        }
        return addedPlans;
    }

    protected List<io.gravitee.repository.management.model.Plan> closeExtraApiPlans(Map<String, Plan> definitionPlansMap, Map<String, io.gravitee.repository.management.model.Plan> apiPlansMap) throws TechnicalException {
        List<io.gravitee.repository.management.model.Plan> extraPlans = apiPlansMap.values().stream().filter(apiPlan -> apiPlan.getStatus() != Plan.Status.CLOSED).filter(apiPlan -> !definitionPlansMap.containsKey(apiPlan.getId())).collect(Collectors.toList());
        for (io.gravitee.repository.management.model.Plan plan : extraPlans) {
            LOGGER.info("- Will close plan \"{}\" ({}), cause it's absent from api definition", (Object)plan.getName(), (Object)plan.getId());
            plan.setStatus(Plan.Status.CLOSED);
            if (this.dryRun) continue;
            this.planRepository.update((Object)plan);
        }
        return extraPlans;
    }

    private io.gravitee.repository.management.model.Plan planFromDefinitionPlan(Plan definitionPlan, String apiId) {
        io.gravitee.repository.management.model.Plan plan = new io.gravitee.repository.management.model.Plan();
        plan.setId(UuidString.generateRandom());
        plan.setType(Plan.PlanType.API);
        plan.setValidation(Plan.PlanValidationType.MANUAL);
        plan.setStatus(Plan.Status.DEPRECATED);
        plan.setName(definitionPlan.getName().concat(PLAN_NAME_SUFFIX));
        plan.setDescription(PLAN_DESCRIPTION);
        plan.setApi(apiId);
        plan.setSecurityDefinition(definitionPlan.getSecurityDefinition());
        plan.setSelectionRule(definitionPlan.getSelectionRule());
        plan.setTags(definitionPlan.getTags());
        plan.setCreatedAt(new Date());
        plan.setUpdatedAt(plan.getCreatedAt());
        plan.setNeedRedeployAt(plan.getCreatedAt());
        if (definitionPlan.getSecurity() != null) {
            plan.setSecurity(Plan.PlanSecurityType.valueOf((String)definitionPlan.getSecurity()));
        }
        return plan;
    }

    private void updateApiDefinitionPlans(Api api, io.gravitee.definition.model.Api apiDefinition, Map<String, Plan> definitionPlansMap) throws TechnicalException, JsonProcessingException {
        apiDefinition.setPlans(new ArrayList<Plan>(definitionPlansMap.values()));
        api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
        if (!this.dryRun) {
            this.apiRepository.update((Object)api);
        }
    }

    private void setExecutionStatus(InstallationEntity installation, Status status) {
        installation.getAdditionalInformation().put("PLANS_DATA_UPGRADER_STATUS", status.toString());
        this.installationService.setAdditionalInformation(installation.getAdditionalInformation());
    }

    private boolean isStatus(InstallationEntity installation, Status status) {
        return status.toString().equals(installation.getAdditionalInformation().get("PLANS_DATA_UPGRADER_STATUS"));
    }

    private boolean hasPlansDataAnomaly(Set<io.gravitee.repository.management.model.Plan> apiPlans, List<Plan> definitionPlans) {
        List apiPlansIds = apiPlans.stream().filter(plan -> plan.getStatus() != Plan.Status.CLOSED).map(io.gravitee.repository.management.model.Plan::getId).collect(Collectors.toList());
        List definitionPlansIds = definitionPlans.stream().map(Plan::getId).collect(Collectors.toList());
        return apiPlansIds.size() != definitionPlansIds.size() || !definitionPlansIds.containsAll(apiPlansIds);
    }

    protected void sendEmailToApiOwner(Api api, List<io.gravitee.repository.management.model.Plan> createdPlans, List<io.gravitee.repository.management.model.Plan> closedPlans) {
        this.getApiOwnerEmail(api).ifPresent(apiOwnerEmail -> {
            LOGGER.debug("Sending report email to api {} owner", (Object)api.getId());
            this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().params(Map.of("api", api, "closedPlans", closedPlans, "createdPlans", createdPlans)).to((String)apiOwnerEmail).template(EmailNotificationBuilder.EmailTemplate.API_PLANS_DATA_FIXED).build(), GraviteeContext.getCurrentContext());
        });
    }

    private Optional<String> getApiOwnerEmail(Api api) {
        return Optional.ofNullable(this.apiService.getPrimaryOwner(api.getId()).getEmail());
    }

    private void logWarningHeaderBlock() {
        LOGGER.warn("");
        LOGGER.warn("##############################################################");
        LOGGER.warn("#                           WARNING                          #");
        LOGGER.warn("##############################################################");
        LOGGER.warn("");
        LOGGER.warn("We detected database anomalies in your plans data.");
        LOGGER.warn("");
        if (this.dryRun) {
            LOGGER.warn("THIS IS A DRY RUN. DATABASE WON'T BE UPDATED.");
            LOGGER.warn("To fix anomalies, disable the dry run mode.");
            LOGGER.warn("Below, a list of changes that would happen without dry run");
        } else {
            LOGGER.warn("Database anomalies will be fixed.");
        }
        LOGGER.warn("See related documentation : https://docs.gravitee.io/apim/3.x/apim_installguide_migration.html#upgrade_to_3_10_8");
        LOGGER.warn("");
        LOGGER.warn("##############################################################");
        LOGGER.warn("");
    }

    static enum Status {
        RUNNING,
        DRY_SUCCESS,
        SUCCESS,
        FAILURE;

    }
}

