/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.promotion;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PromotionRepository;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.PromotionCriteria;
import io.gravitee.repository.management.api.search.Sortable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Promotion;
import io.gravitee.repository.management.model.PromotionAuthor;
import io.gravitee.repository.management.model.PromotionStatus;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityAuthor;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionQuery;
import io.gravitee.rest.api.model.promotion.PromotionRequestEntity;
import io.gravitee.rest.api.model.promotion.PromotionTargetEntity;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperation;
import io.gravitee.rest.api.service.cockpit.services.CockpitReply;
import io.gravitee.rest.api.service.cockpit.services.CockpitReplyStatus;
import io.gravitee.rest.api.service.cockpit.services.CockpitService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.BridgeOperationException;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.PromotionAlreadyInProgressException;
import io.gravitee.rest.api.service.exceptions.PromotionNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.promotion.PromotionService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PromotionServiceImpl
extends AbstractService
implements PromotionService {
    private final Logger LOGGER = LoggerFactory.getLogger(PromotionServiceImpl.class);
    private final ApiService apiService;
    private final ApiDuplicatorService apiDuplicatorService;
    private final CockpitService cockpitService;
    private final PromotionRepository promotionRepository;
    private final EnvironmentService environmentService;
    private final UserService userService;
    private final PermissionService permissionService;
    private final AuditService auditService;

    public PromotionServiceImpl(ApiService apiService, ApiDuplicatorService apiDuplicatorService, CockpitService cockpitService, PromotionRepository promotionRepository, EnvironmentService environmentService, UserService userService, PermissionService permissionService, AuditService auditService) {
        this.apiService = apiService;
        this.apiDuplicatorService = apiDuplicatorService;
        this.cockpitService = cockpitService;
        this.promotionRepository = promotionRepository;
        this.environmentService = environmentService;
        this.userService = userService;
        this.permissionService = permissionService;
        this.auditService = auditService;
    }

    @Override
    public List<PromotionTargetEntity> listPromotionTargets(String organizationId, String environmentId) {
        EnvironmentEntity environmentEntity = this.environmentService.findById(environmentId);
        CockpitReply<List<PromotionTargetEntity>> listCockpitReply = this.cockpitService.listPromotionTargets(organizationId);
        if (listCockpitReply.getStatus() == CockpitReplyStatus.SUCCEEDED) {
            return listCockpitReply.getReply().stream().filter(target -> !target.getId().equals(environmentEntity.getCockpitId())).collect(Collectors.toList());
        }
        throw new BridgeOperationException(BridgeOperation.LIST_ENVIRONMENT);
    }

    @Override
    public PromotionEntity promote(String sourceEnvironmentId, String apiId, PromotionRequestEntity promotionRequest, String userId) {
        String apiDefinition = this.apiDuplicatorService.exportAsJson(apiId, ApiSerializer.Version.DEFAULT.getVersion(), "id", "members", "groups");
        EnvironmentEntity currentEnvironmentEntity = this.environmentService.findById(sourceEnvironmentId);
        UserEntity author = this.userService.findById(userId);
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(List.of(PromotionEntityStatus.CREATED, PromotionEntityStatus.TO_BE_VALIDATED));
        promotionQuery.setApiId(apiId);
        List inProgressPromotions = this.search(promotionQuery, null, null).getContent().stream().filter(promotionEntity -> promotionEntity.getTargetEnvCockpitId().equals(promotionRequest.getTargetEnvCockpitId())).collect(Collectors.toList());
        if (!inProgressPromotions.isEmpty()) {
            throw new PromotionAlreadyInProgressException(((PromotionEntity)inProgressPromotions.get(0)).getId());
        }
        Promotion promotionToSave = this.convert(apiId, apiDefinition, currentEnvironmentEntity, promotionRequest, author);
        promotionToSave.setId(UuidString.generateRandom());
        Promotion createdPromotion = null;
        try {
            createdPromotion = (Promotion)this.promotionRepository.create((Object)promotionToSave);
            this.auditService.createApiAuditLog(createdPromotion.getApiId(), Collections.emptyMap(), (Audit.AuditEvent)Promotion.AuditEvent.PROMOTION_CREATED, createdPromotion.getCreatedAt(), null, createdPromotion);
        }
        catch (TechnicalException exception) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a promotion request for API %s", apiId), exception);
        }
        PromotionEntity promotionEntity2 = this.convert(createdPromotion);
        CockpitReply<PromotionEntity> cockpitReply = this.cockpitService.requestPromotion(promotionEntity2);
        promotionEntity2.setStatus(cockpitReply.getStatus() != CockpitReplyStatus.SUCCEEDED ? PromotionEntityStatus.ERROR : PromotionEntityStatus.TO_BE_VALIDATED);
        try {
            this.promotionRepository.update((Object)this.convert(promotionEntity2));
        }
        catch (TechnicalException exception) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to update promotion %s", promotionEntity2.getId()), exception);
        }
        if (cockpitReply.getStatus() != CockpitReplyStatus.SUCCEEDED) {
            throw new BridgeOperationException(BridgeOperation.PROMOTE_API);
        }
        return promotionEntity2;
    }

    @Override
    public PromotionEntity createOrUpdate(PromotionEntity promotionEntity) {
        try {
            Promotion createdOrUpdatedPromotion;
            Optional existingPromotion = this.promotionRepository.findById((Object)promotionEntity.getId());
            Promotion promotion = this.convert(promotionEntity);
            if (existingPromotion.isPresent()) {
                this.LOGGER.debug("Updating existing promotion: {}", (Object)promotion.getId());
                createdOrUpdatedPromotion = (Promotion)this.promotionRepository.update((Object)promotion);
            } else {
                this.LOGGER.debug("Creating promotion: {}", (Object)promotion.getId());
                createdOrUpdatedPromotion = (Promotion)this.promotionRepository.create((Object)promotion);
            }
            return this.convert(createdOrUpdatedPromotion);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to create or update a promotion using its id {}", (Object)promotionEntity.getId(), (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to create or update a promotion using its id {}" + promotionEntity.getId(), e);
        }
    }

    @Override
    public Page<PromotionEntity> search(PromotionQuery query, io.gravitee.rest.api.model.common.Sortable sortable, io.gravitee.rest.api.model.common.Pageable pageable) {
        try {
            this.LOGGER.debug("Searching promotions");
            PromotionCriteria criteria = this.queryToCriteriaBuilder(query).build();
            Page promotions = this.promotionRepository.search(criteria, this.buildSortable(sortable), this.buildPageable(pageable));
            List entities = promotions.getContent().stream().map(this::convert).collect(Collectors.toList());
            this.LOGGER.debug("Searching promotions - Done with {} elements", (Object)entities.size());
            return new Page(entities, promotions.getPageNumber() + 1, (int)promotions.getPageElements(), promotions.getTotalElements());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to search promotions", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search promotions", ex);
        }
    }

    @Override
    public PromotionEntity processPromotion(String organizationId, String environmentId, String promotion, boolean accepted, String user) {
        try {
            PromotionEntity promotionEntity;
            CockpitReply<PromotionEntity> cockpitReply;
            boolean shouldCreate;
            Promotion existing = (Promotion)this.promotionRepository.findById((Object)promotion).orElseThrow(() -> new PromotionNotFoundException(promotion));
            EnvironmentEntity environment = this.environmentService.findByCockpitId(existing.getTargetEnvCockpitId());
            existing.setStatus(accepted ? PromotionStatus.ACCEPTED : PromotionStatus.REJECTED);
            PromotionQuery promotionQuery = new PromotionQuery();
            promotionQuery.setStatuses(Collections.singletonList(PromotionEntityStatus.ACCEPTED));
            promotionQuery.setTargetEnvCockpitIds(Collections.singletonList(existing.getTargetEnvCockpitId()));
            promotionQuery.setTargetApiExists(Boolean.valueOf(true));
            promotionQuery.setApiId(existing.getApiId());
            List previousPromotions = this.search(promotionQuery, (io.gravitee.rest.api.model.common.Sortable)new SortableImpl("created_at", false), null).getContent();
            boolean bl = shouldCreate = CollectionUtils.isEmpty((Collection)previousPromotions) || !this.apiService.exists(((PromotionEntity)previousPromotions.get(0)).getTargetApiId());
            if (PromotionStatus.ACCEPTED.equals((Object)existing.getStatus())) {
                ApiEntity promoted = null;
                GraviteeContext.setCurrentEnvironment(environment.getId());
                if (shouldCreate) {
                    if (!this.permissionService.hasPermission(RolePermission.ENVIRONMENT_API, environment.getId(), RolePermissionAction.CREATE)) {
                        throw new ForbiddenAccessException();
                    }
                    promoted = this.apiDuplicatorService.createWithImportedDefinition(existing.getApiDefinition(), user, organizationId, environmentId);
                } else {
                    if (!this.permissionService.hasPermission(RolePermission.ENVIRONMENT_API, environment.getId(), RolePermissionAction.UPDATE)) {
                        throw new ForbiddenAccessException();
                    }
                    PromotionEntity lastAcceptedPromotion = (PromotionEntity)previousPromotions.get(0);
                    ApiEntity existingApi = this.apiService.findById(lastAcceptedPromotion.getTargetApiId());
                    promoted = this.apiDuplicatorService.updateWithImportedDefinition(existingApi.getId(), existing.getApiDefinition(), user, organizationId, environmentId);
                }
                existing.setTargetApiId(promoted.getId());
            }
            if ((cockpitReply = this.cockpitService.processPromotion(promotionEntity = this.convert(existing))).getStatus() != CockpitReplyStatus.SUCCEEDED) {
                throw new BridgeOperationException(BridgeOperation.PROMOTE_API);
            }
            Promotion updated = (Promotion)this.promotionRepository.update((Object)existing);
            return this.convert(updated);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to process promotion", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to process promotion", ex);
        }
    }

    private Promotion convert(String apiId, String apiDefinition, EnvironmentEntity source, PromotionRequestEntity target, UserEntity author) {
        PromotionAuthor promotionAuthor = new PromotionAuthor();
        promotionAuthor.setUserId(author.getId());
        promotionAuthor.setDisplayName(author.getDisplayName());
        promotionAuthor.setEmail(author.getEmail());
        promotionAuthor.setPicture(author.getPicture());
        promotionAuthor.setSource(author.getSource());
        promotionAuthor.setSourceId(author.getSourceId());
        Promotion promotion = new Promotion();
        promotion.setCreatedAt(new Date());
        promotion.setStatus(PromotionStatus.CREATED);
        promotion.setApiDefinition(apiDefinition);
        promotion.setApiId(apiId);
        promotion.setSourceEnvCockpitId(source.getCockpitId());
        promotion.setSourceEnvName(source.getName());
        promotion.setTargetEnvCockpitId(target.getTargetEnvCockpitId());
        promotion.setTargetEnvName(target.getTargetEnvName());
        promotion.setAuthor(promotionAuthor);
        return promotion;
    }

    private PromotionEntity convert(Promotion promotion) {
        PromotionEntityAuthor promotionEntityAuthor = new PromotionEntityAuthor();
        promotionEntityAuthor.setUserId(promotion.getAuthor().getUserId());
        promotionEntityAuthor.setDisplayName(promotion.getAuthor().getDisplayName());
        promotionEntityAuthor.setEmail(promotion.getAuthor().getEmail());
        promotionEntityAuthor.setPicture(promotion.getAuthor().getPicture());
        promotionEntityAuthor.setSource(promotion.getAuthor().getSource());
        promotionEntityAuthor.setSourceId(promotion.getAuthor().getSourceId());
        PromotionEntity promotionEntity = new PromotionEntity();
        promotionEntity.setId(promotion.getId());
        promotionEntity.setApiId(promotion.getApiId());
        promotionEntity.setCreatedAt(promotion.getCreatedAt());
        promotionEntity.setUpdatedAt(promotion.getUpdatedAt());
        promotionEntity.setSourceEnvCockpitId(promotion.getSourceEnvCockpitId());
        promotionEntity.setSourceEnvName(promotion.getSourceEnvName());
        promotionEntity.setTargetEnvCockpitId(promotion.getTargetEnvCockpitId());
        promotionEntity.setTargetEnvName(promotion.getTargetEnvName());
        promotionEntity.setApiDefinition(promotion.getApiDefinition());
        promotionEntity.setStatus(this.convert(promotion.getStatus()));
        promotionEntity.setAuthor(promotionEntityAuthor);
        promotionEntity.setTargetApiId(promotion.getTargetApiId());
        return promotionEntity;
    }

    private Promotion convert(PromotionEntity promotionEntity) {
        PromotionAuthor promotionAuthor = new PromotionAuthor();
        promotionAuthor.setUserId(promotionEntity.getAuthor().getUserId());
        promotionAuthor.setDisplayName(promotionEntity.getAuthor().getDisplayName());
        promotionAuthor.setEmail(promotionEntity.getAuthor().getEmail());
        promotionAuthor.setPicture(promotionEntity.getAuthor().getPicture());
        promotionAuthor.setSource(promotionEntity.getAuthor().getSource());
        promotionAuthor.setSourceId(promotionEntity.getAuthor().getSourceId());
        Promotion promotion = new Promotion();
        promotion.setId(promotionEntity.getId());
        promotion.setApiId(promotionEntity.getApiId());
        promotion.setCreatedAt(promotionEntity.getCreatedAt());
        promotion.setUpdatedAt(promotionEntity.getUpdatedAt());
        promotion.setSourceEnvCockpitId(promotionEntity.getSourceEnvCockpitId());
        promotion.setSourceEnvName(promotionEntity.getSourceEnvName());
        promotion.setTargetEnvCockpitId(promotionEntity.getTargetEnvCockpitId());
        promotion.setTargetEnvName(promotionEntity.getTargetEnvName());
        promotion.setApiDefinition(promotionEntity.getApiDefinition());
        promotion.setStatus(this.convert(promotionEntity.getStatus()));
        promotion.setAuthor(promotionAuthor);
        return promotion;
    }

    private PromotionEntityStatus convert(PromotionStatus promotionStatus) {
        return PromotionEntityStatus.valueOf((String)promotionStatus.name());
    }

    private PromotionStatus convert(PromotionEntityStatus promotionEntityStatus) {
        return PromotionStatus.valueOf((String)promotionEntityStatus.name());
    }

    private PromotionCriteria.Builder queryToCriteriaBuilder(PromotionQuery query) {
        PromotionCriteria.Builder builder = new PromotionCriteria.Builder();
        if (query == null) {
            return builder;
        }
        if (!CollectionUtils.isEmpty((Collection)query.getTargetEnvCockpitIds())) {
            builder.targetEnvCockpitIds(query.getTargetEnvCockpitIds().toArray(new String[0]));
        }
        if (query.getStatuses() != null) {
            builder.statuses(query.getStatuses().stream().map(this::convert).collect(Collectors.toList()));
        }
        if (query.getTargetApiExists() != null) {
            builder.targetApiExists(query.getTargetApiExists());
        }
        if (!StringUtils.isEmpty((Object)query.getApiId())) {
            builder.apiId(query.getApiId());
        }
        return builder;
    }

    private Sortable buildSortable(io.gravitee.rest.api.model.common.Sortable sortable) {
        if (sortable == null) {
            return null;
        }
        return new SortableBuilder().field(sortable.getField()).order(sortable.isAscOrder() ? Order.ASC : Order.DESC).build();
    }

    private Pageable buildPageable(io.gravitee.rest.api.model.common.Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        return new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build();
    }
}

