/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.cors;

import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.common.event.EventManager;
import io.gravitee.node.api.cache.Cache;
import io.gravitee.node.api.cache.CacheConfiguration;
import io.gravitee.node.plugin.cache.common.InMemoryCache;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.security.cors.GraviteeCorsConfiguration;
import io.gravitee.rest.api.service.ParameterService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public abstract class AbstractGraviteeUrlBasedCorsConfigurationSource
extends UrlBasedCorsConfigurationSource {
    private final Environment environment;
    private final ParameterService parameterService;
    private final InstallationAccessQueryService installationAccessQueryService;
    private final EventManager eventManager;
    private final ParameterReferenceType parameterReferenceType;
    private final Cache<String, CorsConfiguration> corsConfigurationByUrl;

    public AbstractGraviteeUrlBasedCorsConfigurationSource(Environment environment, ParameterService parameterService, InstallationAccessQueryService installationAccessQueryService, EventManager eventManager, ParameterReferenceType parameterReferenceType) {
        this.environment = environment;
        this.parameterService = parameterService;
        this.installationAccessQueryService = installationAccessQueryService;
        this.eventManager = eventManager;
        this.parameterReferenceType = parameterReferenceType;
        CacheConfiguration cacheConfiguration = CacheConfiguration.builder().maxSize((long)((Integer)environment.getProperty("cors.cache.max-size", Integer.class, (Object)1000)).intValue()).timeToLiveInMs(((Long)environment.getProperty("cors.cache.ttl", Long.class, (Object)60000L)).longValue()).build();
        this.corsConfigurationByUrl = new InMemoryCache("cors-config-by-url", cacheConfiguration);
    }

    public CorsConfiguration getCorsConfiguration(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String referenceId = this.getReferenceId();
        return (CorsConfiguration)this.corsConfigurationByUrl.computeIfAbsent((Object)this.extractUrl(request), id -> new GraviteeCorsConfiguration(this.environment, this.parameterService, this.installationAccessQueryService, this.eventManager, referenceId != null ? referenceId : "undefined", this.parameterReferenceType));
    }

    protected abstract String getReferenceId();

    private String extractUrl(HttpServletRequest request) {
        return this.extractUrlFromReferer(request).or(() -> this.extractUrlFromOrigin(request)).orElseGet(() -> this.extractUrlFromServer(request));
    }

    private Optional<String> extractUrlFromReferer(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Referer"));
    }

    private Optional<String> extractUrlFromOrigin(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Origin"));
    }

    private String extractUrlFromServer(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    }
}

