/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.filter;

import io.gravitee.apim.core.access_point.query_service.AccessPointQueryService;
import io.gravitee.apim.core.installation.domain_service.InstallationTypeDomainService;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.security.filter.error.ErrorHelper;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.ReferenceContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class GraviteeContextFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraviteeContextFilter.class);
    private static final String ERROR_MSG = "Invalid organization or environment";
    private static final String ORGANIZATIONS_PATH = "organizations";
    private static final String ENVIRONMENTS_PATH = "environments";
    private final InstallationTypeDomainService installationTypeDomainService;
    private final AccessPointQueryService accessPointQueryService;
    private final EnvironmentService environmentService;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("Initializing GraviteeContext from incoming request");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        ExecutionContext accessPointCxt = this.getFromAccessPoints(httpServletRequest);
        ExecutionContext pathCxt = this.getFromRequest(httpServletRequest);
        if (accessPointCxt != null || pathCxt.hasOrganizationId() || pathCxt.hasEnvironmentId()) {
            ExecutionContext resolvedCtx = accessPointCxt != null ? this.resolveFromAccessPoint(accessPointCxt, pathCxt) : this.resolveFromPath(pathCxt);
            if (resolvedCtx == null) {
                log.warn("No execution context resolved from the request %s".formatted(((HttpServletRequest)request).getPathInfo()));
                ErrorHelper.sendError(httpServletResponse, 400, ERROR_MSG);
                return;
            }
            GraviteeContext.fromExecutionContext((ExecutionContext)resolvedCtx);
            log.debug("GraviteeContext initialized from incoming request [context={}]", (Object)resolvedCtx);
        } else {
            GraviteeContext.fromExecutionContext((ExecutionContext)new ExecutionContext());
        }
        chain.doFilter(request, response);
    }

    @Nullable
    private ExecutionContext resolveFromPath(ExecutionContext pathExecutionContext) {
        if (pathExecutionContext.hasOrganizationId()) {
            String organizationId = pathExecutionContext.getOrganizationId();
            if (pathExecutionContext.hasEnvironmentId()) {
                try {
                    EnvironmentEntity environment = this.environmentService.findByOrgAndIdOrHrid(organizationId, pathExecutionContext.getEnvironmentId());
                    return new ExecutionContext(environment);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return new ExecutionContext(organizationId);
        }
        if (pathExecutionContext.hasEnvironmentId()) {
            try {
                EnvironmentEntity environment = this.environmentService.findById(pathExecutionContext.getEnvironmentId());
                return new ExecutionContext(environment);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private ExecutionContext resolveFromAccessPoint(ExecutionContext accessPointContext, ExecutionContext pathExecutionContext) {
        if (pathExecutionContext.hasOrganizationId() && !accessPointContext.getOrganizationId().equals(pathExecutionContext.getOrganizationId())) {
            return null;
        }
        if (pathExecutionContext.hasEnvironmentId()) {
            try {
                EnvironmentEntity environment = this.environmentService.findByOrgAndIdOrHrid(accessPointContext.getOrganizationId(), pathExecutionContext.getEnvironmentId());
                if (accessPointContext.hasEnvironmentId() && !accessPointContext.getEnvironmentId().equals(environment.getId())) {
                    return null;
                }
                return new ExecutionContext(environment);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (accessPointContext.hasEnvironmentId()) {
            return new ExecutionContext(accessPointContext.getOrganizationId(), accessPointContext.getEnvironmentId());
        }
        return new ExecutionContext(accessPointContext.getOrganizationId());
    }

    private ExecutionContext getFromAccessPoints(HttpServletRequest httpServletRequest) {
        Optional<ReferenceContext> optionalReferenceContext;
        ExecutionContext accessPointContext = null;
        if (this.installationTypeDomainService.isMultiTenant() && (optionalReferenceContext = this.getReferenceContextFromServer(httpServletRequest).or(() -> this.getReferenceContextFromReferer(httpServletRequest))).isPresent()) {
            ReferenceContext referenceContext = optionalReferenceContext.get();
            if (referenceContext.getReferenceType() == ReferenceContext.Type.ENVIRONMENT) {
                EnvironmentEntity environment = this.environmentService.findById(referenceContext.getReferenceId());
                accessPointContext = new ExecutionContext(environment);
            } else if (referenceContext.getReferenceType() == ReferenceContext.Type.ORGANIZATION) {
                accessPointContext = new ExecutionContext(referenceContext.getReferenceId());
            } else {
                throw new IllegalStateException(String.format("Unsupported reference type '%s'", referenceContext.getReferenceType()));
            }
        }
        return accessPointContext;
    }

    private Optional<ReferenceContext> getReferenceContextFromServer(HttpServletRequest httpServletRequest) {
        return this.getReferenceContext(httpServletRequest.getServerName(), httpServletRequest.getServerPort());
    }

    private Optional<? extends ReferenceContext> getReferenceContextFromReferer(HttpServletRequest httpServletRequest) {
        String refererHeaderValue = httpServletRequest.getHeader("Referer");
        if (refererHeaderValue != null) {
            try {
                URL refererUrl = new URL(refererHeaderValue);
                return this.getReferenceContext(refererUrl.getHost(), refererUrl.getPort());
            }
            catch (MalformedURLException e) {
                log.warn("Unable to retrieve access point from origin due to an error when reading header.");
            }
        }
        return Optional.empty();
    }

    @NonNull
    private Optional<ReferenceContext> getReferenceContext(String host, int port) {
        return this.accessPointQueryService.getReferenceContext(host).or(() -> this.accessPointQueryService.getReferenceContext(host + ":" + port));
    }

    private ExecutionContext getFromRequest(HttpServletRequest httpServletRequest) {
        String organizationId = null;
        String environmentId = null;
        String pathInfo = httpServletRequest.getPathInfo();
        String[] pathParams = pathInfo.split("/");
        int pathIndex = 0;
        while (pathIndex < pathParams.length && (organizationId == null || environmentId == null)) {
            String param = pathParams[pathIndex];
            if (ORGANIZATIONS_PATH.equals(param)) {
                if (++pathIndex >= pathParams.length) continue;
                organizationId = pathParams[pathIndex];
                continue;
            }
            if (ENVIRONMENTS_PATH.equals(param)) {
                if (++pathIndex >= pathParams.length) continue;
                environmentId = pathParams[pathIndex];
                continue;
            }
            ++pathIndex;
        }
        return new ExecutionContext(organizationId, environmentId);
    }

    @Generated
    public GraviteeContextFilter(InstallationTypeDomainService installationTypeDomainService, AccessPointQueryService accessPointQueryService, EnvironmentService environmentService) {
        this.installationTypeDomainService = installationTypeDomainService;
        this.accessPointQueryService = accessPointQueryService;
        this.environmentService = environmentService;
    }
}

