/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.cookies;

import jakarta.servlet.http.Cookie;
import org.springframework.core.env.Environment;

public class CookieGenerator {
    private static final String DEFAULT_JWT_COOKIE_PATH = "/";
    private static final String DEFAULT_JWT_COOKIE_DOMAIN = "";
    private final Environment environment;

    public CookieGenerator(Environment environment) {
        this.environment = environment;
    }

    public Cookie generate(String name, String value, boolean httpOnly) {
        boolean isJettySecured = (Boolean)this.environment.getProperty("jetty.secured", Boolean.class, (Object)Boolean.FALSE);
        Cookie cookie = new Cookie(name, value);
        cookie.setHttpOnly(httpOnly);
        cookie.setSecure(((Boolean)this.environment.getProperty("jwt.cookie-secure", Boolean.class, (Object)isJettySecured)).booleanValue());
        cookie.setPath(this.environment.getProperty("jwt.cookie-path", DEFAULT_JWT_COOKIE_PATH));
        cookie.setDomain(this.environment.getProperty("jwt.cookie-domain", DEFAULT_JWT_COOKIE_DOMAIN));
        cookie.setMaxAge(value == null ? 0 : (Integer)this.environment.getProperty("jwt.expire-after", Integer.class, (Object)604800));
        return cookie;
    }

    public Cookie generate(String name, String value) {
        return this.generate(name, value, true);
    }

    public Cookie generate(String value) {
        return this.generate("Auth-Graviteeio-APIM", value);
    }
}

