/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.filter;

import io.gravitee.rest.api.service.common.GraviteeContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.filter.GenericFilterBean;

public class ContextualLoggingFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextualLoggingFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String environment;
        MDC.clear();
        String organization = GraviteeContext.getCurrentOrganization();
        if (organization != null) {
            MDC.put((String)"orgId", (String)organization);
        }
        if ((environment = GraviteeContext.getCurrentEnvironment()) != null) {
            MDC.put((String)"envId", (String)environment);
        }
        log.debug("Contextual logging is on for organization: [{}] and environment: [{}]", (Object)organization, (Object)environment);
        filterChain.doFilter(request, response);
    }

    @Generated
    public ContextualLoggingFilter() {
    }
}

