/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.csrf;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

public class CookieCsrfSignedTokenRepository
implements InitializingBean,
CsrfTokenRepository {
    private final Logger LOGGER = LoggerFactory.getLogger(CookieCsrfSignedTokenRepository.class);
    public static final String TOKEN_CLAIM = "token";
    private static final String DEFAULT_CSRF_COOKIE_NAME = "XSRF-TOKEN";
    private static final String DEFAULT_CSRF_PARAMETER_NAME = "_csrf";
    public static final String DEFAULT_CSRF_HEADER_NAME = "X-Xsrf-Token";
    private static final String DEFAULT_JWT_ISSUER = "gravitee-management-auth";
    @Autowired
    private CookieGenerator cookieGenerator;
    @Value(value="${jwt.secret}")
    private String secret;
    @Value(value="${jwt.issuer:gravitee-management-auth}")
    private String issuer;
    private JWSSigner signer;
    private JWSVerifier verifier;

    public CsrfToken generateToken(HttpServletRequest request) {
        CsrfToken csrfToken = this.loadToken(request);
        if (csrfToken != null) {
            return csrfToken;
        }
        UUID token = UUID.randomUUID();
        return new DefaultCsrfToken(DEFAULT_CSRF_HEADER_NAME, DEFAULT_CSRF_PARAMETER_NAME, token.toString());
    }

    public void saveToken(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
        if (request.getAttribute(DEFAULT_CSRF_COOKIE_NAME) != null) {
            return;
        }
        if (token == null) {
            response.addCookie(this.cookieGenerator.generate(DEFAULT_CSRF_COOKIE_NAME, null));
            return;
        }
        String tokenValue = token.getToken();
        try {
            JWTClaimsSet claims = new JWTClaimsSet.Builder().issuer(this.issuer).issueTime(new Date()).claim(TOKEN_CLAIM, (Object)tokenValue).build();
            JWSObject jwsObject = new JWSObject(new JWSHeader(JWSAlgorithm.HS256), new Payload(claims.toJSONObject()));
            jwsObject.sign(this.signer);
            Cookie cookie = this.cookieGenerator.generate(DEFAULT_CSRF_COOKIE_NAME, jwsObject.serialize(), true);
            response.addCookie(cookie);
            request.setAttribute(DEFAULT_CSRF_COOKIE_NAME, (Object)true);
        }
        catch (JOSEException ex) {
            this.LOGGER.error("Unable to generate CSRF token", (Throwable)ex);
        }
    }

    public CsrfToken loadToken(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)DEFAULT_CSRF_COOKIE_NAME);
        if (cookie == null) {
            return null;
        }
        String cookieValue = cookie.getValue();
        if (!StringUtils.hasLength((String)cookieValue)) {
            return null;
        }
        try {
            JWSObject jws = JWSObject.parse((String)cookieValue);
            if (jws.verify(this.verifier)) {
                String token = jws.getPayload().toJSONObject().getAsString(TOKEN_CLAIM);
                if (!StringUtils.hasLength((String)token)) {
                    return null;
                }
                return new DefaultCsrfToken(DEFAULT_CSRF_HEADER_NAME, DEFAULT_CSRF_PARAMETER_NAME, token);
            }
        }
        catch (JOSEException | ParseException ex) {
            this.LOGGER.error("Unable to verify CSRF token", ex);
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        this.secret = org.apache.commons.lang3.StringUtils.leftPad((String)this.secret, (int)32, (char)'0');
        this.signer = new MACSigner(this.secret);
        this.verifier = new MACVerifier(this.secret);
    }
}

