/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.rest.filter;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.List;

@Provider
@PreMatching
public class UriBuilderRequestFilter
implements ContainerRequestFilter {
    private static final int NO_EXPLICIT_PORT = -1;

    public void filter(ContainerRequestContext ctx) throws IOException {
        UriBuilder baseBuilder = ctx.getUriInfo().getBaseUriBuilder();
        UriBuilder requestBuilder = ctx.getUriInfo().getRequestUriBuilder();
        this.processProtocolHeader(ctx, baseBuilder, requestBuilder);
        this.processHostHeader(ctx, baseBuilder, requestBuilder);
        this.processPortHeader(ctx, baseBuilder, requestBuilder);
    }

    private void processProtocolHeader(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder) {
        String protoHeaderValue = this.getFirstHeaderValueOrNull(ctx, "X-Forwarded-Proto");
        if (protoHeaderValue != null) {
            baseBuilder.scheme(protoHeaderValue);
            requestBuilder.scheme(protoHeaderValue);
            ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
        }
    }

    private void processHostHeader(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder) {
        String hostHeaderValue = this.getFirstHeaderValueOrNull(ctx, "X-Forwarded-Host");
        if (hostHeaderValue != null) {
            String[] hosts = hostHeaderValue.split(",");
            String effectiveHost = hosts[hosts.length - 1].trim();
            if (effectiveHost.contains(":")) {
                int lastColonIdx = effectiveHost.lastIndexOf(58);
                String host = effectiveHost.substring(0, lastColonIdx);
                int port = Integer.parseInt(effectiveHost.substring(lastColonIdx + 1));
                baseBuilder.host(host).port(port);
                requestBuilder.host(host).port(port);
            } else {
                baseBuilder.host(effectiveHost).port(-1);
                requestBuilder.host(effectiveHost).port(-1);
            }
            ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
        }
    }

    private void processPortHeader(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder) {
        String portHeaderValue = this.getFirstHeaderValueOrNull(ctx, "X-Forwarded-Port");
        if (portHeaderValue != null) {
            int port = Integer.parseInt(portHeaderValue);
            baseBuilder.port(port);
            requestBuilder.port(port);
            ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
        }
    }

    private String getFirstHeaderValueOrNull(ContainerRequestContext ctx, String headerName) {
        List headerValues = (List)ctx.getHeaders().get((Object)headerName);
        if (headerValues != null && !headerValues.isEmpty()) {
            return (String)headerValues.get(0);
        }
        return null;
    }
}

