/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.rest.filter;

import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@Provider
@Priority(value=200)
public class PermissionsFilter
implements ContainerRequestFilter {
    private static final String GROUP_ID_PARAM_V2 = "groupId";
    private static final String API_ID_PARAM_V2 = "apiId";
    private static final String APPLICATION_ID_PARAM_V2 = "applicationId";
    private static final String GROUP_ID_PARAM_V1 = "group";
    private static final String API_ID_PARAM_V1 = "api";
    private static final String APPLICATION_ID_PARAM_V1 = "application";
    private static final String INTEGRATION_ID_PARAM = "integrationId";
    @Context
    protected ResourceInfo resourceInfo;
    @Inject
    private SecurityContext securityContext;
    @Inject
    private PermissionService permissionService;

    public void filter(ContainerRequestContext requestContext) {
        this.findRequiredPermissions().ifPresent(requiredPermissions -> {
            this.mustBeAuthenticated();
            this.filter((Permissions)requiredPermissions, requestContext, GraviteeContext.getExecutionContext());
        });
    }

    protected void filter(Permissions permissions, ContainerRequestContext requestContext, ExecutionContext executionContext) {
        Stream.of(permissions.value()).filter((? super T permission) -> this.hasPermission((Permission)permission, requestContext, executionContext)).findAny().orElseThrow(ForbiddenAccessException::new);
    }

    private boolean hasPermission(Permission permission, ContainerRequestContext requestContext, ExecutionContext executionContext) {
        return switch (permission.value().getScope()) {
            default -> throw new MatchException(null, null);
            case RoleScope.ORGANIZATION -> this.hasPermission(executionContext, permission, executionContext.getOrganizationId());
            case RoleScope.ENVIRONMENT -> {
                if (executionContext.hasEnvironmentId() && this.hasPermission(executionContext, permission, executionContext.getEnvironmentId())) {
                    yield true;
                }
                yield false;
            }
            case RoleScope.APPLICATION -> this.hasPermission(executionContext, permission, this.getApplicationId(requestContext));
            case RoleScope.API -> this.hasPermission(executionContext, permission, this.getApiId(requestContext));
            case RoleScope.GROUP -> this.hasPermission(executionContext, permission, this.getGroupId(requestContext));
            case RoleScope.INTEGRATION -> this.hasPermission(executionContext, permission, this.getId(INTEGRATION_ID_PARAM, requestContext));
            case RoleScope.PLATFORM -> false;
        };
    }

    private boolean hasPermission(ExecutionContext executionContext, Permission permission, String referenceId) {
        return this.permissionService.hasPermission(executionContext, permission.value(), referenceId, permission.acls());
    }

    private String getGroupId(ContainerRequestContext requestContext) {
        String groupId = this.getId(GROUP_ID_PARAM_V1, requestContext);
        return groupId == null ? this.getId(GROUP_ID_PARAM_V2, requestContext) : groupId;
    }

    private String getApiId(ContainerRequestContext requestContext) {
        String apiId = this.getId(API_ID_PARAM_V1, requestContext);
        return apiId == null ? this.getId(API_ID_PARAM_V2, requestContext) : apiId;
    }

    private String getApplicationId(ContainerRequestContext requestContext) {
        String applicationId = this.getId(APPLICATION_ID_PARAM_V1, requestContext);
        return applicationId == null ? this.getId(APPLICATION_ID_PARAM_V2, requestContext) : applicationId;
    }

    private String getId(String key, ContainerRequestContext requestContext) {
        List pathParams = (List)requestContext.getUriInfo().getPathParameters().get((Object)key);
        if (pathParams != null) {
            return (String)pathParams.iterator().next();
        }
        List queryParams = (List)requestContext.getUriInfo().getQueryParameters().get((Object)key);
        if (queryParams != null) {
            return (String)queryParams.iterator().next();
        }
        return null;
    }

    private Optional<Permissions> findRequiredPermissions() {
        return Optional.ofNullable(this.resourceInfo.getResourceMethod().getDeclaredAnnotation(Permissions.class)).or(() -> Optional.ofNullable(this.resourceInfo.getResourceClass().getDeclaredAnnotation(Permissions.class)));
    }

    private void mustBeAuthenticated() {
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal == null) {
            throw new UnauthorizedAccessException();
        }
    }
}

