/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.RollbackApiEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RollbackApiEntityDeserializer
extends StdDeserializer<RollbackApiEntity> {
    public RollbackApiEntityDeserializer() {
        super(RollbackApiEntity.class);
    }

    public RollbackApiEntity deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        if (RollbackApiEntityDeserializer.isV4(RollbackApiEntityDeserializer.text(node.get("definitionVersion")))) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Detected a v4 API definition. Please use the migration tool instead of rollback.");
        }
        RollbackApiEntityRaw raw = (RollbackApiEntityRaw)mapper.treeToValue((TreeNode)node, RollbackApiEntityRaw.class);
        return RollbackApiEntityDeserializer.toEntity(raw);
    }

    private static RollbackApiEntity toEntity(RollbackApiEntityRaw p) {
        RollbackApiEntity out = new RollbackApiEntity();
        out.setId(p.id);
        out.setName(p.name);
        out.setVersion(p.version);
        out.setDescription(p.description);
        out.setProxy(p.proxy);
        out.setPaths(RollbackApiEntityDeserializer.nullableOr(p.paths, new HashMap()));
        out.setFlows(RollbackApiEntityDeserializer.nullableOr(p.flows, new ArrayList()));
        out.setPlans(RollbackApiEntityDeserializer.nullableOr(p.plans, new ArrayList()));
        out.setServices(p.services);
        out.setResources(RollbackApiEntityDeserializer.nullableOr(p.resources, new ArrayList()));
        if (p.propertiesList != null) {
            Properties props = new Properties();
            props.setProperties(p.propertiesList);
            out.setProperties(props);
        }
        out.setVisibility(p.visibility);
        out.setTags(p.tags);
        out.setPicture(p.picture);
        out.setGraviteeDefinitionVersion(p.graviteeDefinitionVersion);
        out.setFlowMode(p.flowMode);
        out.setPictureUrl(p.pictureUrl);
        out.setCategories(p.categories);
        out.setLabels(p.labels);
        out.setGroups(p.groups);
        out.setPathMappings(p.pathMappings);
        out.setExecutionMode(p.executionMode);
        out.setResponseTemplates(p.responseTemplates);
        out.setMetadata(p.metadata);
        out.setLifecycleState(p.lifecycleState);
        out.setDisableMembershipNotifications(p.disableMembershipNotifications);
        out.setBackground(p.background);
        out.setBackgroundUrl(p.backgroundUrl);
        return out;
    }

    private static String text(JsonNode n) {
        return n != null && n.isTextual() ? n.asText() : null;
    }

    private static boolean isV4(String v) {
        if (v == null) {
            return false;
        }
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (!Character.isDigit(c)) continue;
            return c == '4';
        }
        return false;
    }

    private static <T> T nullableOr(T value, T fallback) {
        return value != null ? value : fallback;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class RollbackApiEntityRaw {
        public String id;
        public String name;
        public String version;
        public String description;
        public Proxy proxy;
        public Map<String, List<Rule>> paths;
        public List<Flow> flows;
        public List<Plan> plans;
        public Services services;
        public List<Resource> resources;
        @JsonProperty(value="properties")
        public List<Property> propertiesList;
        public Visibility visibility;
        public Set<String> tags;
        public String picture;
        @JsonProperty(value="gravitee")
        public String graviteeDefinitionVersion;
        @JsonProperty(value="flow_mode")
        public FlowMode flowMode;
        @JsonProperty(value="picture_url")
        public String pictureUrl;
        @JsonProperty(value="categories")
        public Set<String> categories;
        public List<String> labels;
        public Set<String> groups;
        @JsonProperty(value="path_mappings")
        public Set<String> pathMappings;
        @JsonProperty(value="execution_mode")
        public ExecutionMode executionMode;
        @JsonProperty(value="response_templates")
        public Map<String, Map<String, ResponseTemplate>> responseTemplates;
        public List<ApiMetadataEntity> metadata;
        @JsonProperty(value="lifecycle_state")
        public ApiLifecycleState lifecycleState;
        @JsonProperty(value="disable_membership_notifications")
        public boolean disableMembershipNotifications;
        public String background;
        @JsonProperty(value="background_url")
        public String backgroundUrl;

        RollbackApiEntityRaw() {
        }
    }
}

