/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.rest.api.model.PropertyEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesEntityAsListDeserializer
extends StdScalarDeserializer<List<PropertyEntity>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertiesEntityAsListDeserializer.class);

    public PropertiesEntityAsListDeserializer() {
        super(List.class);
    }

    public List<PropertyEntity> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        ArrayList<PropertyEntity> properties = new ArrayList<PropertyEntity>();
        if (node.isArray()) {
            node.elements().forEachRemaining(jsonNode -> {
                try {
                    PropertyEntity property = (PropertyEntity)((Object)((Object)jsonNode.traverse(jp.getCodec()).readValueAs(PropertyEntity.class)));
                    properties.add(property);
                }
                catch (IOException e) {
                    log.error("Error while deserializing API's properties list", (Throwable)e);
                }
            });
        } else if (node.isObject()) {
            node.fields().forEachRemaining(jsonNode -> properties.add(new PropertyEntity((String)jsonNode.getKey(), ((JsonNode)jsonNode.getValue()).asText())));
        }
        return properties;
    }
}

