/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.notification;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Origin;
import io.gravitee.rest.api.model.notification.NotificationConfigType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class PortalNotificationConfigEntity {
    @JsonProperty(value="config_type")
    private NotificationConfigType configType;
    @JsonProperty(value="name")
    private String name = "Console Notification";
    private String referenceType;
    private String referenceId;
    private String user;
    private List<String> hooks;
    private List<String> groups;
    private Origin origin;
    private String organizationId;

    public PortalNotificationConfigEntity() {
        this.origin = Origin.MANAGEMENT;
    }

    public boolean isDefaultEmpty() {
        return !(this.hooks != null && !this.hooks.isEmpty() || this.groups != null && !this.groups.isEmpty() || this.user == null || this.user.isEmpty() || this.referenceType == null || this.referenceType.isEmpty() || this.referenceId == null || this.referenceId.isEmpty() || this.organizationId == null || this.organizationId.isEmpty());
    }

    public static PortalNotificationConfigEntity newDefaultEmpty(String user, String referenceType, String referenceId, String organizationId) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("User must not be empty");
        }
        if (referenceType == null || referenceType.isEmpty()) {
            throw new IllegalArgumentException("ReferenceType must not be empty");
        }
        if (referenceId == null || referenceId.isEmpty()) {
            throw new IllegalArgumentException("ReferenceId must not be empty");
        }
        if (organizationId == null || organizationId.isEmpty()) {
            throw new IllegalArgumentException("organizationId must not be empty");
        }
        PortalNotificationConfigEntity entity = new PortalNotificationConfigEntity();
        entity.setConfigType(NotificationConfigType.PORTAL);
        entity.setReferenceType(referenceType);
        entity.setReferenceId(referenceId);
        entity.setUser(user);
        entity.setHooks(Collections.emptyList());
        entity.setGroups(Collections.emptyList());
        entity.setOrganizationId(organizationId);
        return entity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PortalNotificationConfigEntity)) {
            return false;
        }
        PortalNotificationConfigEntity that = (PortalNotificationConfigEntity)o;
        return Objects.equals(this.referenceType, that.referenceType) && Objects.equals(this.referenceId, that.referenceId) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    @Generated
    public static PortalNotificationConfigEntityBuilder builder() {
        return new PortalNotificationConfigEntityBuilder();
    }

    @Generated
    public NotificationConfigType getConfigType() {
        return this.configType;
    }

    @Generated
    public String getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public List<String> getHooks() {
        return this.hooks;
    }

    @Generated
    public List<String> getGroups() {
        return this.groups;
    }

    @Generated
    public Origin getOrigin() {
        return this.origin;
    }

    @Generated
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="config_type")
    @Generated
    public void setConfigType(NotificationConfigType configType) {
        this.configType = configType;
    }

    @Generated
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setHooks(List<String> hooks) {
        this.hooks = hooks;
    }

    @Generated
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    @Generated
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public PortalNotificationConfigEntity(NotificationConfigType configType, String name, String referenceType, String referenceId, String user, List<String> hooks, List<String> groups, Origin origin, String organizationId) {
        this.configType = configType;
        this.name = name;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
        this.user = user;
        this.hooks = hooks;
        this.groups = groups;
        this.origin = origin;
        this.organizationId = organizationId;
    }

    @Generated
    public String toString() {
        return "PortalNotificationConfigEntity(configType=" + String.valueOf((Object)this.getConfigType()) + ", name=" + this.name + ", referenceType=" + this.getReferenceType() + ", referenceId=" + this.getReferenceId() + ", user=" + this.getUser() + ", hooks=" + String.valueOf(this.getHooks()) + ", groups=" + String.valueOf(this.getGroups()) + ", origin=" + String.valueOf(this.getOrigin()) + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @Generated
    public static class PortalNotificationConfigEntityBuilder {
        @Generated
        private NotificationConfigType configType;
        @Generated
        private String name;
        @Generated
        private String referenceType;
        @Generated
        private String referenceId;
        @Generated
        private String user;
        @Generated
        private List<String> hooks;
        @Generated
        private List<String> groups;
        @Generated
        private Origin origin;
        @Generated
        private String organizationId;

        @Generated
        PortalNotificationConfigEntityBuilder() {
        }

        @JsonProperty(value="config_type")
        @Generated
        public PortalNotificationConfigEntityBuilder configType(NotificationConfigType configType) {
            this.configType = configType;
            return this;
        }

        @JsonProperty(value="name")
        @Generated
        public PortalNotificationConfigEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntityBuilder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntityBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntityBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntityBuilder hooks(List<String> hooks) {
            this.hooks = hooks;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntityBuilder groups(List<String> groups) {
            this.groups = groups;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntityBuilder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntityBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public PortalNotificationConfigEntity build() {
            return new PortalNotificationConfigEntity(this.configType, this.name, this.referenceType, this.referenceId, this.user, this.hooks, this.groups, this.origin, this.organizationId);
        }

        @Generated
        public String toString() {
            return "PortalNotificationConfigEntity.PortalNotificationConfigEntityBuilder(configType=" + String.valueOf((Object)this.configType) + ", name=" + this.name + ", referenceType=" + this.referenceType + ", referenceId=" + this.referenceId + ", user=" + this.user + ", hooks=" + String.valueOf(this.hooks) + ", groups=" + String.valueOf(this.groups) + ", origin=" + String.valueOf(this.origin) + ", organizationId=" + this.organizationId + ")";
        }
    }
}

