/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.nativeapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativeApiServices;
import io.gravitee.definition.model.v4.nativeapi.NativeEndpointGroup;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.definition.model.v4.nativeapi.NativeListener;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@Schema(name="NativeApiEntityV4")
public class NativeApiEntity
implements GenericApiEntity {
    @Schema(description="API's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="API's crossId. Identifies API across environments.", example="df83b2a4-cc3e-3f80-9f0d-c138c106c076")
    private String crossId;
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private String name;
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String apiVersion;
    @Schema(description="API's gravitee definition version")
    private DefinitionVersion definitionVersion;
    @Schema(description="API's type", defaultValue="NATIVE")
    private ApiType type;
    @Schema(description="The last date (as timestamp) when the API was deployed.", example="1581256457163")
    private Date deployedAt;
    @Schema(description="The date (as a timestamp) when the API was created.", example="1581256457163")
    private Date createdAt;
    @Schema(description="The last date (as a timestamp) when the API was updated.", example="1581256457163")
    private Date updatedAt;
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="The list of sharding tags associated with this API.", example="public, private")
    @DeploymentRequired
    private Set<String> tags;
    @Schema(description="A list of listeners used to describe our you api could be reached.")
    @DeploymentRequired
    private List<NativeListener> listeners;
    @Schema(description="A list of endpoint describing the endpoints to contact.")
    @DeploymentRequired
    private List<NativeEndpointGroup> endpointGroups;
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    @DeploymentRequired
    private List<Property> properties;
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    @DeploymentRequired
    private List<Resource> resources;
    @Schema(description="A list of plans to apply on the API")
    @DeploymentRequired
    private Set<NativePlanEntity> plans;
    @Schema(description="A list of flows containing the policies configuration.")
    @DeploymentRequired
    private List<NativeFlow> flows;
    @DeploymentRequired
    @Schema(description="The configuration of API services like the dynamic properties.")
    private NativeApiServices services;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility;
    @Schema(description="The status of the API regarding the gateway.", example="STARTED")
    private Lifecycle.State state;
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @Schema(description="the API logo URL.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/picture")
    private String pictureUrl;
    @Schema(description="the list of categories associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    private OriginContext originContext;
    @JsonIgnore
    private Map<String, Object> metadata;
    private ApiLifecycleState lifecycleState;
    private WorkflowState workflowState;
    private boolean disableMembershipNotifications;
    @Schema(description="the API background encoded in base64")
    private String background;
    @Schema(description="the API background url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/background")
    private String backgroundUrl;
    @JsonIgnore
    private String referenceType;
    @JsonIgnore
    private String referenceId;

    @Generated
    private static ApiType $default$type() {
        return ApiType.NATIVE;
    }

    @Generated
    private static Set<String> $default$tags() {
        return new HashSet<String>();
    }

    @Generated
    private static List<Property> $default$properties() {
        return new ArrayList<Property>();
    }

    @Generated
    private static List<Resource> $default$resources() {
        return new ArrayList<Resource>();
    }

    @Generated
    private static Set<NativePlanEntity> $default$plans() {
        return new HashSet<NativePlanEntity>();
    }

    @Generated
    private static Lifecycle.State $default$state() {
        return Lifecycle.State.STOPPED;
    }

    @Generated
    private static OriginContext $default$originContext() {
        return new OriginContext.Management();
    }

    @Generated
    private static Map<String, Object> $default$metadata() {
        return new HashMap<String, Object>();
    }

    @Generated
    public static NativeApiEntityBuilder builder() {
        return new NativeApiEntityBuilder();
    }

    @Generated
    public NativeApiEntityBuilder toBuilder() {
        return new NativeApiEntityBuilder().id(this.id).crossId(this.crossId).name(this.name).apiVersion(this.apiVersion).definitionVersion(this.definitionVersion).type(this.type).deployedAt(this.deployedAt).createdAt(this.createdAt).updatedAt(this.updatedAt).description(this.description).tags(this.tags).listeners(this.listeners).endpointGroups(this.endpointGroups).properties(this.properties).resources(this.resources).plans(this.plans).flows(this.flows).services(this.services).groups(this.groups).visibility(this.visibility).state(this.state).primaryOwner(this.primaryOwner).picture(this.picture).pictureUrl(this.pictureUrl).categories(this.categories).labels(this.labels).originContext(this.originContext).metadata(this.metadata).lifecycleState(this.lifecycleState).workflowState(this.workflowState).disableMembershipNotifications(this.disableMembershipNotifications).background(this.background).backgroundUrl(this.backgroundUrl).referenceType(this.referenceType).referenceId(this.referenceId);
    }

    @Generated
    public NativeApiEntity() {
        this.type = NativeApiEntity.$default$type();
        this.tags = NativeApiEntity.$default$tags();
        this.properties = NativeApiEntity.$default$properties();
        this.resources = NativeApiEntity.$default$resources();
        this.plans = NativeApiEntity.$default$plans();
        this.state = NativeApiEntity.$default$state();
        this.originContext = NativeApiEntity.$default$originContext();
        this.metadata = NativeApiEntity.$default$metadata();
    }

    @Generated
    public NativeApiEntity(String id, String crossId, String name, String apiVersion, DefinitionVersion definitionVersion, ApiType type, Date deployedAt, Date createdAt, Date updatedAt, String description, Set<String> tags, List<NativeListener> listeners, List<NativeEndpointGroup> endpointGroups, List<Property> properties, List<Resource> resources, Set<NativePlanEntity> plans, List<NativeFlow> flows, NativeApiServices services, Set<String> groups, Visibility visibility, Lifecycle.State state, PrimaryOwnerEntity primaryOwner, String picture, String pictureUrl, Set<String> categories, List<String> labels, OriginContext originContext, Map<String, Object> metadata, ApiLifecycleState lifecycleState, WorkflowState workflowState, boolean disableMembershipNotifications, String background, String backgroundUrl, String referenceType, String referenceId) {
        this.id = id;
        this.crossId = crossId;
        this.name = name;
        this.apiVersion = apiVersion;
        this.definitionVersion = definitionVersion;
        this.type = type;
        this.deployedAt = deployedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.description = description;
        this.tags = tags;
        this.listeners = listeners;
        this.endpointGroups = endpointGroups;
        this.properties = properties;
        this.resources = resources;
        this.plans = plans;
        this.flows = flows;
        this.services = services;
        this.groups = groups;
        this.visibility = visibility;
        this.state = state;
        this.primaryOwner = primaryOwner;
        this.picture = picture;
        this.pictureUrl = pictureUrl;
        this.categories = categories;
        this.labels = labels;
        this.originContext = originContext;
        this.metadata = metadata;
        this.lifecycleState = lifecycleState;
        this.workflowState = workflowState;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.background = background;
        this.backgroundUrl = backgroundUrl;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Override
    @Generated
    public Date getDeployedAt() {
        return this.deployedAt;
    }

    @Override
    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<NativeListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<NativeEndpointGroup> getEndpointGroups() {
        return this.endpointGroups;
    }

    @Generated
    public List<Property> getProperties() {
        return this.properties;
    }

    @Generated
    public List<Resource> getResources() {
        return this.resources;
    }

    @Generated
    public Set<NativePlanEntity> getPlans() {
        return this.plans;
    }

    @Generated
    public List<NativeFlow> getFlows() {
        return this.flows;
    }

    @Generated
    public NativeApiServices getServices() {
        return this.services;
    }

    @Override
    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    @Generated
    public Lifecycle.State getState() {
        return this.state;
    }

    @Override
    @Generated
    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    @Override
    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Override
    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    @Generated
    public OriginContext getOriginContext() {
        return this.originContext;
    }

    @Override
    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @Generated
    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Override
    @Generated
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    @Override
    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Override
    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    @Override
    @Generated
    public String getReferenceType() {
        return this.referenceType;
    }

    @Override
    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setType(ApiType type) {
        this.type = type;
    }

    @Generated
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setListeners(List<NativeListener> listeners) {
        this.listeners = listeners;
    }

    @Generated
    public void setEndpointGroups(List<NativeEndpointGroup> endpointGroups) {
        this.endpointGroups = endpointGroups;
    }

    @Generated
    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @Generated
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public void setPlans(Set<NativePlanEntity> plans) {
        this.plans = plans;
    }

    @Generated
    public void setFlows(List<NativeFlow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setServices(NativeApiServices services) {
        this.services = services;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setState(Lifecycle.State state) {
        this.state = state;
    }

    @Generated
    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Generated
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setOriginContext(OriginContext originContext) {
        this.originContext = originContext;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public void setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public String toString() {
        return "NativeApiEntity(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", apiVersion=" + this.getApiVersion() + ", definitionVersion=" + this.getDefinitionVersion() + ", type=" + this.getType() + ", deployedAt=" + this.getDeployedAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", listeners=" + this.getListeners() + ", endpointGroups=" + this.getEndpointGroups() + ", properties=" + this.getProperties() + ", resources=" + this.getResources() + ", plans=" + this.getPlans() + ", flows=" + this.getFlows() + ", services=" + this.getServices() + ", groups=" + this.getGroups() + ", visibility=" + this.getVisibility() + ", state=" + this.getState() + ", primaryOwner=" + this.getPrimaryOwner() + ", picture=" + this.getPicture() + ", pictureUrl=" + this.getPictureUrl() + ", categories=" + this.getCategories() + ", labels=" + this.getLabels() + ", originContext=" + this.getOriginContext() + ", metadata=" + this.getMetadata() + ", lifecycleState=" + this.getLifecycleState() + ", workflowState=" + this.getWorkflowState() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", background=" + this.getBackground() + ", backgroundUrl=" + this.getBackgroundUrl() + ", referenceType=" + this.getReferenceType() + ", referenceId=" + this.getReferenceId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NativeApiEntity)) {
            return false;
        }
        NativeApiEntity other = (NativeApiEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisableMembershipNotifications() != other.isDisableMembershipNotifications()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        DefinitionVersion this$definitionVersion = this.getDefinitionVersion();
        DefinitionVersion other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !this$definitionVersion.equals(other$definitionVersion)) {
            return false;
        }
        ApiType this$type = this.getType();
        ApiType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$deployedAt = this.getDeployedAt();
        Date other$deployedAt = other.getDeployedAt();
        if (this$deployedAt == null ? other$deployedAt != null : !((Object)this$deployedAt).equals(other$deployedAt)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<NativeListener> this$listeners = this.getListeners();
        List<NativeListener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<NativeEndpointGroup> this$endpointGroups = this.getEndpointGroups();
        List<NativeEndpointGroup> other$endpointGroups = other.getEndpointGroups();
        if (this$endpointGroups == null ? other$endpointGroups != null : !((Object)this$endpointGroups).equals(other$endpointGroups)) {
            return false;
        }
        List<Property> this$properties = this.getProperties();
        List<Property> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<Resource> this$resources = this.getResources();
        List<Resource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Set<NativePlanEntity> this$plans = this.getPlans();
        Set<NativePlanEntity> other$plans = other.getPlans();
        if (this$plans == null ? other$plans != null : !((Object)this$plans).equals(other$plans)) {
            return false;
        }
        List<NativeFlow> this$flows = this.getFlows();
        List<NativeFlow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        NativeApiServices this$services = this.getServices();
        NativeApiServices other$services = other.getServices();
        if (this$services == null ? other$services != null : !this$services.equals(other$services)) {
            return false;
        }
        Set<String> this$groups = this.getGroups();
        Set<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        Visibility this$visibility = this.getVisibility();
        Visibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility)) {
            return false;
        }
        Lifecycle.State this$state = this.getState();
        Lifecycle.State other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        PrimaryOwnerEntity this$primaryOwner = this.getPrimaryOwner();
        PrimaryOwnerEntity other$primaryOwner = other.getPrimaryOwner();
        if (this$primaryOwner == null ? other$primaryOwner != null : !((Object)this$primaryOwner).equals(other$primaryOwner)) {
            return false;
        }
        String this$picture = this.getPicture();
        String other$picture = other.getPicture();
        if (this$picture == null ? other$picture != null : !this$picture.equals(other$picture)) {
            return false;
        }
        String this$pictureUrl = this.getPictureUrl();
        String other$pictureUrl = other.getPictureUrl();
        if (this$pictureUrl == null ? other$pictureUrl != null : !this$pictureUrl.equals(other$pictureUrl)) {
            return false;
        }
        Set<String> this$categories = this.getCategories();
        Set<String> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        OriginContext this$originContext = this.getOriginContext();
        OriginContext other$originContext = other.getOriginContext();
        if (this$originContext == null ? other$originContext != null : !this$originContext.equals(other$originContext)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ApiLifecycleState this$lifecycleState = this.getLifecycleState();
        ApiLifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        WorkflowState this$workflowState = this.getWorkflowState();
        WorkflowState other$workflowState = other.getWorkflowState();
        if (this$workflowState == null ? other$workflowState != null : !((Object)((Object)this$workflowState)).equals((Object)other$workflowState)) {
            return false;
        }
        String this$background = this.getBackground();
        String other$background = other.getBackground();
        if (this$background == null ? other$background != null : !this$background.equals(other$background)) {
            return false;
        }
        String this$backgroundUrl = this.getBackgroundUrl();
        String other$backgroundUrl = other.getBackgroundUrl();
        if (this$backgroundUrl == null ? other$backgroundUrl != null : !this$backgroundUrl.equals(other$backgroundUrl)) {
            return false;
        }
        String this$referenceType = this.getReferenceType();
        String other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        return !(this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NativeApiEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisableMembershipNotifications() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        DefinitionVersion $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : $definitionVersion.hashCode());
        ApiType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $deployedAt = this.getDeployedAt();
        result = result * 59 + ($deployedAt == null ? 43 : ((Object)$deployedAt).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<NativeListener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<NativeEndpointGroup> $endpointGroups = this.getEndpointGroups();
        result = result * 59 + ($endpointGroups == null ? 43 : ((Object)$endpointGroups).hashCode());
        List<Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<Resource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Set<NativePlanEntity> $plans = this.getPlans();
        result = result * 59 + ($plans == null ? 43 : ((Object)$plans).hashCode());
        List<NativeFlow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        NativeApiServices $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : $services.hashCode());
        Set<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        Visibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        Lifecycle.State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        PrimaryOwnerEntity $primaryOwner = this.getPrimaryOwner();
        result = result * 59 + ($primaryOwner == null ? 43 : ((Object)$primaryOwner).hashCode());
        String $picture = this.getPicture();
        result = result * 59 + ($picture == null ? 43 : $picture.hashCode());
        String $pictureUrl = this.getPictureUrl();
        result = result * 59 + ($pictureUrl == null ? 43 : $pictureUrl.hashCode());
        Set<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        OriginContext $originContext = this.getOriginContext();
        result = result * 59 + ($originContext == null ? 43 : $originContext.hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ApiLifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        WorkflowState $workflowState = this.getWorkflowState();
        result = result * 59 + ($workflowState == null ? 43 : ((Object)((Object)$workflowState)).hashCode());
        String $background = this.getBackground();
        result = result * 59 + ($background == null ? 43 : $background.hashCode());
        String $backgroundUrl = this.getBackgroundUrl();
        result = result * 59 + ($backgroundUrl == null ? 43 : $backgroundUrl.hashCode());
        String $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        return result;
    }

    @Generated
    public NativeApiEntity withId(String id) {
        return this.id == id ? this : new NativeApiEntity(id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withCrossId(String crossId) {
        return this.crossId == crossId ? this : new NativeApiEntity(this.id, crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withName(String name) {
        return this.name == name ? this : new NativeApiEntity(this.id, this.crossId, name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withApiVersion(String apiVersion) {
        return this.apiVersion == apiVersion ? this : new NativeApiEntity(this.id, this.crossId, this.name, apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withDefinitionVersion(DefinitionVersion definitionVersion) {
        return this.definitionVersion == definitionVersion ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withType(ApiType type) {
        return this.type == type ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withDeployedAt(Date deployedAt) {
        return this.deployedAt == deployedAt ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withCreatedAt(Date createdAt) {
        return this.createdAt == createdAt ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withUpdatedAt(Date updatedAt) {
        return this.updatedAt == updatedAt ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withDescription(String description) {
        return this.description == description ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withTags(Set<String> tags) {
        return this.tags == tags ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withListeners(List<NativeListener> listeners) {
        return this.listeners == listeners ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withEndpointGroups(List<NativeEndpointGroup> endpointGroups) {
        return this.endpointGroups == endpointGroups ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withProperties(List<Property> properties) {
        return this.properties == properties ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withResources(List<Resource> resources) {
        return this.resources == resources ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withPlans(Set<NativePlanEntity> plans) {
        return this.plans == plans ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withFlows(List<NativeFlow> flows) {
        return this.flows == flows ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withServices(NativeApiServices services) {
        return this.services == services ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withGroups(Set<String> groups) {
        return this.groups == groups ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withVisibility(Visibility visibility) {
        return this.visibility == visibility ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withState(Lifecycle.State state) {
        return this.state == state ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        return this.primaryOwner == primaryOwner ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withPicture(String picture) {
        return this.picture == picture ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withPictureUrl(String pictureUrl) {
        return this.pictureUrl == pictureUrl ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withCategories(Set<String> categories) {
        return this.categories == categories ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withLabels(List<String> labels) {
        return this.labels == labels ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withOriginContext(OriginContext originContext) {
        return this.originContext == originContext ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withMetadata(Map<String, Object> metadata) {
        return this.metadata == metadata ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withLifecycleState(ApiLifecycleState lifecycleState) {
        return this.lifecycleState == lifecycleState ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withWorkflowState(WorkflowState workflowState) {
        return this.workflowState == workflowState ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withDisableMembershipNotifications(boolean disableMembershipNotifications) {
        return this.disableMembershipNotifications == disableMembershipNotifications ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withBackground(String background) {
        return this.background == background ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, background, this.backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withBackgroundUrl(String backgroundUrl) {
        return this.backgroundUrl == backgroundUrl ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, backgroundUrl, this.referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withReferenceType(String referenceType) {
        return this.referenceType == referenceType ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, referenceType, this.referenceId);
    }

    @Generated
    public NativeApiEntity withReferenceId(String referenceId) {
        return this.referenceId == referenceId ? this : new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.description, this.tags, this.listeners, this.endpointGroups, this.properties, this.resources, this.plans, this.flows, this.services, this.groups, this.visibility, this.state, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, this.originContext, this.metadata, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, referenceId);
    }

    @Generated
    public static class NativeApiEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String apiVersion;
        @Generated
        private DefinitionVersion definitionVersion;
        @Generated
        private boolean type$set;
        @Generated
        private ApiType type$value;
        @Generated
        private Date deployedAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private String description;
        @Generated
        private boolean tags$set;
        @Generated
        private Set<String> tags$value;
        @Generated
        private List<NativeListener> listeners;
        @Generated
        private List<NativeEndpointGroup> endpointGroups;
        @Generated
        private boolean properties$set;
        @Generated
        private List<Property> properties$value;
        @Generated
        private boolean resources$set;
        @Generated
        private List<Resource> resources$value;
        @Generated
        private boolean plans$set;
        @Generated
        private Set<NativePlanEntity> plans$value;
        @Generated
        private List<NativeFlow> flows;
        @Generated
        private NativeApiServices services;
        @Generated
        private Set<String> groups;
        @Generated
        private Visibility visibility;
        @Generated
        private boolean state$set;
        @Generated
        private Lifecycle.State state$value;
        @Generated
        private PrimaryOwnerEntity primaryOwner;
        @Generated
        private String picture;
        @Generated
        private String pictureUrl;
        @Generated
        private Set<String> categories;
        @Generated
        private List<String> labels;
        @Generated
        private boolean originContext$set;
        @Generated
        private OriginContext originContext$value;
        @Generated
        private boolean metadata$set;
        @Generated
        private Map<String, Object> metadata$value;
        @Generated
        private ApiLifecycleState lifecycleState;
        @Generated
        private WorkflowState workflowState;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private String background;
        @Generated
        private String backgroundUrl;
        @Generated
        private String referenceType;
        @Generated
        private String referenceId;

        @Generated
        NativeApiEntityBuilder() {
        }

        @Generated
        public NativeApiEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder crossId(String crossId) {
            this.crossId = crossId;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder type(ApiType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder deployedAt(Date deployedAt) {
            this.deployedAt = deployedAt;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder tags(Set<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder listeners(List<NativeListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder endpointGroups(List<NativeEndpointGroup> endpointGroups) {
            this.endpointGroups = endpointGroups;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder properties(List<Property> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder resources(List<Resource> resources) {
            this.resources$value = resources;
            this.resources$set = true;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder plans(Set<NativePlanEntity> plans) {
            this.plans$value = plans;
            this.plans$set = true;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder flows(List<NativeFlow> flows) {
            this.flows = flows;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder services(NativeApiServices services) {
            this.services = services;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder state(Lifecycle.State state) {
            this.state$value = state;
            this.state$set = true;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder primaryOwner(PrimaryOwnerEntity primaryOwner) {
            this.primaryOwner = primaryOwner;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder picture(String picture) {
            this.picture = picture;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder categories(Set<String> categories) {
            this.categories = categories;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder originContext(OriginContext originContext) {
            this.originContext$value = originContext;
            this.originContext$set = true;
            return this;
        }

        @JsonIgnore
        @Generated
        public NativeApiEntityBuilder metadata(Map<String, Object> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder lifecycleState(ApiLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder workflowState(WorkflowState workflowState) {
            this.workflowState = workflowState;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder background(String background) {
            this.background = background;
            return this;
        }

        @Generated
        public NativeApiEntityBuilder backgroundUrl(String backgroundUrl) {
            this.backgroundUrl = backgroundUrl;
            return this;
        }

        @JsonIgnore
        @Generated
        public NativeApiEntityBuilder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @JsonIgnore
        @Generated
        public NativeApiEntityBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Generated
        public NativeApiEntity build() {
            ApiType type$value = this.type$value;
            if (!this.type$set) {
                type$value = NativeApiEntity.$default$type();
            }
            Set<String> tags$value = this.tags$value;
            if (!this.tags$set) {
                tags$value = NativeApiEntity.$default$tags();
            }
            List<Property> properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = NativeApiEntity.$default$properties();
            }
            List<Resource> resources$value = this.resources$value;
            if (!this.resources$set) {
                resources$value = NativeApiEntity.$default$resources();
            }
            Set<NativePlanEntity> plans$value = this.plans$value;
            if (!this.plans$set) {
                plans$value = NativeApiEntity.$default$plans();
            }
            Lifecycle.State state$value = this.state$value;
            if (!this.state$set) {
                state$value = NativeApiEntity.$default$state();
            }
            OriginContext originContext$value = this.originContext$value;
            if (!this.originContext$set) {
                originContext$value = NativeApiEntity.$default$originContext();
            }
            Map<String, Object> metadata$value = this.metadata$value;
            if (!this.metadata$set) {
                metadata$value = NativeApiEntity.$default$metadata();
            }
            return new NativeApiEntity(this.id, this.crossId, this.name, this.apiVersion, this.definitionVersion, type$value, this.deployedAt, this.createdAt, this.updatedAt, this.description, tags$value, this.listeners, this.endpointGroups, properties$value, resources$value, plans$value, this.flows, this.services, this.groups, this.visibility, state$value, this.primaryOwner, this.picture, this.pictureUrl, this.categories, this.labels, originContext$value, metadata$value, this.lifecycleState, this.workflowState, this.disableMembershipNotifications, this.background, this.backgroundUrl, this.referenceType, this.referenceId);
        }

        @Generated
        public String toString() {
            return "NativeApiEntity.NativeApiEntityBuilder(id=" + this.id + ", crossId=" + this.crossId + ", name=" + this.name + ", apiVersion=" + this.apiVersion + ", definitionVersion=" + this.definitionVersion + ", type$value=" + this.type$value + ", deployedAt=" + this.deployedAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", description=" + this.description + ", tags$value=" + this.tags$value + ", listeners=" + this.listeners + ", endpointGroups=" + this.endpointGroups + ", properties$value=" + this.properties$value + ", resources$value=" + this.resources$value + ", plans$value=" + this.plans$value + ", flows=" + this.flows + ", services=" + this.services + ", groups=" + this.groups + ", visibility=" + this.visibility + ", state$value=" + this.state$value + ", primaryOwner=" + this.primaryOwner + ", picture=" + this.picture + ", pictureUrl=" + this.pictureUrl + ", categories=" + this.categories + ", labels=" + this.labels + ", originContext$value=" + this.originContext$value + ", metadata$value=" + this.metadata$value + ", lifecycleState=" + this.lifecycleState + ", workflowState=" + this.workflowState + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", background=" + this.background + ", backgroundUrl=" + this.backgroundUrl + ", referenceType=" + this.referenceType + ", referenceId=" + this.referenceId + ")";
        }
    }
}

