/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.PropertyEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.jackson.PropertiesEntityAsListDeserializer;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class ApiCRDEntity {
    @Schema(description="API's ID.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    @NotNull
    @NotEmpty
    private String id;
    @Schema(description="API's crossId. Identifies API across environments.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    @NotNull
    @NotEmpty
    private String crossId;
    @NotNull
    @NotEmpty(message="Api's name must not be empty")
    @Schema(description="Api's name. Duplicate names can exists.", example="My Api")
    private @NotNull @NotEmpty(message="Api's name must not be empty") String name;
    @NotNull
    @NotEmpty
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String version;
    @NotNull
    @NotEmpty
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="Api's execution mode. Define if the execution mode should use v3 or jupiter mode.", example="v3")
    @DeploymentRequired
    @JsonProperty(value="execution_mode")
    private ExecutionMode executionMode;
    @JsonProperty(value="proxy", required=true)
    @Schema(description="API's definition.")
    private Proxy proxy;
    @JsonProperty(value="flows")
    @Schema(description="a list of flows (the policies configuration)")
    private List<Flow> flows = new ArrayList<Flow>();
    @JsonProperty(value="plans")
    @Schema(description="a list of plans with flows (the policies configuration)")
    private Set<PlanEntity> plans = new HashSet<PlanEntity>();
    @Schema(description="The configuration of API services like the dynamic properties, the endpoint discovery or the healthcheck.")
    private Services services;
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    private List<Resource> resources = new ArrayList<Resource>();
    @JsonProperty(value="properties")
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    private PropertiesEntity properties;
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility = Visibility.PRIVATE;
    @Schema(description="the list of sharding tags associated with this API.", example="public, private")
    private Set<String> tags;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @DeploymentRequired
    @JsonProperty(value="gravitee")
    @Schema(description="API's gravitee definition version")
    private String graviteeDefinitionVersion;
    @DeploymentRequired
    @JsonProperty(value="flow_mode")
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @JsonProperty(value="picture_url")
    @Schema(description="the API logo URL")
    private String pictureUrl;
    @Schema(description="the list of categories associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @JsonProperty(value="path_mappings")
    @Schema(description="A list of paths used to aggregate data in analytics", example="/products/:productId, /products/:productId/media")
    private Set<String> pathMappings;
    @JsonProperty(value="response_templates")
    @Schema(description="A map that allows you to configure the output of a request based on the event throws by the gateway. Example : Quota exceeded, api-ky is missing, ...")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates;
    private List<ApiMetadataEntity> metadata;
    @JsonProperty(value="lifecycle_state")
    private ApiLifecycleState lifecycleState;
    private boolean notifyMembers;
    @Schema(description="the API background encoded in base64")
    private String background;
    @JsonProperty(value="background_url")
    @Schema(description="the API background URL")
    private String backgroundUrl;
    @Schema(hidden=true, description="The API's lifecycle state has been added for the kubernetes operator only.")
    private Lifecycle.State state;
    @JsonProperty(value="definition_context")
    private DefinitionContext definitionContext;
    @Schema(description="List of API members")
    private List<Member> members;
    @Schema(description="List of API pages")
    private Map<String, PageCRD> pages;

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    @JsonIgnore
    public void setProperties(PropertiesEntity properties) {
        this.properties = properties;
    }

    public boolean isDisableMembershipNotifications() {
        return !this.notifyMembers;
    }

    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.notifyMembers = !disableMembershipNotifications;
    }

    public List<PageCRD> getPages() {
        return this.pages == null ? List.of() : this.pages.values().stream().collect(Collectors.toList());
    }

    public Map<String, PageCRD> getPagesMap() {
        return this.pages == null ? Map.of() : this.pages;
    }

    @JsonSetter(value="properties")
    @JsonDeserialize(using=PropertiesEntityAsListDeserializer.class)
    public void setPropertyList(List<PropertyEntity> properties) {
        this.properties = new PropertiesEntity(properties);
    }

    @JsonGetter(value="properties")
    public List<PropertyEntity> getPropertyList() {
        if (this.properties != null) {
            return this.properties.getProperties();
        }
        return Collections.emptyList();
    }

    public Map<String, String> planIdMapping() {
        if (!CollectionUtils.isEmpty(this.plans)) {
            return this.plans.stream().collect(Collectors.toMap(BasePlanEntity::getCrossId, BasePlanEntity::getId));
        }
        return Collections.emptyMap();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Set<PlanEntity> getPlans() {
        return this.plans;
    }

    @Generated
    public Services getServices() {
        return this.services;
    }

    @Generated
    public List<Resource> getResources() {
        return this.resources;
    }

    @Generated
    public PropertiesEntity getProperties() {
        return this.properties;
    }

    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getGraviteeDefinitionVersion() {
        return this.graviteeDefinitionVersion;
    }

    @Generated
    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    @Generated
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    @Generated
    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    @Generated
    public List<ApiMetadataEntity> getMetadata() {
        return this.metadata;
    }

    @Generated
    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public boolean isNotifyMembers() {
        return this.notifyMembers;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    @Generated
    public Lifecycle.State getState() {
        return this.state;
    }

    @Generated
    public DefinitionContext getDefinitionContext() {
        return this.definitionContext;
    }

    @Generated
    public List<Member> getMembers() {
        return this.members;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="execution_mode")
    @Generated
    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @JsonProperty(value="proxy", required=true)
    @Generated
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @JsonProperty(value="flows")
    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @JsonProperty(value="plans")
    @Generated
    public void setPlans(Set<PlanEntity> plans) {
        this.plans = plans;
    }

    @Generated
    public void setServices(Services services) {
        this.services = services;
    }

    @Generated
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="gravitee")
    @Generated
    public void setGraviteeDefinitionVersion(String graviteeDefinitionVersion) {
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
    }

    @JsonProperty(value="flow_mode")
    @Generated
    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    @JsonProperty(value="picture_url")
    @Generated
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @JsonProperty(value="path_mappings")
    @Generated
    public void setPathMappings(Set<String> pathMappings) {
        this.pathMappings = pathMappings;
    }

    @JsonProperty(value="response_templates")
    @Generated
    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    @Generated
    public void setMetadata(List<ApiMetadataEntity> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="lifecycle_state")
    @Generated
    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public void setNotifyMembers(boolean notifyMembers) {
        this.notifyMembers = notifyMembers;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @JsonProperty(value="background_url")
    @Generated
    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    @Generated
    public void setState(Lifecycle.State state) {
        this.state = state;
    }

    @JsonProperty(value="definition_context")
    @Generated
    public void setDefinitionContext(DefinitionContext definitionContext) {
        this.definitionContext = definitionContext;
    }

    @Generated
    public void setMembers(List<Member> members) {
        this.members = members;
    }

    @Generated
    public void setPages(Map<String, PageCRD> pages) {
        this.pages = pages;
    }

    public static class PageCRD
    extends PageEntity {
        private DefinitionContext definitionContext;

        @Generated
        public void setDefinitionContext(DefinitionContext definitionContext) {
            this.definitionContext = definitionContext;
        }

        @Generated
        public DefinitionContext getDefinitionContext() {
            return this.definitionContext;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PageCRD)) {
                return false;
            }
            PageCRD other = (PageCRD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DefinitionContext this$definitionContext = this.getDefinitionContext();
            DefinitionContext other$definitionContext = other.getDefinitionContext();
            return !(this$definitionContext == null ? other$definitionContext != null : !this$definitionContext.equals(other$definitionContext));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PageCRD;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            DefinitionContext $definitionContext = this.getDefinitionContext();
            result = result * 59 + ($definitionContext == null ? 43 : $definitionContext.hashCode());
            return result;
        }
    }

    public static class Member {
        private String source;
        private String sourceId;
        private String role;

        @Generated
        public void setSource(String source) {
            this.source = source;
        }

        @Generated
        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Generated
        public void setRole(String role) {
            this.role = role;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getSourceId() {
            return this.sourceId;
        }

        @Generated
        public String getRole() {
            return this.role;
        }

        @Generated
        public Member(String source, String sourceId, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.role = role;
        }

        @Generated
        public Member() {
        }
    }
}

