/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

public class NewApiEntity {
    @NotNull
    @NotEmpty(message="Api's name must not be empty")
    @Schema(description="Api's name. Duplicate names can exists.", example="My Api")
    private @NotNull @NotEmpty(message="Api's name must not be empty") String name;
    @NotNull
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String version;
    @NotNull
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @NotNull
    @Schema(description="API's context path.", example="/my-awesome-api")
    private String contextPath;
    @NotNull
    @Schema(description="API's first endpoint (target url).", example="https://local-dc:8081/api")
    private String endpoint;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Schema(description="API's paths. A json representation of the design of each path.")
    private List<String> paths;
    @Schema(description="API's paths. A json representation of the design of each flow.")
    private List<Flow> flows;
    @JsonProperty(value="flow_mode")
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @JsonProperty(value="gravitee")
    @Schema(description="API's gravitee definition version")
    private String graviteeDefinitionVersion;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    public String getGraviteeDefinitionVersion() {
        return this.graviteeDefinitionVersion;
    }

    public void setGraviteeDefinitionVersion(String graviteeDefinitionVersion) {
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
    }

    public String toString() {
        return "NewApiEntity{name='" + this.name + "', version='" + this.version + "', description='" + this.description + "', contextPath='" + this.contextPath + "', endpoint='" + this.endpoint + "', groups='" + this.groups + "', flowMode='" + this.flowMode + "'}";
    }
}

